/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.menu.coal_generator;

import dev.aaronhowser.mods.aaron.menu.components.FilteredSlot;
import dev.aaronhowser.mods.geneticsresequenced.block.block_entity.CoalGeneratorBlockEntity;
import dev.aaronhowser.mods.geneticsresequenced.datagen.lang.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.menu.MachineMenu;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModMenuTypes;
import java.text.NumberFormat;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bB\u0019\b\u0016\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\rJ\u0006\u0010\u0011\u001a\u00020\u0003J\u0006\u0010\u0012\u001a\u00020\u0003J\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u0003X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/menu/coal_generator/CoalGeneratorMenu;", "Ldev/aaronhowser/mods/geneticsresequenced/menu/MachineMenu;", "id", "", "playerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "coalGeneratorContainer", "Lnet/minecraft/world/Container;", "craftingContainerData", "Lnet/minecraft/world/inventory/ContainerData;", "<init>", "(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/Container;Lnet/minecraft/world/inventory/ContainerData;)V", "containerId", "(ILnet/minecraft/world/entity/player/Inventory;)V", "amountSlots", "getAmountSlots", "()I", "getMaxBurnTime", "getBurnTimeRemaining", "isBurning", "", "addSlots", "", "getPercentDone", "", "stillValid", "player", "Lnet/minecraft/world/entity/player/Player;", "Companion", "geneticsresequenced-1.21.1"})
public final class CoalGeneratorMenu
extends MachineMenu {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Container coalGeneratorContainer;
    @NotNull
    private final ContainerData craftingContainerData;
    private final int amountSlots;

    public CoalGeneratorMenu(int id, @NotNull Inventory playerInventory, @NotNull Container coalGeneratorContainer, @NotNull ContainerData craftingContainerData) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)coalGeneratorContainer, (String)"coalGeneratorContainer");
        Intrinsics.checkNotNullParameter((Object)craftingContainerData, (String)"craftingContainerData");
        Object object = ModMenuTypes.INSTANCE.getCOAL_GENERATOR().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((MenuType)object, id, playerInventory, craftingContainerData);
        this.coalGeneratorContainer = coalGeneratorContainer;
        this.craftingContainerData = craftingContainerData;
        this.amountSlots = 1;
        AbstractContainerMenu.checkContainerSize((Container)this.coalGeneratorContainer, (int)1);
        this.addSlots();
    }

    public CoalGeneratorMenu(int containerId, @NotNull Inventory playerInventory) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        this(containerId, playerInventory, (Container)new SimpleContainer(1), (ContainerData)new SimpleContainerData(4));
    }

    @Override
    protected int getAmountSlots() {
        return this.amountSlots;
    }

    public final int getMaxBurnTime() {
        return this.craftingContainerData.get(1);
    }

    public final int getBurnTimeRemaining() {
        return this.craftingContainerData.get(0);
    }

    public final boolean isBurning() {
        return this.getBurnTimeRemaining() > 0;
    }

    public void addSlots() {
        FilteredSlot slot = new FilteredSlot(this.coalGeneratorContainer, 0, 52, 40, CoalGeneratorMenu::addSlots$lambda$0);
        this.addSlot((Slot)slot);
    }

    @Override
    public float getPercentDone() {
        int max = this.getMaxBurnTime();
        if (max == 0) {
            return 0.0f;
        }
        return 1.0f - (float)this.getBurnTimeRemaining() / (float)max;
    }

    public boolean stillValid(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.coalGeneratorContainer.stillValid(player);
    }

    private static final boolean addSlots$lambda$0(ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getBurnTime(RecipeType.SMELTING) > 0;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/menu/coal_generator/CoalGeneratorMenu$Companion;", "", "<init>", "()V", "showFuelTooltip", "", "event", "Lnet/neoforged/neoforge/event/entity/player/ItemTooltipEvent;", "geneticsresequenced-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public final void showFuelTooltip(@NotNull ItemTooltipEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            ItemStack itemStack = event.getItemStack();
            int fuelPer = itemStack.getBurnTime(RecipeType.SMELTING);
            if (fuelPer <= 0) {
                return;
            }
            int feProducedPer = CoalGeneratorBlockEntity.Companion.getEnergyPerTick() * fuelPer;
            String feStringPer = NumberFormat.getNumberInstance().format((Object)feProducedPer);
            event.getToolTip().add(1, Component.literal((String)(feStringPer + " FE")).withStyle(ChatFormatting.GRAY));
            int amount = itemStack.getCount();
            if (amount > 1) {
                int feProducedTotal = feProducedPer * amount;
                String feStringTotal = NumberFormat.getNumberInstance().format((Object)feProducedTotal);
                Object[] objectArray = new Object[]{feStringTotal};
                event.getToolTip().add(2, ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.coal_generator.total_fe", objectArray).withStyle(ChatFormatting.GRAY));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

