/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import dev.aaronhowser.mods.geneticsresequenced.gene.behavior.OtherGenes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @ModifyReturnValue(method={"isCurrentlyGlowing"}, at={@At(value="RETURN")})
    private boolean geneticsresequenced$glowFromMobSight(boolean original) {
        if (original) {
            return true;
        }
        LivingEntity self = (LivingEntity)this;
        return OtherGenes.shouldMobGlowFromMobSight(self);
    }

    public void makeStuckInBlock(BlockState state, Vec3 motionMultiplier) {
        LivingEntity self = (LivingEntity)this;
        if (OtherGenes.shouldNegateSlownessFromBlock(self, state)) {
            return;
        }
        super.makeStuckInBlock(state, motionMultiplier);
    }
}

