/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.recipe.incubator;

import com.mojang.serialization.MapCodec;
import dev.aaronhowser.mods.geneticsresequenced.datagen.tag.ModItemTagsProvider;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.item.DnaHelixItem;
import dev.aaronhowser.mods.geneticsresequenced.item.SyringeItem;
import dev.aaronhowser.mods.geneticsresequenced.recipe.base.AbstractIncubatorRecipe;
import dev.aaronhowser.mods.geneticsresequenced.recipe.base.IncubatorRecipeInput;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModPotions;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModRecipeSerializers;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016J\u001a\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u00122\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u0016"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/BlackDeathRecipe;", "Ldev/aaronhowser/mods/geneticsresequenced/recipe/base/AbstractIncubatorRecipe;", "<init>", "()V", "matches", "", "input", "Ldev/aaronhowser/mods/geneticsresequenced/recipe/base/IncubatorRecipeInput;", "level", "Lnet/minecraft/world/level/Level;", "assemble", "Lnet/minecraft/world/item/ItemStack;", "lookup", "Lnet/minecraft/core/HolderLookup$Provider;", "getResultItem", "getSerializer", "Lnet/minecraft/world/item/crafting/RecipeSerializer;", "getRequiredGenes", "", "Lnet/minecraft/core/Holder;", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene;", "Serializer", "geneticsresequenced-1.21.1"})
@SourceDebugExtension(value={"SMAP\nBlackDeathRecipe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlackDeathRecipe.kt\ndev/aaronhowser/mods/geneticsresequenced/recipe/incubator/BlackDeathRecipe\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n774#2:85\n865#2,2:86\n*S KotlinDebug\n*F\n+ 1 BlackDeathRecipe.kt\ndev/aaronhowser/mods/geneticsresequenced/recipe/incubator/BlackDeathRecipe\n*L\n62#1:85\n62#1:86,2\n*E\n"})
public final class BlackDeathRecipe
extends AbstractIncubatorRecipe {
    @NotNull
    public static final BlackDeathRecipe INSTANCE = new BlackDeathRecipe();

    private BlackDeathRecipe() {
        Ingredient ingredient = Ingredient.of(ModItemTagsProvider.Companion.getSYRINGES());
        Intrinsics.checkNotNullExpressionValue((Object)ingredient, (String)"of(...)");
        Ingredient ingredient2 = DataComponentIngredient.of((boolean)false, (ItemStack)OtherUtil.INSTANCE.getPotionStack((Holder<Potion>)((Holder)ModPotions.INSTANCE.getVIRAL_AGENTS())));
        Intrinsics.checkNotNullExpressionValue((Object)ingredient2, (String)"of(...)");
        super(ingredient, ingredient2);
    }

    public boolean matches(@NotNull IncubatorRecipeInput input, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        ItemStack syringeStack = input.getTopItem();
        ItemStack potionStack = input.getBottomItem();
        if (!this.getTopIngredient().test(syringeStack)) {
            return false;
        }
        if (!this.getBottomIngredient().test(potionStack)) {
            return false;
        }
        if (!SyringeItem.Companion.hasBlood(syringeStack) || SyringeItem.Companion.isContaminated(syringeStack)) {
            return false;
        }
        Set<Holder<Gene>> syringeGenes = SyringeItem.Companion.getGenes(syringeStack);
        RegistryAccess registryAccess = level.registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        List<Holder<Gene>> requiredGenes = this.getRequiredGenes((HolderLookup.Provider)registryAccess);
        return syringeGenes.containsAll((Collection)requiredGenes);
    }

    @NotNull
    public ItemStack assemble(@NotNull IncubatorRecipeInput input, @NotNull HolderLookup.Provider lookup) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        return this.getResultItem(lookup);
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider lookup) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        return DnaHelixItem.Companion.getHelixStack((Holder<Gene>)((Holder)ModGenes.INSTANCE.getHolderOrThrow(ModGenes.BLACK_DEATH, lookup)));
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        Object object = ModRecipeSerializers.INSTANCE.getBLACK_DEATH().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (RecipeSerializer)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Holder<Gene>> getRequiredGenes(@NotNull HolderLookup.Provider lookup) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        Iterable $this$filter$iv = ModGenes.getRegistrySorted$default(ModGenes.INSTANCE, lookup, false, false, 6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Holder it = (Holder)element$iv$iv;
            boolean bl = false;
            if (!(Gene.Companion.isNegative((Holder<Gene>)it) && !Gene.Companion.isHelixOnly((Holder<Gene>)it) && !Gene.Companion.isDisabled((Holder<Gene>)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.minus((Iterable)((List)destination$iv$iv), ModGenes.INSTANCE.getHolderOrThrow(ModGenes.BLACK_DEATH, lookup));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0016J\u0014\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/BlackDeathRecipe$Serializer;", "Lnet/minecraft/world/item/crafting/RecipeSerializer;", "Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/BlackDeathRecipe;", "<init>", "()V", "codec", "Lcom/mojang/serialization/MapCodec;", "streamCodec", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "Companion", "geneticsresequenced-1.21.1"})
    public static final class Serializer
    implements RecipeSerializer<BlackDeathRecipe> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final MapCodec<BlackDeathRecipe> CODEC;
        @NotNull
        private static final StreamCodec<RegistryFriendlyByteBuf, BlackDeathRecipe> STREAM_CODEC;

        @NotNull
        public MapCodec<BlackDeathRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, BlackDeathRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        static {
            MapCodec mapCodec = MapCodec.unit((Object)INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"unit(...)");
            CODEC = mapCodec;
            StreamCodec streamCodec = StreamCodec.unit((Object)INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"unit(...)");
            STREAM_CODEC = streamCodec;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/BlackDeathRecipe$Serializer$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/MapCodec;", "Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/BlackDeathRecipe;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "getSTREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "geneticsresequenced-1.21.1"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final MapCodec<BlackDeathRecipe> getCODEC() {
                return CODEC;
            }

            @NotNull
            public final StreamCodec<RegistryFriendlyByteBuf, BlackDeathRecipe> getSTREAM_CODEC() {
                return STREAM_CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

