/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.recipe.incubator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.item.DnaHelixItem;
import dev.aaronhowser.mods.geneticsresequenced.item.EntityDnaItem;
import dev.aaronhowser.mods.geneticsresequenced.item.GmoCell;
import dev.aaronhowser.mods.geneticsresequenced.recipe.base.AbstractIncubatorRecipe;
import dev.aaronhowser.mods.geneticsresequenced.recipe.base.IncubatorRecipeInput;
import dev.aaronhowser.mods.geneticsresequenced.recipe.incubator.DupeCellRecipe;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModPotions;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModRecipeSerializers;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\f\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0006\u00a8\u0006\u0014"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/DupeCellRecipe;", "Ldev/aaronhowser/mods/geneticsresequenced/recipe/base/AbstractIncubatorRecipe;", "isGmoCell", "", "<init>", "(Z)V", "()Z", "matches", "input", "Ldev/aaronhowser/mods/geneticsresequenced/recipe/base/IncubatorRecipeInput;", "level", "Lnet/minecraft/world/level/Level;", "assemble", "Lnet/minecraft/world/item/ItemStack;", "lookup", "Lnet/minecraft/core/HolderLookup$Provider;", "getResultItem", "getSerializer", "Lnet/minecraft/world/item/crafting/RecipeSerializer;", "Serializer", "geneticsresequenced-1.21.1"})
public final class DupeCellRecipe
extends AbstractIncubatorRecipe {
    private final boolean isGmoCell;

    public DupeCellRecipe(boolean isGmoCell) {
        ItemLike[] itemLikeArray = new ItemLike[]{isGmoCell ? (Item)ModItems.INSTANCE.getGMO_CELL().get() : (Item)ModItems.INSTANCE.getCELL().get()};
        Ingredient ingredient = Ingredient.of((ItemLike[])itemLikeArray);
        Intrinsics.checkNotNullExpressionValue((Object)ingredient, (String)"of(...)");
        Ingredient ingredient2 = DataComponentIngredient.of((boolean)false, (ItemStack)OtherUtil.INSTANCE.getPotionStack((Holder<Potion>)((Holder)ModPotions.INSTANCE.getSUBSTRATE())));
        Intrinsics.checkNotNullExpressionValue((Object)ingredient2, (String)"of(...)");
        super(ingredient, ingredient2);
        this.isGmoCell = isGmoCell;
    }

    public /* synthetic */ DupeCellRecipe(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public final boolean isGmoCell() {
        return this.isGmoCell;
    }

    public boolean matches(@NotNull IncubatorRecipeInput input, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        ItemStack topStack = input.getTopItem();
        ItemStack potionStack = input.getBottomItem();
        if (!this.getTopIngredient().test(topStack)) {
            return false;
        }
        if (!this.getBottomIngredient().test(potionStack)) {
            return false;
        }
        return EntityDnaItem.Companion.hasEntity(topStack);
    }

    @NotNull
    public ItemStack assemble(@NotNull IncubatorRecipeInput input, @NotNull HolderLookup.Provider lookup) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        ItemStack topStack = input.getTopItem();
        EntityType<?> entityType = EntityDnaItem.Companion.getEntityType(topStack);
        if (entityType == null) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        EntityType<?> ingredientEntity = entityType;
        ItemStack outputCell = null;
        if (this.isGmoCell) {
            Holder<Gene> holder = DnaHelixItem.Companion.getGeneHolder(topStack);
            if (holder == null) {
                ItemStack itemStack = ItemStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                return itemStack;
            }
            Holder<Gene> pIngredientGene = holder;
            ItemStack itemStack = ModItems.INSTANCE.getGMO_CELL().toStack();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"toStack(...)");
            outputCell = itemStack;
            GmoCell.Companion.setDetails(outputCell, ingredientEntity, pIngredientGene);
        } else {
            ItemStack itemStack = ModItems.INSTANCE.getCELL().toStack();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"toStack(...)");
            outputCell = itemStack;
            EntityDnaItem.Companion.setEntityType(outputCell, ingredientEntity);
        }
        return outputCell;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider lookup) {
        ItemStack itemStack;
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        if (this.isGmoCell) {
            ItemStack itemStack2 = ModItems.INSTANCE.getGMO_CELL().toStack();
            itemStack = itemStack2;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"toStack(...)");
        } else {
            ItemStack itemStack3 = ModItems.INSTANCE.getCELL().toStack();
            itemStack = itemStack3;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack3, (String)"toStack(...)");
        }
        return itemStack;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        Object object = ModRecipeSerializers.INSTANCE.getDUPE_CELL().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (RecipeSerializer)object;
    }

    public DupeCellRecipe() {
        this(false, 1, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0016J\u0014\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/DupeCellRecipe$Serializer;", "Lnet/minecraft/world/item/crafting/RecipeSerializer;", "Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/DupeCellRecipe;", "<init>", "()V", "codec", "Lcom/mojang/serialization/MapCodec;", "streamCodec", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "Companion", "geneticsresequenced-1.21.1"})
    public static final class Serializer
    implements RecipeSerializer<DupeCellRecipe> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final MapCodec<DupeCellRecipe> CODEC;
        @NotNull
        private static final StreamCodec<RegistryFriendlyByteBuf, DupeCellRecipe> STREAM_CODEC;

        @NotNull
        public MapCodec<DupeCellRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, DupeCellRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static final Boolean CODEC$lambda$1$lambda$0(KProperty1 $tmp0, DupeCellRecipe p0) {
            return (Boolean)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final App CODEC$lambda$1(RecordCodecBuilder.Instance instance) {
            return instance.group((App)Codec.BOOL.optionalFieldOf("is_gmo_cell", (Object)false).forGetter(arg_0 -> Serializer.CODEC$lambda$1$lambda$0((KProperty1)Companion.CODEC.1.1.INSTANCE, arg_0))).apply((Applicative)instance, DupeCellRecipe::new);
        }

        private static final Boolean STREAM_CODEC$lambda$2(KProperty1 $tmp0, DupeCellRecipe p0) {
            return (Boolean)((Function1)$tmp0).invoke((Object)p0);
        }

        static {
            MapCodec mapCodec = RecordCodecBuilder.mapCodec(Serializer::CODEC$lambda$1);
            Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"mapCodec(...)");
            CODEC = mapCodec;
            StreamCodec streamCodec = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, arg_0 -> Serializer.STREAM_CODEC$lambda$2((KProperty1)Companion.STREAM_CODEC.1.INSTANCE, arg_0), DupeCellRecipe::new);
            Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"composite(...)");
            STREAM_CODEC = streamCodec;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/DupeCellRecipe$Serializer$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/MapCodec;", "Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/DupeCellRecipe;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "getSTREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "geneticsresequenced-1.21.1"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final MapCodec<DupeCellRecipe> getCODEC() {
                return CODEC;
            }

            @NotNull
            public final StreamCodec<RegistryFriendlyByteBuf, DupeCellRecipe> getSTREAM_CODEC() {
                return STREAM_CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

