/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.util;

import dev.aaronhowser.mods.aaron.AaronExtensions;
import dev.aaronhowser.mods.aaron.client.AaronClientUtil;
import dev.aaronhowser.mods.aaron.scheduler.SchedulerExtensions;
import dev.aaronhowser.mods.geneticsresequenced.GeneticsResequenced;
import dev.aaronhowser.mods.geneticsresequenced.attachment.GenesData;
import dev.aaronhowser.mods.geneticsresequenced.config.ClientConfig;
import dev.aaronhowser.mods.geneticsresequenced.datagen.lang.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.gene.behavior.ClickGenes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.language.LanguageManager;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\u0018\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\t2\b\b\u0002\u0010\u001d\u001a\u00020\u0015J\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 H\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/util/ClientUtil;", "", "<init>", "()V", "localRegistryAccess", "Lnet/minecraft/core/RegistryAccess;", "getLocalRegistryAccess", "()Lnet/minecraft/core/RegistryAccess;", "playerIsCreative", "", "options", "Lnet/minecraft/client/Options;", "getOptions", "()Lnet/minecraft/client/Options;", "removedSkinLayers", "", "Lnet/minecraft/world/entity/player/PlayerModelPart;", "shearPlayerSkin", "", "addSkinLayersBack", "value", "", "amountTryingToChangeLanguage", "setAmountTryingToChangeLanguage", "(I)V", "nonCringeLanguage", "", "handleCringe", "wasAdded", "countdownSeconds", "shouldHidePotionInInventory", "mobEffectInstance", "Lnet/minecraft/world/effect/MobEffectInstance;", "geneticsresequenced-1.21.1"})
public final class ClientUtil {
    @NotNull
    public static final ClientUtil INSTANCE = new ClientUtil();
    @NotNull
    private static Set<? extends PlayerModelPart> removedSkinLayers = SetsKt.emptySet();
    private static int amountTryingToChangeLanguage;
    @Nullable
    private static String nonCringeLanguage;

    private ClientUtil() {
    }

    @Nullable
    public final RegistryAccess getLocalRegistryAccess() {
        ClientLevel clientLevel = Minecraft.getInstance().level;
        return clientLevel != null ? clientLevel.registryAccess() : null;
    }

    public final boolean playerIsCreative() {
        Player player = AaronClientUtil.getLocalPlayer();
        return AaronExtensions.INSTANCE.isTrue(player != null ? Boolean.valueOf(player.isCreative()) : null);
    }

    private final Options getOptions() {
        Options options = Minecraft.getInstance().options;
        Intrinsics.checkNotNullExpressionValue((Object)options, (String)"options");
        return options;
    }

    public final void shearPlayerSkin() {
        Set set = this.getOptions().modelParts;
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"modelParts");
        Set enabledModelParts = CollectionsKt.toMutableSet((Iterable)set);
        if (!((Boolean)ClientConfig.Companion.getWoolyRemovesCape().get()).booleanValue()) {
            enabledModelParts.remove(PlayerModelPart.CAPE);
        }
        for (PlayerModelPart part : enabledModelParts) {
            this.getOptions().toggleModelPart(part, false);
        }
        removedSkinLayers = enabledModelParts;
        GeneticsResequenced.Companion.getLOGGER().info("Sheared layers off player skin: " + CollectionsKt.joinToString$default((Iterable)removedSkinLayers, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
        Function0 addLayersBackTask = ClientUtil::shearPlayerSkin$lambda$0;
        ClickGenes.INSTANCE.getRECENTLY_SHEARED_ENTITIES().getCooldownEndedTasks().add((Function0<Unit>)addLayersBackTask);
    }

    public final void addSkinLayersBack() {
        if (removedSkinLayers.isEmpty()) {
            return;
        }
        for (PlayerModelPart playerModelPart : removedSkinLayers) {
            this.getOptions().toggleModelPart(playerModelPart, true);
        }
        GeneticsResequenced.Companion.getLOGGER().info("Added layers back to player skin: " + CollectionsKt.joinToString$default((Iterable)removedSkinLayers, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
        removedSkinLayers = SetsKt.emptySet();
    }

    private final void setAmountTryingToChangeLanguage(int value) {
        amountTryingToChangeLanguage = RangesKt.coerceAtLeast((int)value, (int)0);
    }

    public final void handleCringe(boolean wasAdded, int countdownSeconds) {
        Holder.Reference<Gene> cringe2;
        RegistryAccess access = this.getLocalRegistryAccess();
        if (access != null && Gene.Companion.isDisabled((Holder<Gene>)((Holder)(cringe2 = ModGenes.INSTANCE.getHolderOrThrow(ModGenes.CRINGE, (HolderLookup.Provider)access))))) {
            return;
        }
        if (((Boolean)ClientConfig.Companion.getDisableCringeLangChange().get()).booleanValue()) {
            GeneticsResequenced.Companion.getLOGGER().info("Cringe language-changing is disabled in the config!");
            return;
        }
        LanguageManager languageManager = Minecraft.getInstance().getLanguageManager();
        String currentLanguage = languageManager.getSelected();
        String lolcat = "lol_us";
        if (wasAdded) {
            Intrinsics.checkNotNull((Object)currentLanguage);
            if (!StringsKt.startsWith$default((String)currentLanguage, (String)"en_", (boolean)false, (int)2, null)) {
                GeneticsResequenced.Companion.getLOGGER().warn("Cringe language-changing is only available in English!");
                return;
            }
            nonCringeLanguage = currentLanguage;
            languageManager.setSelected(lolcat);
            GeneticsResequenced.Companion.getLOGGER().info("Changed language to cringe!");
        } else {
            if (!Intrinsics.areEqual((Object)languageManager.getSelected(), (Object)lolcat)) {
                return;
            }
            if (nonCringeLanguage == null && Intrinsics.areEqual((Object)languageManager.getSelected(), (Object)lolcat)) {
                GeneticsResequenced.Companion.getLOGGER().warn("Tried to remove cringe language, but no non-cringe language was saved!");
                return;
            }
            String string = nonCringeLanguage;
            if (string == null) {
                string = "en_us";
            }
            languageManager.setSelected(string);
            nonCringeLanguage = null;
            GeneticsResequenced.Companion.getLOGGER().info("Changed language back to non-cringe!");
        }
        Player player = AaronClientUtil.getLocalPlayer();
        if (player == null) {
            return;
        }
        Player localPlayer = player;
        Level level = localPlayer.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        SchedulerExtensions.INSTANCE.scheduleTaskInTicks(level, 1, () -> ClientUtil.handleCringe$lambda$2(wasAdded, countdownSeconds, localPlayer));
        for (int secondsLeft = countdownSeconds; secondsLeft > 0; --secondsLeft) {
            int scheduleIn = 20 * (countdownSeconds - secondsLeft);
            if (scheduleIn == 0) continue;
            int secondsLeftFinal = secondsLeft;
            Level level2 = localPlayer.level();
            Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"level(...)");
            SchedulerExtensions.INSTANCE.scheduleTaskInTicks(level2, scheduleIn, () -> ClientUtil.handleCringe$lambda$3(secondsLeftFinal));
        }
        int n = amountTryingToChangeLanguage;
        this.setAmountTryingToChangeLanguage(n + 1);
        Level level3 = localPlayer.level();
        Intrinsics.checkNotNullExpressionValue((Object)level3, (String)"level(...)");
        SchedulerExtensions.INSTANCE.scheduleTaskInTicks(level3, 20 * countdownSeconds, () -> ClientUtil.handleCringe$lambda$5(localPlayer));
    }

    public static /* synthetic */ void handleCringe$default(ClientUtil clientUtil, boolean bl, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 10;
        }
        clientUtil.handleCringe(bl, n);
    }

    @JvmStatic
    public static final boolean shouldHidePotionInInventory(@NotNull MobEffectInstance mobEffectInstance) {
        Intrinsics.checkNotNullParameter((Object)mobEffectInstance, (String)"mobEffectInstance");
        Player player = AaronClientUtil.getLocalPlayer();
        if (player == null) {
            return false;
        }
        Player localPlayer = player;
        Set<Holder<Gene>> playerGeneHolders = GenesData.Companion.getGeneHolders((LivingEntity)localPlayer);
        for (Holder<Gene> geneHolder : playerGeneHolders) {
            List<Gene.PotionDetails> genePotions = ((Gene)geneHolder.value()).getPotionDetails();
            for (Gene.PotionDetails potionDetail : genePotions) {
                if (!Intrinsics.areEqual(potionDetail.getEffect(), (Object)mobEffectInstance.getEffect()) || potionDetail.getLevel() - 1 < mobEffectInstance.getAmplifier()) continue;
                return true;
            }
        }
        return false;
    }

    private static final Unit shearPlayerSkin$lambda$0() {
        INSTANCE.addSkinLayersBack();
        return Unit.INSTANCE;
    }

    private static final void handleCringe$sendSystemMessage(Player localPlayer, Component message) {
        localPlayer.sendSystemMessage(message);
    }

    private static final Style handleCringe$lambda$2$lambda$1(Style it) {
        return it.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.cringe.resources.tooltip", new Object[0])));
    }

    private static final void handleCringe$lambda$2(boolean $wasAdded, int $countdownSeconds, Player $localPlayer) {
        MutableComponent mutableComponent;
        if ($wasAdded) {
            Object[] objectArray = new Object[]{$countdownSeconds};
            mutableComponent = ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.cringe.resources.add", objectArray);
        } else {
            Object[] objectArray = new Object[]{$countdownSeconds};
            mutableComponent = ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.cringe.resources.remove", objectArray);
        }
        MutableComponent component = mutableComponent.withStyle(ClientUtil::handleCringe$lambda$2$lambda$1);
        Intrinsics.checkNotNull((Object)component);
        ClientUtil.handleCringe$sendSystemMessage($localPlayer, (Component)component);
    }

    private static final void handleCringe$lambda$3(int $secondsLeftFinal) {
        block0: {
            Player player = AaronClientUtil.getLocalPlayer();
            if (player == null) break block0;
            MutableComponent mutableComponent = Component.literal((String)($secondsLeftFinal + "..."));
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
            AaronExtensions.INSTANCE.status(player, (Component)mutableComponent);
        }
    }

    private static final Style handleCringe$lambda$5$lambda$4(Style it) {
        return it.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.cringe.resources.tooltip", new Object[0])));
    }

    private static final void handleCringe$lambda$5(Player $localPlayer) {
        MutableComponent mutableComponent = ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.cringe.resources.reloading", new Object[0]).withStyle(ClientUtil::handleCringe$lambda$5$lambda$4);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
        ClientUtil.handleCringe$sendSystemMessage($localPlayer, (Component)mutableComponent);
        if (amountTryingToChangeLanguage == 1) {
            Minecraft.getInstance().reloadResourcePacks();
            int n = amountTryingToChangeLanguage;
            INSTANCE.setAmountTryingToChangeLanguage(n + -1);
        } else {
            GeneticsResequenced.Companion.getLOGGER().warn("Tried to reload resources, but it would have caused a concurrency error!");
        }
    }
}

