/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag;

import dev.lopyluna.slag.client.render.CustomRenderedItemModel;
import dev.lopyluna.slag.client.render.CustomRenderedItems;
import java.util.Map;
import java.util.function.Function;
import net.createmod.catnip.registry.RegisteredObjectsHelper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ModelEvent;

@Mod(value="slag", dist={Dist.CLIENT})
public class SlagEmbersClient {
    public SlagEmbersClient(IEventBus modEventBus) {
        modEventBus.addListener(SlagEmbersClient::onModelBake);
        modEventBus.addListener(SlagEmbersClient::clientInit);
    }

    public static void clientInit(FMLClientSetupEvent event) {
    }

    public static void onModelBake(ModelEvent.ModifyBakingResult event) {
        Map modelRegistry = event.getModels();
        CustomRenderedItems.forEach(item -> SlagEmbersClient.swapModels(modelRegistry, SlagEmbersClient.getItemModelLocation(item), CustomRenderedItemModel::new));
    }

    public static <T extends BakedModel> void swapModels(Map<ModelResourceLocation, BakedModel> modelRegistry, ModelResourceLocation location, Function<BakedModel, T> factory) {
        modelRegistry.put(location, (BakedModel)factory.apply(modelRegistry.get(location)));
    }

    public static ModelResourceLocation getItemModelLocation(Item item) {
        return new ModelResourceLocation(RegisteredObjectsHelper.getKeyOrThrow((Item)item), "inventory");
    }
}

