/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content;

import com.mojang.datafixers.util.Function14;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import dev.lopyluna.slag.SlagEmbers;
import dev.lopyluna.slag.content.items.BakedModularToolItem;
import dev.lopyluna.slag.content.items.IToolPart;
import dev.lopyluna.slag.register.AllTags;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class AllUtils {
    public static <T> StreamCodec<ByteBuf, TagKey<T>> tagKeyStreamCodec(ResourceKey<? extends Registry<T>> registry) {
        return ResourceLocation.STREAM_CODEC.map(loc -> TagKey.create((ResourceKey)registry, (ResourceLocation)loc), TagKey::location);
    }

    public static List<ItemStack> getStacksFromTag(TagKey<Block> tag) {
        Optional opt = BuiltInRegistries.BLOCK.getTag(tag);
        if (opt.isEmpty()) {
            return List.of();
        }
        ArrayList<ItemStack> out = new ArrayList<ItemStack>();
        for (Holder holder : (HolderSet.Named)opt.get()) {
            ItemStack stack = AllUtils.getStackFromBlock((Block)holder.value(), true);
            if (stack.isEmpty()) continue;
            out.add(stack);
        }
        return out;
    }

    public static ItemStack getStackFromBlock(Block block, boolean requireHeater) {
        ItemStack stack;
        BlockState state = block.defaultBlockState();
        FluidState fState = state.getFluidState();
        if (!state.is(AllTags.MELTER_HEATER) && requireHeater) {
            return ItemStack.EMPTY;
        }
        if (state.getBlock() instanceof BaseFireBlock) {
            stack = Items.BLAZE_POWDER.getDefaultInstance();
        } else if (!fState.isEmpty()) {
            Fluid type = fState.getType();
            stack = type.getBucket().getDefaultInstance();
        } else {
            stack = state.getBlock().asItem().getDefaultInstance();
        }
        stack.set(DataComponents.ITEM_NAME, (Object)block.getName());
        if (stack.isEmpty()) {
            return stack.transmuteCopy((ItemLike)Items.BARRIER);
        }
        return stack;
    }

    public static void compressible9x(DataGenContext<Item, Item> c, RegistrateRecipeProvider p, Ingredient decompact, Ingredient compact, ItemLike decompactResult, ItemLike compactResult) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)compactResult, (int)1).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), decompact).unlockedBy("has_decompact", RegistrateRecipeProvider.has((ItemLike)decompactResult)).save((RecipeOutput)p, SlagEmbers.loc("crafting/ingot_to_block_" + c.getName()));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)decompactResult, (int)9).requires(compact).unlockedBy("has_compact", RegistrateRecipeProvider.has((ItemLike)compactResult)).save((RecipeOutput)p, SlagEmbers.loc("crafting/ingot_from_block_" + c.getName()));
    }

    public static ItemPredicate ingredientToPredicate(Ingredient ing) {
        ItemLike[] items = (ItemLike[])Arrays.stream(ing.getItems()).map(ItemStack::getItem).distinct().toArray(ItemLike[]::new);
        if (items.length == 0) {
            return ItemPredicate.Builder.item().of(new ItemLike[]{Items.AIR}).build();
        }
        return ItemPredicate.Builder.item().of(items).build();
    }

    private static Optional<Registry<Item>> itemRegistry() {
        MinecraftServer srv = ServerLifecycleHooks.getCurrentServer();
        if (srv != null) {
            return Optional.of(srv.registryAccess().registryOrThrow(Registries.ITEM));
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null) {
            return Optional.of(mc.level.registryAccess().registryOrThrow(Registries.ITEM));
        }
        return Optional.empty();
    }

    private static boolean eqOrSuperset(TagKey<Item> tag, TagKey<Item> child) {
        if (tag.equals(child)) {
            return true;
        }
        Optional<Registry<Item>> regOpt = AllUtils.itemRegistry();
        if (regOpt.isEmpty()) {
            return false;
        }
        Registry<Item> reg = regOpt.get();
        HolderSet.Named parentSet = reg.getTag(tag).orElse(null);
        HolderSet.Named childSet = reg.getTag(child).orElse(null);
        if (parentSet == null || childSet == null) {
            return false;
        }
        HashSet parent = new HashSet();
        parentSet.forEach(parent::add);
        for (Holder h : childSet) {
            if (parent.contains(h)) continue;
            return false;
        }
        return true;
    }

    public static Boolean matchesToolTag(BakedModularToolItem toolItem, ItemStack self, TagKey<Item> tag) {
        Boolean flag = null;
        for (IToolPart part : toolItem.getToolParts(self)) {
            switch (part.getPartSegment().getPath()) {
                case "pickaxe_head": {
                    flag = AllUtils.eqOrSuperset(tag, (TagKey<Item>)ItemTags.PICKAXES) ? Boolean.valueOf(true) : null;
                    break;
                }
                case "axe_head": {
                    flag = AllUtils.eqOrSuperset(tag, (TagKey<Item>)ItemTags.AXES) ? Boolean.valueOf(true) : null;
                    break;
                }
                case "shovel_head": {
                    flag = AllUtils.eqOrSuperset(tag, (TagKey<Item>)ItemTags.SHOVELS) ? Boolean.valueOf(true) : null;
                    break;
                }
                case "hoe_head": {
                    flag = AllUtils.eqOrSuperset(tag, (TagKey<Item>)ItemTags.HOES) ? Boolean.valueOf(true) : null;
                    break;
                }
                case "sword_blade": {
                    Boolean bl = flag = AllUtils.eqOrSuperset(tag, (TagKey<Item>)ItemTags.SWORDS) ? Boolean.valueOf(true) : null;
                }
            }
            if (flag == null) continue;
            break;
        }
        return flag;
    }

    public static <B, C, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> StreamCodec<B, C> streamComposite(final StreamCodec<? super B, T1> codec1, final Function<C, T1> getter1, final StreamCodec<? super B, T2> codec2, final Function<C, T2> getter2, final StreamCodec<? super B, T3> codec3, final Function<C, T3> getter3, final StreamCodec<? super B, T4> codec4, final Function<C, T4> getter4, final StreamCodec<? super B, T5> codec5, final Function<C, T5> getter5, final StreamCodec<? super B, T6> codec6, final Function<C, T6> getter6, final StreamCodec<? super B, T7> codec7, final Function<C, T7> getter7, final StreamCodec<? super B, T8> codec8, final Function<C, T8> getter8, final StreamCodec<? super B, T9> codec9, final Function<C, T9> getter9, final StreamCodec<? super B, T10> codec10, final Function<C, T10> getter10, final StreamCodec<? super B, T11> codec11, final Function<C, T11> getter11, final StreamCodec<? super B, T12> codec12, final Function<C, T12> getter12, final StreamCodec<? super B, T13> codec13, final Function<C, T13> getter13, final StreamCodec<? super B, T14> codec14, final Function<C, T14> getter14, final Function14<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, C> factory) {
        return new StreamCodec<B, C>(){

            @NotNull
            public C decode(@NotNull B b) {
                Object t1 = codec1.decode(b);
                Object t2 = codec2.decode(b);
                Object t3 = codec3.decode(b);
                Object t4 = codec4.decode(b);
                Object t5 = codec5.decode(b);
                Object t6 = codec6.decode(b);
                Object t7 = codec7.decode(b);
                Object t8 = codec8.decode(b);
                Object t9 = codec9.decode(b);
                Object t10 = codec10.decode(b);
                Object t11 = codec11.decode(b);
                Object t12 = codec12.decode(b);
                Object t13 = codec13.decode(b);
                Object t14 = codec14.decode(b);
                return factory.apply(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14);
            }

            public void encode(@NotNull B b, @NotNull C p_331912_) {
                codec1.encode(b, getter1.apply(p_331912_));
                codec2.encode(b, getter2.apply(p_331912_));
                codec3.encode(b, getter3.apply(p_331912_));
                codec4.encode(b, getter4.apply(p_331912_));
                codec5.encode(b, getter5.apply(p_331912_));
                codec6.encode(b, getter6.apply(p_331912_));
                codec7.encode(b, getter7.apply(p_331912_));
                codec8.encode(b, getter8.apply(p_331912_));
                codec9.encode(b, getter9.apply(p_331912_));
                codec10.encode(b, getter10.apply(p_331912_));
                codec11.encode(b, getter11.apply(p_331912_));
                codec12.encode(b, getter12.apply(p_331912_));
                codec13.encode(b, getter13.apply(p_331912_));
                codec14.encode(b, getter14.apply(p_331912_));
            }
        };
    }
}

