/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks;

import dev.lopyluna.slag.content.blocks.smart.SyncedBlockEntity;
import java.util.Collections;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public abstract class DirtyInventory<BE extends SyncedBlockEntity>
implements Container,
IItemHandlerModifiable {
    public NonNullList<ItemStack> stacks;
    public BE be;
    public boolean extractionAllowed;
    public boolean insertionAllowed;
    public boolean stackNonStackables;
    public int stackSize;
    private Consumer<Integer> updateCallback;

    public DirtyInventory(int slots, BE be, int stackSize, boolean stackNonStackables) {
        this.stacks = NonNullList.withSize((int)slots, (Object)ItemStack.EMPTY);
        this.be = be;
        this.stackNonStackables = stackNonStackables;
        this.insertionAllowed = true;
        this.extractionAllowed = true;
        this.stackSize = stackSize;
    }

    public void load(CompoundTag tag, HolderLookup.Provider registries) {
        Collections.fill(this.stacks, ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.stacks, (HolderLookup.Provider)registries);
    }

    public void save(CompoundTag tag, HolderLookup.Provider registries) {
        ContainerHelper.saveAllItems((CompoundTag)tag, this.stacks, (HolderLookup.Provider)registries);
    }

    public int getContainerSize() {
        return this.stacks.size();
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.stacks) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getFirstItem() {
        for (ItemStack s : this.stacks) {
            if (s.isEmpty()) continue;
            return s;
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack getItem(int slot) {
        return (ItemStack)this.stacks.get(slot);
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        ItemStack stack = ContainerHelper.removeItem(this.stacks, (int)slot, (int)amount);
        if (!stack.isEmpty()) {
            this.setChanged();
            this.onContentsChanged(slot);
        }
        return stack;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.stacks, (int)slot);
    }

    public void setItem(int slot, @NotNull ItemStack stack) {
        this.stacks.set(slot, (Object)stack);
        stack.limitSize(this.getMaxStackSize(stack));
        this.setChanged();
        this.onContentsChanged(slot);
    }

    public boolean stillValid(@NotNull Player player) {
        return Container.stillValidBlockEntity(this.be, (Player)player);
    }

    public void clearContent() {
        this.stacks.clear();
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        this.validateSlotIndex(slot);
        this.setItem(slot, stack);
    }

    public int getSlots() {
        return this.getContainerSize();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return this.getItem(slot);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (!this.insertionAllowed) {
            return stack;
        }
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.getItem(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.isEmpty()) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.getCount();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.getCount() > limit;
        if (!simulate) {
            if (existing.isEmpty()) {
                this.setItem(slot, reachedLimit ? stack.copyWithCount(limit) : stack);
            } else {
                existing.grow(reachedLimit ? limit : stack.getCount());
            }
            this.onContentsChanged(slot);
        }
        return reachedLimit ? stack.copyWithCount(stack.getCount() - limit) : ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack extractItem;
        if (!this.extractionAllowed) {
            return ItemStack.EMPTY;
        }
        if (this.stackNonStackables && !(extractItem = this.extractingItem(slot, amount, true)).isEmpty() && (Integer)extractItem.getOrDefault(DataComponents.MAX_STACK_SIZE, (Object)64) < extractItem.getCount()) {
            amount = (Integer)extractItem.getOrDefault(DataComponents.MAX_STACK_SIZE, (Object)64);
        }
        return this.extractingItem(slot, amount, simulate);
    }

    protected ItemStack extractingItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        if (existing.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int toExtract = Math.min(amount, existing.getMaxStackSize());
        if (existing.getCount() <= toExtract) {
            if (!simulate) {
                this.setItem(slot, ItemStack.EMPTY);
                this.onContentsChanged(slot);
                return existing;
            }
            return existing.copy();
        }
        if (!simulate) {
            this.setItem(slot, existing.copyWithCount(existing.getCount() - toExtract));
            this.onContentsChanged(slot);
        }
        return existing.copyWithCount(toExtract);
    }

    public void whenContentsChange(Consumer<Integer> updateCallback) {
        this.updateCallback = updateCallback;
    }

    protected void onContentsChanged(int slot) {
        if (this.updateCallback != null) {
            this.updateCallback.accept(slot);
        }
        ((SyncedBlockEntity)((Object)this.be)).notifyUpdate();
    }

    public int getSlotLimit(int slot) {
        return Math.min(this.stackNonStackables ? 64 : 99, this.stackSize);
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return true;
    }

    public int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), (Integer)stack.getOrDefault(DataComponents.MAX_STACK_SIZE, (Object)64));
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.stacks.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.stacks.size() + ")");
        }
    }

    public NonNullList<ItemStack> getItems() {
        return this.stacks;
    }
}

