/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.basin;

import dev.lopyluna.slag.content.blocks.basin.BasinInventory;
import dev.lopyluna.slag.content.blocks.basin.BasinTank;
import dev.lopyluna.slag.content.blocks.multiblock.LerpedFloat;
import dev.lopyluna.slag.content.blocks.smart.BlockEntityBehaviour;
import dev.lopyluna.slag.content.blocks.smart.SmartBlockEntity;
import dev.lopyluna.slag.register.AllBETypes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;

public class BasinBE
extends SmartBlockEntity {
    public static final Map<Fluid, BasinHandler> basinHandlers = new HashMap<Fluid, BasinHandler>();
    protected IItemHandler itemCapability;
    protected IFluidHandler fluidCapability;
    protected boolean forceFluidLevelUpdate = true;
    protected BasinInventory itemInventory;
    protected BasinTank tankInventory;
    protected boolean updateCapability = false;
    protected int luminosity;
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;
    public final int COOLING_TARGET = 200;
    public int coolingProgress;
    public ItemStack resultItemStack = ItemStack.EMPTY;
    private LerpedFloat fluidLevel;

    public BasinBE(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
        this.itemInventory = new BasinInventory(1, this);
        this.tankInventory = this.createInventory(this.getCapacity());
        this.refreshCapability();
    }

    public int getCapacity() {
        FluidStack fluid = this.getFluidStack();
        if (fluid.isEmpty()) {
            return 1000;
        }
        BasinHandler handler = basinHandlers.get(fluid.getFluid());
        return handler == null ? 1000 : handler.capacity();
    }

    public ItemStack getResultStack() {
        ItemStack item = this.getStack();
        if (!item.isEmpty()) {
            return item;
        }
        FluidStack fluid = this.getFluidStack();
        if (fluid.isEmpty()) {
            return ItemStack.EMPTY;
        }
        BasinHandler handler = basinHandlers.get(fluid.getFluid());
        return handler == null ? ItemStack.EMPTY : handler.result().copy();
    }

    public int getLuminosity() {
        return this.luminosity;
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)AllBETypes.BASIN.get(), (be, context) -> {
            if (!be.getStack().isEmpty()) {
                return null;
            }
            if (be.fluidCapability == null) {
                be.refreshCapability();
            }
            return be.fluidCapability;
        });
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)AllBETypes.BASIN.get(), (be, context) -> {
            if (be.itemCapability == null) {
                be.refreshCapability();
            }
            return be.itemCapability;
        });
    }

    @Override
    public void tick() {
        super.tick();
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
        if (this.updateCapability) {
            this.updateCapability = false;
            this.refreshCapability();
        }
        if (this.fluidLevel != null) {
            this.fluidLevel.tickChaser();
        }
        if (this.level == null || this.level.isClientSide || basinHandlers.isEmpty()) {
            return;
        }
        Boolean recipe = this.tickRecipe(this.level);
        if (recipe == null) {
            return;
        }
        if (!recipe.booleanValue()) {
            this.coolingProgress = 0;
            this.setPreview(ItemStack.EMPTY);
        }
    }

    public Boolean tickRecipe(Level level) {
        ItemStack stack = this.getStack();
        if (!stack.isEmpty()) {
            this.setPreview(stack);
            return null;
        }
        FluidStack fluidStack = this.getFluidStack();
        if (fluidStack.isEmpty()) {
            return false;
        }
        BasinHandler handler = basinHandlers.get(fluidStack.getFluid());
        if (handler == null) {
            return false;
        }
        BasinTank tank = this.getTankInventory();
        if (tank == null) {
            return false;
        }
        BasinInventory item = this.getItemInventory();
        if (item == null) {
            return false;
        }
        ItemStack result = this.getResultStack();
        this.setPreview(result);
        int capacity = tank.getCapacity();
        if (capacity != tank.getFluidAmount()) {
            return true;
        }
        if (200 > this.coolingProgress) {
            ++this.coolingProgress;
        } else {
            this.coolingProgress = 0;
            item.setItem(0, result);
            tank.drain(capacity, IFluidHandler.FluidAction.EXECUTE);
            level.playSound(null, this.worldPosition, SoundEvents.LAVA_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 1.0f);
        }
        if (!level.isClientSide) {
            this.setChanged();
            this.sendData();
        }
        return true;
    }

    protected BasinTank createInventory(int capacity) {
        return new BasinTank(this, capacity, this::onFluidStackChanged);
    }

    public void refreshCapability() {
        this.fluidCapability = this.handlerForCapability();
        this.itemCapability = this.handlerForCapabilityItem();
        this.invalidateCapabilities();
    }

    private IItemHandler handlerForCapabilityItem() {
        return this.itemInventory;
    }

    private IFluidHandler handlerForCapability() {
        return this.tankInventory;
    }

    protected void onFluidStackChanged(FluidStack newFluids) {
        if (this.level == null) {
            return;
        }
        if (this.tankInventory != null) {
            this.tankInventory.setCapacity(this.getCapacity());
            if (this.tankInventory.getSpace() < 0) {
                this.tankInventory.drain(-this.tankInventory.getSpace(), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        this.level.updateNeighbourForOutputSignal(this.worldPosition, this.getBlockState().getBlock());
        if (!this.level.isClientSide) {
            this.setChanged();
            this.sendData();
        } else {
            if (this.fluidLevel == null) {
                this.fluidLevel = LerpedFloat.linear().startWithValue(this.getFillState());
            }
            this.fluidLevel.chase(this.getFillState(), 0.5, LerpedFloat.Chaser.EXP);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        BasinBE.dropContents(this.level, this.worldPosition, (IItemHandler)this.itemInventory);
    }

    public static void dropContents(Level level, BlockPos pos, IItemHandler inv) {
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)inv.getStackInSlot(slot));
        }
    }

    protected void setLuminosity(int luminosity) {
        assert (this.level != null);
        if (this.level.isClientSide) {
            return;
        }
        if (this.luminosity == luminosity) {
            return;
        }
        this.luminosity = luminosity;
        this.sendData();
    }

    public float getFillState() {
        return (float)this.tankInventory.getFluidAmount() / (float)this.tankInventory.getCapacity();
    }

    private void setPreview(ItemStack preview) {
        boolean same;
        ItemStack p = preview.isEmpty() ? ItemStack.EMPTY : preview.copy();
        boolean bl = same = ItemStack.isSameItemSameComponents((ItemStack)this.resultItemStack, (ItemStack)p) && this.resultItemStack.getCount() == p.getCount();
        if (same) {
            return;
        }
        this.resultItemStack = p;
        if (this.level != null && !this.level.isClientSide) {
            this.setChanged();
            this.sendData();
        }
    }

    @Override
    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        assert (this.level != null);
        int prevLum = this.luminosity;
        this.luminosity = tag.getInt("Luminosity");
        this.itemInventory.load(tag, registries);
        this.tankInventory.setCapacity(this.getCapacity());
        this.tankInventory.readFromNBT(registries, tag.getCompound("TankContent"));
        if (this.tankInventory.getSpace() < 0) {
            this.tankInventory.drain(-this.tankInventory.getSpace(), IFluidHandler.FluidAction.EXECUTE);
        }
        if (tag.contains("ForceFluidLevel") || this.fluidLevel == null) {
            this.fluidLevel = LerpedFloat.linear().startWithValue(this.getFillState());
        }
        this.updateCapability = true;
        if (!clientPacket) {
            return;
        }
        this.resultItemStack = tag.contains("ResultPreview") ? ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("ResultPreview")) : ItemStack.EMPTY;
        this.coolingProgress = tag.getInt("CoolingProgress");
        float fillState = this.getFillState();
        if (tag.contains("ForceFluidLevel") || this.fluidLevel == null) {
            this.fluidLevel = LerpedFloat.linear().startWithValue(fillState);
        }
        this.fluidLevel.chase(fillState, 0.5, LerpedFloat.Chaser.EXP);
        if (this.luminosity != prevLum && this.hasLevel()) {
            this.level.getChunkSource().getLightEngine().checkBlock(this.worldPosition);
        }
        if (tag.contains("LazySync")) {
            this.fluidLevel.chase(this.fluidLevel.getChaseTarget(), 0.125, LerpedFloat.Chaser.EXP);
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.tankInventory != null) {
            this.tankInventory.setCapacity(this.getCapacity());
        }
    }

    @Override
    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        tag.put("TankContent", (Tag)this.tankInventory.writeToNBT(registries, new CompoundTag()));
        tag.putInt("Luminosity", this.luminosity);
        super.write(tag, registries, clientPacket);
        this.itemInventory.save(tag, registries);
        if (!clientPacket) {
            return;
        }
        if (!this.resultItemStack.isEmpty()) {
            tag.put("ResultPreview", this.resultItemStack.save(registries, (Tag)new CompoundTag()));
        }
        tag.putInt("CoolingProgress", this.coolingProgress);
        if (this.forceFluidLevelUpdate) {
            tag.putBoolean("ForceFluidLevel", true);
        }
        if (this.queuedSync) {
            tag.putBoolean("LazySync", true);
        }
        this.forceFluidLevelUpdate = false;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.sendData();
    }

    public void sendDataImmediately() {
        this.syncCooldown = 0;
        this.queuedSync = false;
        this.sendData();
    }

    public void setChanged() {
        super.setChanged();
        this.itemInventory.setChanged();
    }

    @Override
    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    @Override
    public void invalidate() {
        if (this.itemInventory != null || this.fluidCapability != null) {
            this.invalidateCapabilities();
        }
        super.invalidate();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public FluidStack getFluidStack() {
        BasinTank inv = this.getTankInventory();
        return inv == null ? FluidStack.EMPTY : inv.getFluid();
    }

    public ItemStack getStack() {
        BasinInventory inv = this.getItemInventory();
        return inv == null ? ItemStack.EMPTY : inv.getFirstItem().copy();
    }

    public BasinInventory getItemInventory() {
        return this.itemInventory;
    }

    public BasinTank getTankInventory() {
        return this.tankInventory;
    }

    public LerpedFloat getFluidLevel() {
        return this.fluidLevel;
    }

    public void setFluidLevel(LerpedFloat fluidLevel) {
        this.fluidLevel = fluidLevel;
    }

    public record BasinHandler(Fluid fluid, int capacity, ItemStack result) {
    }
}

