/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.basin;

import com.mojang.serialization.MapCodec;
import dev.lopyluna.slag.content.blocks.basin.BasinBE;
import dev.lopyluna.slag.content.blocks.basin.BasinTank;
import dev.lopyluna.slag.content.blocks.crucible.CrucibleBlock;
import dev.lopyluna.slag.content.blocks.smart.SmartBlock;
import dev.lopyluna.slag.content.utils.ShapeUtils;
import dev.lopyluna.slag.register.AllBETypes;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class BasinBlock
extends SmartBlock<BasinBE> {
    public static final MapCodec<BasinBlock> CODEC = BasinBlock.simpleCodec(BasinBlock::new);

    public BasinBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BasinBE be;
        block7: {
            block6: {
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (!(blockEntity instanceof BasinBE)) break block6;
                be = (BasinBE)blockEntity;
                if (be.coolingProgress <= 0) break block7;
            }
            return InteractionResult.PASS;
        }
        boolean shift = player.isShiftKeyDown();
        boolean empty = player.getMainHandItem().isEmpty();
        if (shift && empty && be.tankInventory != null && !be.tankInventory.isEmpty()) {
            be.tankInventory.drain(be.tankInventory.getFluidAmount(), IFluidHandler.FluidAction.EXECUTE);
            return InteractionResult.SUCCESS;
        }
        if (be.itemInventory == null || player.isShiftKeyDown() && !empty) {
            return InteractionResult.PASS;
        }
        ItemStack stack = be.getStack();
        if (stack.isEmpty()) {
            return InteractionResult.PASS;
        }
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
        be.itemInventory.getFirstItem().setCount(0);
        return InteractionResult.SUCCESS;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack held, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        FluidStack drained;
        if (held.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof BasinBE)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BasinBE be = (BasinBE)blockEntity;
        BasinTank tank = be.getTankInventory();
        IFluidHandlerItem itemHandler = (IFluidHandlerItem)held.getCapability(Capabilities.FluidHandler.ITEM);
        if (itemHandler == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        FluidStack available = itemHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
        if (available.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        int fillable = tank.fill(available, IFluidHandler.FluidAction.SIMULATE);
        if (fillable <= 0) {
            return ItemInteractionResult.CONSUME;
        }
        if (!level.isClientSide && !(drained = itemHandler.drain(fillable, IFluidHandler.FluidAction.EXECUTE)).isEmpty()) {
            int accepted = tank.fill(drained, IFluidHandler.FluidAction.EXECUTE);
            if (accepted > 0 && !player.getAbilities().instabuild) {
                player.setItemInHand(hand, itemHandler.getContainer());
            }
            be.sendDataImmediately();
            be.setChanged();
        }
        SoundEvent soundFill = CrucibleBlock.getFillSound(available);
        SoundEvent soundEmpty = CrucibleBlock.getEmptySound(available);
        if (soundFill != null) {
            level.playSound(null, pos, soundFill, SoundSource.BLOCKS, 0.5f, 1.0f);
        }
        if (soundEmpty != null) {
            player.playSound(soundEmpty, 0.5f, 1.0f);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        BlockEntity at = level.getBlockEntity(pos);
        if (at == null || !at.hasLevel() || !(at instanceof BasinBE)) {
            return 0;
        }
        BasinBE be = (BasinBE)at;
        return be.getLuminosity();
    }

    @Override
    public Class<BasinBE> getBlockEntityClass() {
        return BasinBE.class;
    }

    @Override
    public BlockEntityType<? extends BasinBE> getBlockEntityType() {
        return (BlockEntityType)AllBETypes.BASIN.get();
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShaper wall;
        ShapeUtils.Builder shaper = ShapeUtils.shape(0.0, 0.0, 0.0, 16.0, 3.0, 16.0);
        ShapeUtils.Builder newShape = shaper.add((wall = ShapeUtils.shape(0.0, 0.0, 0.0, 16.0, 16.0, 2.0).forHorizontal(Direction.NORTH)).get(Direction.NORTH)).add(wall.get(Direction.SOUTH)).add(wall.get(Direction.EAST)).add(wall.get(Direction.WEST));
        if (newShape != null) {
            shaper = newShape;
        }
        return shaper.build();
    }
}

