/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.crucible;

import dev.lopyluna.slag.register.AllRecipes;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class AlloyingRecipe
implements Recipe<AlloyRecipeInput> {
    protected final RecipeType<?> type;
    protected final String group;
    private final List<FluidStack> inputs;
    private final FluidStack output;

    public AlloyingRecipe(String group, List<FluidStack> inputs, FluidStack output) {
        this((RecipeType)AllRecipes.ALLOYING.get(), group, inputs, output);
    }

    public AlloyingRecipe(RecipeType<?> type, String group, List<FluidStack> inputs, FluidStack output) {
        this.type = type;
        this.group = group;
        this.inputs = inputs;
        this.output = output;
    }

    public boolean matches(AlloyRecipeInput alloyRecipeInput, Level level) {
        List<FluidStack> inputs = alloyRecipeInput.fluids;
        if (inputs.size() != this.inputs.size()) {
            return false;
        }
        for (FluidStack input : inputs) {
            if (inputs.contains(input)) continue;
            return false;
        }
        return true;
    }

    public FluidStack assembleWithFluid(AlloyRecipeInput alloyRecipeInput, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public FluidStack getResultFluid(HolderLookup.Provider provider) {
        return this.output.copy();
    }

    @NotNull
    public String getGroup() {
        return this.group;
    }

    public List<FluidStack> getInputs() {
        return this.inputs;
    }

    public FluidStack getOutput() {
        return this.output;
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return false;
    }

    @NotNull
    public ItemStack assemble(AlloyRecipeInput alloyRecipeInput, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)AllRecipes.ALLOYING_SER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return this.type;
    }

    public record AlloyRecipeInput(List<FluidStack> fluids) implements RecipeInput
    {
        @NotNull
        public ItemStack getItem(int i) {
            return ItemStack.EMPTY;
        }

        public int size() {
            return this.fluids.size();
        }

        public boolean isEmpty() {
            return this.fluids.isEmpty();
        }

        @Override
        public int hashCode() {
            return AlloyRecipeInput.hashStackList(this.fluids);
        }

        public static int hashStackList(List<FluidStack> list) {
            int i = 0;
            for (FluidStack f : list) {
                i = i * 31 + FluidStack.hashFluidAndComponents((FluidStack)f);
            }
            return i;
        }
    }

    public static interface Factory {
        public AlloyingRecipe create(String var1, List<FluidStack> var2, FluidStack var3);
    }

    public static class Type
    implements RecipeType<AlloyingRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }

        public String toString() {
            return "alloying";
        }
    }
}

