/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.crucible;

import dev.lopyluna.slag.content.blocks.crucible.CrucibleTank;
import dev.lopyluna.slag.content.blocks.multiblock.FluidMultiBlockEntity;
import dev.lopyluna.slag.register.AllBlocks;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class CrucibleBE
extends FluidMultiBlockEntity {
    public int updateShape = 2;
    public static final BooleanProperty TOP = BooleanProperty.create((String)"top");
    public static final BooleanProperty BOTTOM = BooleanProperty.create((String)"bottom");
    public static final BooleanProperty WINDOW = BooleanProperty.create((String)"window");
    public static final EnumProperty<Shape> SHAPE = EnumProperty.create((String)"shape", Shape.class);

    public CrucibleBE(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
        this.setLazyTickRate(1);
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.level == null) {
            return;
        }
        if (this.updateShape > 0) {
            this.handleShapeConnections(this.level, this.worldPosition, this.getBlockState());
        }
        if (this.level.isClientSide) {
            return;
        }
        CrucibleTank tank = this.getTankInventory();
        if (tank.tryAlloy(this.level, 1)) {
            tank.onContentsChanged();
        }
    }

    public void updateShape() {
        this.updateShape = 2;
    }

    @Override
    public void notifyMultiUpdated() {
        super.notifyMultiUpdated();
        this.updateShape();
    }

    @Override
    public void removeController(boolean keepFluids) {
        super.removeController(keepFluids);
        this.updateShape();
    }

    @Override
    public void setController(BlockPos controller) {
        super.setController(controller);
        this.updateShape();
    }

    @Override
    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.updateShape();
    }

    public boolean isSameController(Level level, BlockPos pos) {
        CrucibleBE be;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        return blockEntity instanceof CrucibleBE && (be = (CrucibleBE)blockEntity).getController().equals((Object)this.getController());
    }

    @Override
    public void setWindows(boolean window) {
        super.setWindows(window);
        this.updateShape();
        if (this.level != null) {
            for (int yOffset = 0; yOffset < this.height; ++yOffset) {
                for (int xOffset = 0; xOffset < this.widthX; ++xOffset) {
                    for (int zOffset = 0; zOffset < this.widthZ; ++zOffset) {
                        BlockPos pos = this.worldPosition.offset(xOffset, yOffset, zOffset);
                        BlockEntity blockEntity = this.level.getBlockEntity(pos);
                        if (!(blockEntity instanceof CrucibleBE)) continue;
                        CrucibleBE be = (CrucibleBE)blockEntity;
                        be.updateShape();
                    }
                }
            }
        }
    }

    public void handleShapeConnections(Level level, BlockPos pos, BlockState state) {
        boolean window;
        --this.updateShape;
        ArrayList<Direction> dirVCtrl = new ArrayList<Direction>();
        ArrayList<Direction> dirHCtrl = new ArrayList<Direction>();
        for (Direction dir : Direction.values()) {
            BlockPos relPos = pos.relative(dir);
            if (!this.isSameController(level, relPos)) continue;
            if (dir.getAxis().isVertical()) {
                dirVCtrl.add(dir);
                continue;
            }
            dirHCtrl.add(dir.getOpposite());
        }
        int sizeS = dirHCtrl.size();
        if (sizeS == 2) {
            Direction a = (Direction)dirHCtrl.getFirst();
            Direction b = (Direction)dirHCtrl.getLast();
            boolean target = this.isSameController(level, pos.relative(a.getOpposite()).relative(b.getOpposite()));
            if (!target) {
                dirHCtrl.remove(a);
                dirHCtrl.remove(b);
            }
        }
        sizeS = dirHCtrl.size();
        Shape shape = Shape.PLAIN;
        switch (sizeS) {
            case 4: {
                shape = Shape.INNER;
                break;
            }
            case 2: {
                shape = Shape.fromDirDir((Direction)dirHCtrl.getFirst(), (Direction)dirHCtrl.getLast());
                break;
            }
            case 3: {
                boolean posB;
                boolean posA;
                Direction a = (Direction)dirHCtrl.getFirst();
                Direction b = (Direction)dirHCtrl.get(1);
                Direction c = (Direction)dirHCtrl.getLast();
                Shape shaping = Shape.PLAIN;
                Direction targetDir = Direction.DOWN;
                if (a.getAxis().equals((Object)b.getAxis())) {
                    posA = this.isSameController(level, pos.relative(a.getOpposite()).relative(c.getOpposite()));
                    posB = this.isSameController(level, pos.relative(b.getOpposite()).relative(c.getOpposite()));
                    if (posA && posB) {
                        targetDir = c;
                    } else if (posA) {
                        shaping = Shape.fromDirDir(a, c);
                    } else if (posB) {
                        shaping = Shape.fromDirDir(b, c);
                    }
                }
                if (a.getAxis().equals((Object)c.getAxis())) {
                    posA = this.isSameController(level, pos.relative(a.getOpposite()).relative(b.getOpposite()));
                    posB = this.isSameController(level, pos.relative(c.getOpposite()).relative(b.getOpposite()));
                    if (posA && posB) {
                        targetDir = b;
                    } else if (posA) {
                        shaping = Shape.fromDirDir(a, b);
                    } else if (posB) {
                        shaping = Shape.fromDirDir(c, b);
                    }
                }
                if (c.getAxis().equals((Object)b.getAxis())) {
                    posA = this.isSameController(level, pos.relative(c.getOpposite()).relative(a.getOpposite()));
                    posB = this.isSameController(level, pos.relative(b.getOpposite()).relative(a.getOpposite()));
                    if (posA && posB) {
                        targetDir = a;
                    } else if (posA) {
                        shaping = Shape.fromDirDir(c, a);
                    } else if (posB) {
                        shaping = Shape.fromDirDir(b, a);
                    }
                }
                shape = targetDir == Direction.DOWN ? shaping : Shape.fromDir(targetDir);
            }
        }
        FluidMultiBlockEntity ctrl = this.getControllerBE();
        boolean bl = window = ctrl != null && ctrl.isWindow();
        if (state.is(AllBlocks.CRUCIBLE)) {
            level.setBlockAndUpdate(pos, (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)WINDOW, (Comparable)Boolean.valueOf(window))).setValue((Property)TOP, (Comparable)Boolean.valueOf(!dirVCtrl.contains(Direction.UP)))).setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(!dirVCtrl.contains(Direction.DOWN)))).setValue(SHAPE, (Comparable)((Object)shape)));
        }
    }

    public static enum Shape implements StringRepresentable
    {
        PLAIN,
        INNER,
        NW,
        SW,
        NE,
        SE,
        NORTH,
        SOUTH,
        WEST,
        EAST;


        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase();
        }

        public static Shape fromDir(Direction direction) {
            return switch (direction) {
                default -> throw new MatchException(null, null);
                case Direction.DOWN, Direction.UP -> PLAIN;
                case Direction.NORTH -> NORTH;
                case Direction.SOUTH -> SOUTH;
                case Direction.WEST -> WEST;
                case Direction.EAST -> EAST;
            };
        }

        public static Shape fromDirDir(Direction dir1, Direction dir2) {
            return switch (dir1) {
                case Direction.NORTH -> {
                    switch (dir2) {
                        case NORTH: {
                            yield NORTH;
                        }
                        case WEST: {
                            yield NW;
                        }
                        case EAST: {
                            yield NE;
                        }
                    }
                    yield PLAIN;
                }
                case Direction.SOUTH -> {
                    switch (dir2) {
                        case SOUTH: {
                            yield SOUTH;
                        }
                        case WEST: {
                            yield SW;
                        }
                        case EAST: {
                            yield SE;
                        }
                    }
                    yield PLAIN;
                }
                case Direction.WEST -> {
                    switch (dir2) {
                        case NORTH: {
                            yield NW;
                        }
                        case SOUTH: {
                            yield SW;
                        }
                        case WEST: {
                            yield WEST;
                        }
                    }
                    yield PLAIN;
                }
                case Direction.EAST -> {
                    switch (dir2) {
                        case NORTH: {
                            yield NE;
                        }
                        case SOUTH: {
                            yield SE;
                        }
                        case EAST: {
                            yield EAST;
                        }
                    }
                    yield PLAIN;
                }
                default -> PLAIN;
            };
        }

        public boolean isWall() {
            return this.equals((Object)NORTH) || this.equals((Object)SOUTH) || this.equals((Object)WEST) || this.equals((Object)EAST);
        }

        public boolean isCorner() {
            return this.equals((Object)NW) || this.equals((Object)SW) || this.equals((Object)NE) || this.equals((Object)SE);
        }

        public Direction toDirection() {
            return switch (this.ordinal()) {
                case 4, 6 -> Direction.NORTH;
                case 2, 8 -> Direction.WEST;
                case 3, 7 -> Direction.SOUTH;
                case 5, 9 -> Direction.EAST;
                default -> Direction.DOWN;
            };
        }
    }
}

