/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.crucible;

import com.mojang.serialization.MapCodec;
import dev.lopyluna.slag.content.blocks.crucible.CrucibleBE;
import dev.lopyluna.slag.content.blocks.crucible.CrucibleTank;
import dev.lopyluna.slag.content.blocks.multiblock.FluidMultiBlockEntity;
import dev.lopyluna.slag.content.blocks.multiblock.connectivity.ConnectivityHandler;
import dev.lopyluna.slag.content.blocks.smart.SmartBlock;
import dev.lopyluna.slag.content.utils.ShapeUtils;
import dev.lopyluna.slag.register.AllBETypes;
import dev.lopyluna.slag.register.AllLangs;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.EffectCures;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class CrucibleBlock
extends SmartBlock<CrucibleBE> {
    public static final MapCodec<CrucibleBlock> CODEC = CrucibleBlock.simpleCodec(CrucibleBlock::new);

    public CrucibleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)super.defaultBlockState().setValue((Property)CrucibleBE.WINDOW, (Comparable)Boolean.valueOf(false))).setValue((Property)CrucibleBE.TOP, (Comparable)Boolean.valueOf(true))).setValue((Property)CrucibleBE.BOTTOM, (Comparable)Boolean.valueOf(true))).setValue(CrucibleBE.SHAPE, (Comparable)((Object)CrucibleBE.Shape.PLAIN)));
    }

    protected boolean canBeReplaced(BlockState state, Fluid fluid) {
        return false;
    }

    protected boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return false;
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltips, TooltipFlag pFlag) {
        super.appendHoverText(pStack, pContext, pTooltips, pFlag);
        pTooltips.add((Component)AllLangs.tr("dynamic_multiblock").withStyle(ChatFormatting.GRAY));
    }

    @Override
    public Class<CrucibleBE> getBlockEntityClass() {
        return CrucibleBE.class;
    }

    @Override
    @NotNull
    public BlockEntityType<CrucibleBE> getBlockEntityType() {
        return (BlockEntityType)AllBETypes.CRUCIBLE.get();
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        CrucibleBE cbe;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CrucibleBE && (blockEntity = (cbe = (CrucibleBE)blockEntity).getControllerBE()) instanceof CrucibleBE) {
            CrucibleBE be = (CrucibleBE)blockEntity;
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                CrucibleTank tank = be.getTankInventory();
                if (!living.getActiveEffects().isEmpty() && tank.containsLiquid((Fluid)NeoForgeMod.MILK.get())) {
                    living.removeEffectsCuredBy(EffectCures.MILK);
                }
                if (tank.containsHotLiquid()) {
                    living.lavaHurt();
                } else if (living.isOnFire() && tank.canExtinguishEntity((Entity)living)) {
                    living.extinguishFire();
                    entity.playSound(SoundEvents.GENERIC_EXTINGUISH_FIRE, 0.7f, 1.6f + (level.random.nextFloat() - level.random.nextFloat()) * 0.4f);
                }
            }
        }
        super.entityInside(state, level, pos, entity);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        CrucibleBE cbe;
        super.animateTick(state, level, pos, random);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CrucibleBE && (blockEntity = (cbe = (CrucibleBE)blockEntity).getControllerBE()) instanceof CrucibleBE) {
            CrucibleBE be = (CrucibleBE)blockEntity;
            List<FluidStack> fluids = be.getTankInventory().getFluids();
            if (fluids == null || fluids.isEmpty()) {
                return;
            }
            int totalSize = be.getTotalSize();
            float fillState = be.getFillState();
            for (FluidStack fluid : fluids) {
                if (!((float)random.nextInt(fluids.size() * totalSize) <= (float)totalSize * 0.25f * fillState)) continue;
                if ((fluid.is((Fluid)Fluids.WATER) || fluid.is((Holder)NeoForgeMod.MILK)) && random.nextInt(96) == 0) {
                    level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.WATER_AMBIENT, SoundSource.BLOCKS, random.nextFloat() * 0.25f + 0.75f, random.nextFloat() + 0.5f, false);
                }
                fluid.getFluid().defaultFluidState().animateTick(level, pos, random);
            }
        }
    }

    public boolean isLadder(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return (Boolean)state.getValue((Property)CrucibleBE.BOTTOM) == false && !entity.isDescending();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{CrucibleBE.WINDOW, CrucibleBE.TOP, CrucibleBE.BOTTOM, CrucibleBE.SHAPE});
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean moved) {
        if (oldState.getBlock() == state.getBlock()) {
            return;
        }
        if (moved) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)level, pos, FluidMultiBlockEntity::updateConnectivity);
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        CrucibleBE at = (CrucibleBE)ConnectivityHandler.partAt(this.getBlockEntityType(), world, pos);
        if (at == null || !at.hasLevel()) {
            return 0;
        }
        FluidMultiBlockEntity be = at.getControllerBE();
        if (be == null || !be.isWindow()) {
            return 0;
        }
        return at.getLuminosity();
    }

    @Override
    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (state.hasBlockEntity() && (state.getBlock() != newState.getBlock() || !newState.hasBlockEntity())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (!(blockEntity instanceof CrucibleBE)) {
                return;
            }
            CrucibleBE tankBE = (CrucibleBE)blockEntity;
            level.removeBlockEntity(pos);
            ConnectivityHandler.splitMulti(tankBE);
        }
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (player.getMainHandItem().isEmpty() && player.isShiftKeyDown() && (blockEntity = level.getBlockEntity(pos)) instanceof CrucibleBE) {
            CrucibleBE be = (CrucibleBE)blockEntity;
            FluidMultiBlockEntity ctrl = be.getControllerBE();
            if (ctrl == null) {
                ctrl = be;
            }
            ctrl.setWindows(!ctrl.isWindow());
            return InteractionResult.SUCCESS_NO_ITEM_USED;
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack held, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        FluidStack drained;
        if (held.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof CrucibleBE)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        CrucibleBE be = (CrucibleBE)blockEntity;
        FluidMultiBlockEntity ctrl = be.getControllerBE();
        if (ctrl == null) {
            ctrl = be;
        }
        CrucibleTank tank = ctrl.getTankInventory();
        IFluidHandlerItem itemHandler = (IFluidHandlerItem)held.getCapability(Capabilities.FluidHandler.ITEM);
        if (itemHandler == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        FluidStack available = itemHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
        if (available.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        int fillable = tank.fill(available, IFluidHandler.FluidAction.SIMULATE);
        if (fillable <= 0) {
            return ItemInteractionResult.CONSUME;
        }
        if (!level.isClientSide && !(drained = itemHandler.drain(fillable, IFluidHandler.FluidAction.EXECUTE)).isEmpty()) {
            int accepted = tank.fill(drained, IFluidHandler.FluidAction.EXECUTE);
            if (accepted > 0 && !player.getAbilities().instabuild) {
                player.setItemInHand(hand, itemHandler.getContainer());
            }
            ctrl.sendDataImmediately();
            ctrl.setChanged();
        }
        SoundEvent soundFill = CrucibleBlock.getFillSound(available);
        SoundEvent soundEmpty = CrucibleBlock.getEmptySound(available);
        if (soundFill != null) {
            level.playSound(null, pos, soundFill, SoundSource.BLOCKS, 0.5f, 1.0f);
        }
        if (soundEmpty != null) {
            player.playSound(soundEmpty, 0.5f, 1.0f);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public static SoundEvent getFillSound(FluidStack fluid) {
        SoundEvent soundevent = fluid.getFluid().getFluidType().getSound(fluid, SoundActions.BUCKET_FILL);
        if (soundevent == null) {
            soundevent = CrucibleBlock.isTag(fluid, (TagKey<Fluid>)FluidTags.LAVA) ? SoundEvents.BUCKET_FILL_LAVA : SoundEvents.BUCKET_FILL;
        }
        return soundevent;
    }

    public static SoundEvent getEmptySound(FluidStack fluid) {
        SoundEvent soundevent = fluid.getFluid().getFluidType().getSound(fluid, SoundActions.BUCKET_EMPTY);
        if (soundevent == null) {
            soundevent = CrucibleBlock.isTag(fluid, (TagKey<Fluid>)FluidTags.LAVA) ? SoundEvents.BUCKET_EMPTY_LAVA : SoundEvents.BUCKET_EMPTY;
        }
        return soundevent;
    }

    public static boolean isTag(Fluid fluid, TagKey<Fluid> tag) {
        return fluid.is(tag);
    }

    public static boolean isTag(FluidStack fluid, TagKey<Fluid> tag) {
        return CrucibleBlock.isTag(fluid.getFluid(), tag);
    }

    @NotNull
    protected VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (context.equals((Object)CollisionContext.empty())) {
            return Shapes.block();
        }
        return (Boolean)state.getValue((Property)CrucibleBE.WINDOW) != false ? Shapes.empty() : super.getVisualShape(state, level, pos, context);
    }

    public boolean hasDynamicShape() {
        return true;
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        ShapeUtils.Builder newShape;
        Boolean bottom = (Boolean)state.getValue((Property)CrucibleBE.BOTTOM);
        CrucibleBE.Shape shape = (CrucibleBE.Shape)((Object)state.getValue(CrucibleBE.SHAPE));
        ShapeUtils.Builder shaper = ShapeUtils.shape(Shapes.empty());
        if (bottom.booleanValue()) {
            shaper = shaper.add(0.0, 0.0, 0.0, 16.0, 4.0, 16.0);
        }
        VoxelShaper wall = ShapeUtils.shape(0.0, 0.0, 0.0, 16.0, 16.0, 3.0).forHorizontal(Direction.NORTH);
        switch (shape) {
            case PLAIN: {
                ShapeUtils.Builder builder = shaper.add(wall.get(Direction.NORTH)).add(wall.get(Direction.SOUTH)).add(wall.get(Direction.EAST)).add(wall.get(Direction.WEST));
                break;
            }
            case NW: {
                ShapeUtils.Builder builder = shaper.add(wall.get(Direction.NORTH)).add(wall.get(Direction.WEST));
                break;
            }
            case SW: {
                ShapeUtils.Builder builder = shaper.add(wall.get(Direction.SOUTH)).add(wall.get(Direction.WEST));
                break;
            }
            case NE: {
                ShapeUtils.Builder builder = shaper.add(wall.get(Direction.NORTH)).add(wall.get(Direction.EAST));
                break;
            }
            case SE: {
                ShapeUtils.Builder builder = shaper.add(wall.get(Direction.SOUTH)).add(wall.get(Direction.EAST));
                break;
            }
            case NORTH: {
                ShapeUtils.Builder builder = shaper.add(wall.get(Direction.NORTH));
                break;
            }
            case SOUTH: {
                ShapeUtils.Builder builder = shaper.add(wall.get(Direction.SOUTH));
                break;
            }
            case WEST: {
                ShapeUtils.Builder builder = shaper.add(wall.get(Direction.WEST));
                break;
            }
            case EAST: {
                ShapeUtils.Builder builder = shaper.add(wall.get(Direction.EAST));
                break;
            }
            default: {
                ShapeUtils.Builder builder = newShape = null;
            }
        }
        if (newShape != null) {
            shaper = newShape;
        }
        return shaper.build();
    }

    @NotNull
    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getShape(state, level, pos, context);
    }
}

