/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.crucible;

import dev.lopyluna.slag.content.blocks.crucible.AlloyingRecipe;
import dev.lopyluna.slag.content.utils.NBTHelper;
import dev.lopyluna.slag.register.AllRecipes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class CrucibleTank
extends FluidTank {
    public List<FluidStack> fluids = new ArrayList<FluidStack>();
    private final Consumer<List<FluidStack>> updateCallback;

    public CrucibleTank(int capacity, Consumer<List<FluidStack>> updateCallback) {
        super(capacity);
        this.updateCallback = updateCallback;
        this.fluids.add(FluidStack.EMPTY);
    }

    protected void onContentsChanged() {
        this.updateCallback.accept(this.getFluids());
    }

    public List<FluidStack> getFluids() {
        this.compress();
        return this.fluids;
    }

    public List<FluidStack> getFluidCopy() {
        if (this.getFluids() == null || this.fluids.isEmpty()) {
            return new ArrayList<FluidStack>();
        }
        return this.getFluids().stream().filter(s -> !s.isEmpty()).map(FluidStack::copy).toList();
    }

    public void clear() {
        this.fluids.clear();
        this.onContentsChanged();
    }

    public boolean containsLiquid(Fluid fluid) {
        if (this.fluids.isEmpty()) {
            return false;
        }
        for (FluidStack target : this.fluids) {
            if (!target.is(fluid)) continue;
            return true;
        }
        return false;
    }

    public boolean containsHotLiquid() {
        if (this.fluids.isEmpty()) {
            return false;
        }
        for (FluidStack fluid : this.fluids) {
            if (fluid.getFluidType().getTemperature() < 1000) continue;
            return true;
        }
        return false;
    }

    public boolean canExtinguishEntity(Entity entity) {
        if (this.containsHotLiquid()) {
            return false;
        }
        for (FluidStack fluid : this.fluids) {
            if (!fluid.getFluidType().canExtinguish(entity)) continue;
            return true;
        }
        return false;
    }

    public boolean moveFluidToFront(int targetIdx) {
        List<FluidStack> list = this.fluids;
        if (list == null || list.isEmpty()) {
            return false;
        }
        if (targetIdx <= 0 || targetIdx >= list.size()) {
            return false;
        }
        FluidStack sel = list.remove(targetIdx);
        list.addFirst(sel);
        this.onContentsChanged();
        this.compress();
        return true;
    }

    @NotNull
    public FluidStack getFluid() {
        return this.fluids.isEmpty() ? FluidStack.EMPTY : this.fluids.getFirst();
    }

    public int getFluidAmount() {
        return this.getFluid().getAmount();
    }

    public int getTotalFluidAmount() {
        int i = 0;
        for (FluidStack fluid : this.fluids) {
            if (fluid.isEmpty()) continue;
            i += fluid.getAmount();
        }
        return i;
    }

    @NotNull
    public FluidTank readFromNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.fluids.clear();
        this.fluids = NBTHelper.readFluidList(nbt.getList("Fluids", 10), provider);
        return this;
    }

    @NotNull
    public CompoundTag writeToNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        nbt.put("Fluids", (Tag)NBTHelper.writeFluidList(this.fluids, provider));
        return nbt;
    }

    public boolean isFluidValid(FluidStack stack) {
        return this.validator != null && super.isFluidValid(stack);
    }

    public int fill(List<FluidStack> resources, IFluidHandler.FluidAction action) {
        if (resources.isEmpty()) {
            return 0;
        }
        int i = 0;
        for (FluidStack f : resources) {
            i += this.fill(f, action);
        }
        return i;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource == null || resource.isEmpty() || this.validator == null || !this.isFluidValid(resource) || action == null) {
            return 0;
        }
        int match = this.findFirstMatch(resource);
        int spaceTotal = this.getSpace();
        if (match >= 0) {
            int fillable = Math.min(spaceTotal, resource.getAmount());
            if (fillable <= 0) {
                return 0;
            }
            if (action.simulate()) {
                return fillable;
            }
            this.fluids.get(match).grow(fillable);
            this.onContentsChanged();
            return fillable;
        }
        int fillable = Math.min(spaceTotal, resource.getAmount());
        if (fillable <= 0) {
            return 0;
        }
        if (action.simulate()) {
            return fillable;
        }
        this.fluids.add(resource.copyWithAmount(fillable));
        if (this.fluids.getFirst().isEmpty() && this.fluids.size() > 1) {
            this.moveFirstNonEmptyToFront();
        }
        this.onContentsChanged();
        return fillable;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return FluidStack.EMPTY;
        }
        FluidStack top = this.getFluid();
        if (top.isEmpty() || !FluidStack.isSameFluidSameComponents((FluidStack)top, (FluidStack)resource)) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        this.compress();
        if (maxDrain <= 0 || this.fluids.isEmpty()) {
            return FluidStack.EMPTY;
        }
        FluidStack top = this.fluids.getFirst();
        if (top.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int drained = Math.min(top.getAmount(), maxDrain);
        FluidStack out = top.copyWithAmount(drained);
        if (action.execute() && drained > 0) {
            top.shrink(drained);
            this.onContentsChanged();
        }
        return out;
    }

    public void setFluid(@NotNull FluidStack stack) {
        if (this.fluids.isEmpty()) {
            this.fluids.add(stack);
        } else {
            this.fluids.set(0, stack);
        }
        this.compress();
        this.updateCallback.accept(this.fluids);
    }

    public boolean isEmpty() {
        return this.getTotalFluidAmount() == 0;
    }

    public int getSpace() {
        return Math.max(0, this.capacity - this.getTotalFluidAmount());
    }

    private int findFirstMatch(FluidStack target) {
        for (int i = 0; i < this.fluids.size(); ++i) {
            FluidStack f = this.fluids.get(i);
            if (f.isEmpty() || !FluidStack.isSameFluidSameComponents((FluidStack)f, (FluidStack)target)) continue;
            return i;
        }
        return -1;
    }

    private void compress() {
        int overflow;
        this.fluids.removeIf(FluidStack::isEmpty);
        int i = 0;
        while (i + 1 < this.fluids.size()) {
            FluidStack b;
            FluidStack a = this.fluids.get(i);
            if (FluidStack.isSameFluidSameComponents((FluidStack)a, (FluidStack)(b = this.fluids.get(i + 1)))) {
                a.grow(b.getAmount());
                this.fluids.remove(i + 1);
                continue;
            }
            ++i;
        }
        if (this.fluids.isEmpty()) {
            this.fluids.add(FluidStack.EMPTY);
        }
        if ((overflow = Math.max(0, this.getTotalFluidAmount() - this.capacity)) > 0) {
            this.trimFromEnd(overflow);
        }
    }

    private void moveFirstNonEmptyToFront() {
        for (int i = 1; i < this.fluids.size(); ++i) {
            if (this.fluids.get(i).isEmpty()) continue;
            FluidStack f = this.fluids.remove(i);
            this.fluids.set(0, f);
            return;
        }
    }

    private void trimFromEnd(int toRemove) {
        for (int i = this.fluids.size() - 1; i >= 0 && toRemove > 0; --i) {
            FluidStack f = this.fluids.get(i);
            int take = Math.min(f.getAmount(), toRemove);
            f.shrink(take);
            toRemove -= take;
            if (!f.isEmpty()) continue;
            this.fluids.remove(i);
        }
        if (this.fluids.isEmpty()) {
            this.fluids.add(FluidStack.EMPTY);
        }
    }

    public boolean tryAlloy(Level level) {
        return this.tryAlloy(level, 1);
    }

    public boolean tryAlloy(Level level, int maxCraftsPerCall) {
        FluidStack out;
        AlloyingRecipe r;
        if (level.isClientSide) {
            return false;
        }
        boolean changed = false;
        this.fluids.removeIf(FluidStack::isEmpty);
        if (this.fluids.isEmpty()) {
            return false;
        }
        RecipeManager rm = level.getRecipeManager();
        List holders = rm.getAllRecipesFor((RecipeType)AllRecipes.ALLOYING.get());
        if (holders.isEmpty()) {
            return false;
        }
        List<AlloyingRecipe> recipes = holders.stream().map(RecipeHolder::value).toList();
        if (recipes.isEmpty()) {
            return false;
        }
        for (int crafts = 0; crafts < maxCraftsPerCall && (r = this.findCraftable(recipes)) != null && this.canAccept(out = r.getOutput()); ++crafts) {
            for (FluidStack needed : r.getInputs()) {
                this.subtractAcross(needed, needed.getAmount());
            }
            this.mergeIn(out);
            changed = true;
        }
        this.coalesce();
        if (this.fluids.isEmpty()) {
            this.fluids.add(FluidStack.EMPTY);
        }
        return changed;
    }

    private AlloyingRecipe findCraftable(List<AlloyingRecipe> recipes) {
        for (AlloyingRecipe r : recipes) {
            if (!this.canCraft(r)) continue;
            return r;
        }
        return null;
    }

    private boolean canCraft(AlloyingRecipe r) {
        List<FluidStack> req = r.getInputs();
        if (req == null || req.isEmpty()) {
            return false;
        }
        for (FluidStack needed : req) {
            if (needed.isEmpty() || needed.getAmount() <= 0) {
                return false;
            }
            if (this.countOf(needed) >= needed.getAmount()) continue;
            return false;
        }
        return true;
    }

    private boolean canAccept(FluidStack add) {
        return !add.isEmpty();
    }

    private static boolean sameKind(FluidStack a, FluidStack b) {
        return FluidStack.isSameFluidSameComponents((FluidStack)a, (FluidStack)b);
    }

    private int countOf(FluidStack kind) {
        int total = 0;
        for (FluidStack f : this.fluids) {
            if (f.isEmpty() || !CrucibleTank.sameKind(f, kind)) continue;
            total += f.getAmount();
        }
        return total;
    }

    private void subtractAcross(FluidStack kind, int amount) {
        if (amount <= 0) {
            return;
        }
        for (int i = 0; i < this.fluids.size() && amount > 0; ++i) {
            FluidStack f = this.fluids.get(i);
            if (f.isEmpty() || !CrucibleTank.sameKind(f, kind)) continue;
            int take = Math.min(f.getAmount(), amount);
            f.shrink(take);
            amount -= take;
            if (!f.isEmpty()) continue;
            this.fluids.remove(i);
            --i;
        }
    }

    private void mergeIn(FluidStack add) {
        if (add.isEmpty()) {
            return;
        }
        for (FluidStack f : this.fluids) {
            if (f.isEmpty() || !CrucibleTank.sameKind(f, add)) continue;
            f.grow(add.getAmount());
            return;
        }
        this.fluids.add(add.copy());
    }

    private void coalesce() {
        if (this.fluids.isEmpty()) {
            return;
        }
        ArrayList<FluidStack> out = new ArrayList<FluidStack>(this.fluids.size());
        for (FluidStack f : this.fluids) {
            if (f.isEmpty()) continue;
            boolean merged = false;
            for (FluidStack g : out) {
                if (!CrucibleTank.sameKind(f, g)) continue;
                g.grow(f.getAmount());
                merged = true;
                break;
            }
            if (merged) continue;
            out.add(f.copy());
        }
        this.fluids.clear();
        this.fluids.addAll(out);
    }
}

