/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.crucible_interface.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import dev.lopyluna.slag.SlagEmbers;
import dev.lopyluna.slag.client.FluidRenderHelper;
import dev.lopyluna.slag.content.blocks.crucible_interface.client.InterfaceMenu;
import dev.lopyluna.slag.network.packets.SelectFluidIndexC2S;
import dev.lopyluna.slag.register.AllLangs;
import dev.lopyluna.slag.register.AllTags;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class InterfaceScreen
extends AbstractContainerScreen<InterfaceMenu> {
    private static final ResourceLocation TEXTURE = SlagEmbers.loc("textures/gui/interface.png");
    private static final ResourceLocation TEXTURE_OVERLAY = SlagEmbers.loc("textures/gui/interface_overlay.png");
    private static final int BOX_X = 39;
    private static final int BOX_Y = 19;
    private static final int BOX_W = 97;
    private static final int BOX_H = 48;
    private final Level level;

    public InterfaceScreen(InterfaceMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.level = Minecraft.getInstance().level;
    }

    protected void renderBg(GuiGraphics g, float pt, int mx, int my) {
        int iX = (this.width - this.imageWidth) / 2;
        int iY = (this.height - this.imageHeight) / 2;
        g.blit(TEXTURE, iX, iY, 0, 0, this.imageWidth, this.imageHeight);
        this.renderFluidLayers(g, mx, my);
    }

    public void renderFluidLayers(GuiGraphics g, int mx, int my) {
        if (this.level == null) {
            return;
        }
        List<FluidStack> fluids = ((InterfaceMenu)this.menu).getFluids();
        if (fluids.isEmpty()) {
            return;
        }
        int boxX = this.leftPos + 39;
        int boxY = this.topPos + 19;
        int boxW = 97;
        int boxH = 48;
        int totalMb = 0;
        for (FluidStack f : fluids) {
            totalMb += f.getAmount();
        }
        if (totalMb <= 0) {
            return;
        }
        int yTop = boxY + boxH;
        int remainingH = boxH;
        int remainingMb = totalMb;
        for (int i = 0; i < fluids.size(); ++i) {
            FluidStack fs = fluids.get(i);
            int amt = fs.getAmount();
            if (amt <= 0) continue;
            int h = i == fluids.size() - 1 ? remainingH : Math.max(1, (int)Math.floor((double)amt / (double)remainingMb * (double)remainingH));
            int y = yTop - h;
            FluidRenderHelper.drawFluidBox(g, boxX, y, boxW, h, fs);
            yTop -= h;
            remainingMb -= amt;
            if ((remainingH -= h) <= 0) break;
        }
        PoseStack p = g.pose();
        p.pushPose();
        RenderSystem.enableBlend();
        g.blit(TEXTURE_OVERLAY, (this.width - this.imageWidth) / 2, (this.height - this.imageHeight) / 2, 0, 0, this.imageWidth, this.imageHeight);
        RenderSystem.disableBlend();
        p.popPose();
        if (mx >= boxX && mx < boxX + boxW && my >= boxY && my < boxY + boxH) {
            int yTop2 = boxY + boxH;
            int remH = boxH;
            int remMb = totalMb;
            for (int i = 0; i < fluids.size(); ++i) {
                FluidStack fs = fluids.get(i);
                int amt = fs.getAmount();
                if (amt <= 0) continue;
                int h = i == fluids.size() - 1 ? remH : Math.max(1, (int)Math.floor((double)amt / (double)remMb * (double)remH));
                int y = yTop2 - h;
                if (my >= y && my < yTop2) {
                    TooltipFlag.Default tooltipFlag = Minecraft.getInstance().options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL;
                    ArrayList<Component> tooltip = new ArrayList<Component>();
                    tooltip.add(fs.getDisplayName());
                    InterfaceScreen.createLang(fs, tooltip).run();
                    if (tooltipFlag.advanced()) {
                        tooltip.add((Component)Component.literal((String)BuiltInRegistries.FLUID.getKey((Object)fs.getFluid()).toString()).withStyle(ChatFormatting.DARK_GRAY));
                    }
                    g.renderTooltip(this.font, tooltip, Optional.empty(), mx, my);
                    break;
                }
                yTop2 -= h;
                remH -= h;
                remMb -= amt;
            }
        }
    }

    public static Runnable createLang(FluidStack fs, List<Component> tooltip) {
        boolean shift = !InterfaceScreen.hasShiftDown();
        int amount = fs.getAmount();
        if (fs.is(AllTags.MOLTEN_METALS)) {
            return () -> {
                if (shift) {
                    InterfaceScreen.createTooltipAmounts(tooltip, amount, InterfaceScreen.pNS("blocks", 648), InterfaceScreen.pNS("ingots", 72), InterfaceScreen.pNS("nuggets", 8));
                } else {
                    InterfaceScreen.extra(amount, tooltip);
                }
            };
        }
        if (fs.is(AllTags.MOLTEN_GEMS)) {
            return () -> {
                if (shift) {
                    InterfaceScreen.createTooltipAmounts(tooltip, amount, InterfaceScreen.pNS("blocks", 648), InterfaceScreen.pNS("gems", 72), InterfaceScreen.pNS("shards", 18));
                } else {
                    InterfaceScreen.extra(amount, tooltip);
                }
            };
        }
        if (fs.is(AllTags.MOLTEN_CRYSTALS)) {
            return () -> {
                if (shift) {
                    InterfaceScreen.createTooltipAmounts(tooltip, amount, InterfaceScreen.pNS("blocks", 288), InterfaceScreen.pNS("gems", 72), InterfaceScreen.pNS("shards", 18));
                } else {
                    InterfaceScreen.extra(amount, tooltip);
                }
            };
        }
        if (fs.is(AllTags.MOLTEN_DUSTS)) {
            return () -> {
                if (shift) {
                    InterfaceScreen.createTooltipAmounts(tooltip, amount, InterfaceScreen.pNS("blocks", 648), InterfaceScreen.pNS("dusts", 72), InterfaceScreen.pNS("grits", 8));
                } else {
                    InterfaceScreen.extra(amount, tooltip);
                }
            };
        }
        if (fs.is(AllTags.MOLTEN_DUSTS_SMALL)) {
            return () -> {
                if (shift) {
                    InterfaceScreen.createTooltipAmounts(tooltip, amount, InterfaceScreen.pNS("blocks", 288), InterfaceScreen.pNS("dusts", 72), InterfaceScreen.pNS("grits", 8));
                } else {
                    InterfaceScreen.extra(amount, tooltip);
                }
            };
        }
        if (fs.is(AllTags.MOLTEN_BALLS)) {
            return () -> {
                if (shift) {
                    InterfaceScreen.createTooltipAmounts(tooltip, amount, InterfaceScreen.pNS("blocks", 648), InterfaceScreen.pNS("balls", 72));
                } else {
                    InterfaceScreen.extra(amount, tooltip);
                }
            };
        }
        if (fs.is(AllTags.MOLTEN_BALLS_SMALL)) {
            return () -> {
                if (shift) {
                    InterfaceScreen.createTooltipAmounts(tooltip, amount, InterfaceScreen.pNS("blocks", 288), InterfaceScreen.pNS("balls", 72));
                } else {
                    InterfaceScreen.extra(amount, tooltip);
                }
            };
        }
        return () -> InterfaceScreen.extra(amount, tooltip);
    }

    @SafeVarargs
    public static void createTooltipAmounts(List<Component> tooltip, int amount, Pair<String, Integer> ... pairs) {
        int n = pairs.length;
        String[] keys = new String[n];
        int[] sizes = new int[n + 1];
        for (int i = 0; i < n; ++i) {
            Pair<String, Integer> p = Objects.requireNonNull(pairs[i], "pair");
            keys[i] = Objects.requireNonNull((String)p.getFirst(), "name");
            sizes[i] = Objects.requireNonNull((Integer)p.getSecond(), "size");
            if (sizes[i] <= 0) {
                throw new IllegalArgumentException("size must be > 0");
            }
            if (i <= 0 || sizes[i] < sizes[i - 1]) continue;
            throw new IllegalArgumentException("sizes must be strictly descending");
        }
        sizes[n] = 1;
        int[] m = InterfaceScreen.breakdown(amount, sizes);
        for (int i = 0; i < n; ++i) {
            AllLangs.trAmounts(tooltip, keys[i], m[i], true);
        }
        AllLangs.trAmounts(tooltip, "mb", m[n], false);
    }

    public static Pair<String, Integer> pNS(String name, int size) {
        return Pair.of((Object)name, (Object)size);
    }

    private static int[] breakdown(int amount, int ... sizes) {
        int[] out = new int[sizes.length];
        int rem = amount;
        for (int i = 0; i < sizes.length; ++i) {
            int v = sizes[i];
            if (v <= 0) {
                throw new IllegalArgumentException("size must be > 0");
            }
            out[i] = rem / v;
            rem %= v;
        }
        return out;
    }

    public static void extra(int amount, List<Component> tooltip) {
        int b = (int)((float)amount / 1000.0f);
        int mb = amount - b * 1000;
        AllLangs.trAmounts(tooltip, "buckets", b, true);
        AllLangs.trAmounts(tooltip, "mb", mb, false);
    }

    public boolean mouseClicked(double mx, double my, int button) {
        if (this.level == null || !((InterfaceMenu)this.menu).isCrucible()) {
            return super.mouseClicked(mx, my, button);
        }
        if (button == 0) {
            List<FluidStack> fluids;
            int boxX = this.leftPos + 39;
            int boxY = this.topPos + 19;
            int boxH = 48;
            if (mx >= (double)boxX && mx < (double)(boxX + 97) && my >= (double)boxY && my < (double)(boxY + boxH) && !(fluids = ((InterfaceMenu)this.menu).getFluids()).isEmpty()) {
                int totalMb = 0;
                for (FluidStack f : fluids) {
                    totalMb += f.getAmount();
                }
                if (totalMb > 0) {
                    int yTop = boxY + boxH;
                    int remH = boxH;
                    int remMb = totalMb;
                    for (int i = 0; i < fluids.size(); ++i) {
                        FluidStack fs = fluids.get(i);
                        int amt = fs.getAmount();
                        if (amt <= 0) continue;
                        int h = i == fluids.size() - 1 ? remH : Math.max(1, (int)Math.floor((double)amt / (double)remMb * (double)remH));
                        int y = yTop - h;
                        if (my >= (double)y && my < (double)yTop && i != 0) {
                            FluidType type = fs.getFluidType();
                            Optional.ofNullable(type.getSound(SoundActions.BUCKET_FILL)).ifPresent(s -> ((InterfaceMenu)this.menu).player.playSound(s, 0.5f, 1.0f));
                            Optional.ofNullable(type.getSound(SoundActions.BUCKET_EMPTY)).ifPresent(s -> ((InterfaceMenu)this.menu).player.playSound(s, 0.5f, 1.0f));
                            PacketDistributor.sendToServer((CustomPacketPayload)new SelectFluidIndexC2S(((InterfaceMenu)this.menu).getControllerPos(), i), (CustomPacketPayload[])new CustomPacketPayload[0]);
                            return true;
                        }
                        yTop -= h;
                        remH -= h;
                        remMb -= amt;
                    }
                }
            }
        }
        return super.mouseClicked(mx, my, button);
    }

    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTick) {
        super.render(gui, mouseX, mouseY, partialTick);
        PoseStack p = gui.pose();
        p.pushPose();
        RenderSystem.enableBlend();
        this.renderTooltip(gui, mouseX, mouseY);
        RenderSystem.disableBlend();
        p.popPose();
    }
}

