/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.drain;

import dev.lopyluna.slag.content.blocks.drain.DrainBlock;
import dev.lopyluna.slag.content.blocks.drain.DrainState;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class DrainBE
extends BlockEntity {
    public DrainState drainState = DrainState.OFF;
    public FluidStack drainingFluid = FluidStack.EMPTY;
    int random = 0;

    public DrainBE(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    private IFluidHandler getFluidHandlerDir(Direction dir) {
        assert (this.level != null);
        BlockPos pos = this.worldPosition.relative(dir);
        if (!this.level.isLoaded(pos)) {
            return null;
        }
        BlockEntity be = this.level.getBlockEntity(pos);
        if (be == null) {
            return null;
        }
        return (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, pos, (Object)dir.getOpposite());
    }

    public IFluidHandler getInputHandler() {
        return this.getFluidHandlerDir(((Direction)this.getBlockState().getValue((Property)DrainBlock.FACING)).getOpposite());
    }

    public IFluidHandler getOutputHandler() {
        return this.getFluidHandlerDir(Direction.DOWN);
    }

    public void checkPowered() {
        if (this.level == null) {
            return;
        }
        this.drainState = this.level.hasNeighborSignal(this.worldPosition) ? DrainState.POWERED : (this.drainState == DrainState.POURING ? DrainState.POURING : DrainState.OFF);
    }

    public void cycleDrain() {
        if (this.drainState != DrainState.POWERED) {
            this.drainState = this.drainState == DrainState.OFF ? DrainState.POURING : DrainState.OFF;
        }
    }

    public void update() {
        this.setChanged();
        if (this.level == null) {
            return;
        }
        BlockState state = this.getBlockState();
        this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
    }

    public void tick() {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        if (this.drainState == DrainState.OFF) {
            if (this.level.random.nextInt(6) == 0) {
                this.random = Mth.clamp((int)(((GameRules.IntegerValue)this.level.getGameRules().getRule(GameRules.RULE_RANDOMTICKING)).getCommandResult() * 2), (int)0, (int)128);
            }
            if (this.random != 0 && this.level.random.nextInt(129 - this.random) == 0) {
                this.checkPowered();
            }
        }
        FluidStack prevFluid = this.drainingFluid.copy();
        DrainState prevState = this.drainState;
        DrainState drain = this.drain(this.drainState);
        if (drain != null && drain != this.drainState) {
            this.drainState = drain;
        }
        if (!FluidStack.isSameFluidSameComponents((FluidStack)prevFluid, (FluidStack)this.drainingFluid) || prevState != this.drainState) {
            this.update();
        }
    }

    public DrainState drain(DrainState cur) {
        int outputCapacity;
        this.drainingFluid = FluidStack.EMPTY;
        if (cur == DrainState.OFF) {
            return null;
        }
        IFluidHandler inputInv = this.getInputHandler();
        if (inputInv == null) {
            return null;
        }
        IFluidHandler outputInv = this.getOutputHandler();
        if (outputInv == null) {
            return null;
        }
        FluidStack inputFluid = inputInv.getFluidInTank(0);
        if (inputFluid.isEmpty()) {
            return DrainState.OFF;
        }
        FluidStack outputFluid = outputInv.getFluidInTank(0);
        int outputAmount = outputFluid.getAmount();
        if (outputAmount >= (outputCapacity = outputInv.getTankCapacity(0))) {
            return cur == DrainState.POWERED ? cur : DrainState.OFF;
        }
        int targetDrain = Mth.clamp((int)(outputFluid.isEmpty() ? 1 : 25), (int)0, (int)(outputCapacity - outputAmount));
        if (targetDrain == 0) {
            return cur == DrainState.POWERED ? cur : DrainState.OFF;
        }
        FluidStack drained = inputInv.drain(targetDrain, IFluidHandler.FluidAction.SIMULATE);
        if (drained.getAmount() != outputInv.fill(drained, IFluidHandler.FluidAction.SIMULATE)) {
            return cur == DrainState.POWERED ? cur : DrainState.OFF;
        }
        this.drainingFluid = inputFluid;
        inputInv.drain(targetDrain, IFluidHandler.FluidAction.EXECUTE);
        outputInv.fill(drained, IFluidHandler.FluidAction.EXECUTE);
        return cur;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (this.drainState == null || this.drainState == DrainState.OFF) {
            this.drainState = DrainState.fromString(tag.getString("state"));
        }
        this.drainingFluid = FluidStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("Fluid"));
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.drainState != null) {
            tag.putString("state", String.valueOf((Object)this.drainState));
        }
        if (!this.drainingFluid.isEmpty()) {
            tag.put("Fluid", this.drainingFluid.save(registries));
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }
}

