/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.drain;

import com.mojang.serialization.MapCodec;
import dev.lopyluna.slag.content.blocks.drain.DrainBE;
import dev.lopyluna.slag.content.blocks.melter.MelterBlock;
import dev.lopyluna.slag.content.blocks.smart.SmartBlock;
import dev.lopyluna.slag.content.utils.ShapeUtils;
import dev.lopyluna.slag.register.AllBETypes;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class DrainBlock
extends SmartBlock<DrainBE> {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final MapCodec<DrainBlock> CODEC = DrainBlock.simpleCodec(DrainBlock::new);

    public DrainBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (player.isShiftKeyDown() || !((blockEntity = level.getBlockEntity(pos)) instanceof DrainBE)) {
            return InteractionResult.PASS;
        }
        DrainBE be = (DrainBE)blockEntity;
        be.cycleDrain();
        return InteractionResult.SUCCESS;
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return ShapeUtils.shape(4.0, 4.0, 8.0, 12.0, 12.0, 16.0).forHorizontal(Direction.NORTH).get((Direction)state.getValue((Property)FACING));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{FACING}));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos;
        Level level;
        BlockState state;
        Direction face = context.getClickedFace();
        boolean horizontal = face.getAxis().isHorizontal();
        if (horizontal && (state = (level = context.getLevel()).getBlockState((pos = context.getClickedPos()).relative(face.getOpposite()))).getBlock() instanceof MelterBlock && ((Direction)state.getValue((Property)MelterBlock.FACING)).equals((Object)face.getOpposite())) {
            return null;
        }
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)(horizontal ? face : context.getHorizontalDirection()));
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DrainBE) {
            DrainBE be = (DrainBE)blockEntity;
            be.checkPowered();
            if (!level.isClientSide) {
                be.drainingFluid = FluidStack.EMPTY;
                be.setChanged();
                level.sendBlockUpdated(pos, state, state, 3);
            }
        }
    }

    @Override
    public <S extends BlockEntity> BlockEntityTicker<S> getTicker(Level level, BlockState state, BlockEntityType<S> type) {
        return (level1, blockPos, blockState, s) -> {
            if (!(s instanceof DrainBE)) {
                return;
            }
            DrainBE be = (DrainBE)s;
            be.tick();
        };
    }

    @Override
    public Class<DrainBE> getBlockEntityClass() {
        return DrainBE.class;
    }

    @Override
    public BlockEntityType<? extends DrainBE> getBlockEntityType() {
        return (BlockEntityType)AllBETypes.DRAIN.get();
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

