/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.drain;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.lopyluna.slag.client.FluidRenderHelper;
import dev.lopyluna.slag.content.blocks.drain.DrainBE;
import dev.lopyluna.slag.content.blocks.drain.DrainState;
import dev.lopyluna.slag.content.blocks.multiblock.renderer.SafeBlockEntityRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.neoforge.fluids.FluidStack;

public class DrainRenderer
extends SafeBlockEntityRenderer<DrainBE> {
    public DrainRenderer(BlockEntityRendererProvider.Context context) {
    }

    @Override
    protected void renderSafe(DrainBE be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        Vec3 end;
        FluidStack fluid = be.drainingFluid;
        if (fluid == null || fluid.isEmpty() || be.drainState == null || be.drainState == DrainState.OFF) {
            return;
        }
        Level level = be.getLevel();
        if (level == null) {
            return;
        }
        BlockPos pos = be.getBlockPos();
        Vec3 start = Vec3.atCenterOf((Vec3i)pos).add(0.0, -0.5, 0.0);
        ClipContext ctx = new ClipContext(start, end = start.add(0.0, -32.0, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty());
        BlockHitResult hit = level.clip(ctx);
        double yHit = hit.getType() == HitResult.Type.BLOCK ? hit.getLocation().y() : end.y;
        double fallHeight = start.y - yHit;
        float minX = 0.375f;
        float maxX = 0.625f;
        float minZ = 0.375f;
        float maxZ = 0.625f;
        float topY = 0.625f;
        float bottomY = (float)(-fallHeight);
        FluidRenderHelper.renderFlowingFluidBox(fluid, minX, bottomY, minZ, maxX, topY, maxZ, buffer, ms, light, true, true);
    }
}

