/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.forge;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lopyluna.slag.content.blocks.forge.DoubleSmeltingRecipe;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class DoubleSmeltingRecipeSer
implements RecipeSerializer<DoubleSmeltingRecipe> {
    private final DoubleSmeltingRecipe.Factory factory;
    private final MapCodec<DoubleSmeltingRecipe> codec;
    private final StreamCodec<RegistryFriendlyByteBuf, DoubleSmeltingRecipe> streamCodec;

    public DoubleSmeltingRecipeSer(DoubleSmeltingRecipe.Factory factory, int cookingTime) {
        this.factory = factory;
        this.codec = RecordCodecBuilder.mapCodec(instance -> {
            Products.P6 recipe = instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(Recipe::getGroup), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredientA").forGetter(DoubleSmeltingRecipe::getInputA), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredientB").forGetter(DoubleSmeltingRecipe::getInputB), (App)ItemStack.CODEC.fieldOf("result").forGetter(DoubleSmeltingRecipe::getOutput), (App)Codec.FLOAT.fieldOf("experience").orElse((Object)Float.valueOf(0.0f)).forGetter(DoubleSmeltingRecipe::getExperience), (App)Codec.INT.fieldOf("cookingTime").orElse((Object)cookingTime).forGetter(DoubleSmeltingRecipe::getCookingTime));
            Objects.requireNonNull(factory);
            return recipe.apply((Applicative)instance, factory::create);
        });
        this.streamCodec = StreamCodec.of(this::toNetwork, this::fromNetwork);
    }

    public String toString() {
        return "double_smelting";
    }

    @NotNull
    public MapCodec<DoubleSmeltingRecipe> codec() {
        return this.codec;
    }

    @NotNull
    public StreamCodec<RegistryFriendlyByteBuf, DoubleSmeltingRecipe> streamCodec() {
        return this.streamCodec;
    }

    private DoubleSmeltingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
        String s = buffer.readUtf();
        Ingredient ingredientA = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
        Ingredient ingredientB = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
        ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
        float f = buffer.readFloat();
        int i = buffer.readVarInt();
        return this.factory.create(s, ingredientA, ingredientB, itemstack, f, i);
    }

    private void toNetwork(RegistryFriendlyByteBuf buffer, DoubleSmeltingRecipe recipe) {
        buffer.writeUtf(recipe.getGroup());
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.getInputA());
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.getInputB());
        ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.getOutput());
        buffer.writeFloat(recipe.getExperience());
        buffer.writeVarInt(recipe.getCookingTime());
    }

    public DoubleSmeltingRecipe create(String group, Ingredient ingredientA, Ingredient ingredientB, ItemStack result, float experience, int cookingTime) {
        return this.factory.create(group, ingredientA, ingredientB, result, experience, cookingTime);
    }
}

