/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.forge;

import dev.lopyluna.slag.content.blocks.forge.DoubleSmeltingRecipe;
import dev.lopyluna.slag.content.blocks.forge.ForgeBlock;
import dev.lopyluna.slag.content.blocks.forge.client.ForgeMenu;
import dev.lopyluna.slag.register.AllRecipes;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class ForgeBE
extends BaseContainerBlockEntity
implements RecipeCraftingHolder,
WorldlyContainer {
    private NonNullList<ItemStack> items = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed;
    private final RecipeManager.CachedCheck<DoubleSmeltingRecipe.DoubleRecipeInput, DoubleSmeltingRecipe> quickCheck;
    private int litTime;
    private int litDuration;
    private int cookingProgress;
    private int cookingTotalTime;
    public final ContainerData data = new ContainerData(){

        public int get(int i) {
            return switch (i) {
                case 0 -> ForgeBE.this.litTime;
                case 1 -> ForgeBE.this.litDuration;
                case 2 -> ForgeBE.this.cookingProgress;
                case 3 -> ForgeBE.this.cookingTotalTime;
                default -> 0;
            };
        }

        public void set(int i, int j) {
            switch (i) {
                case 0: {
                    ForgeBE.this.litTime = j;
                    break;
                }
                case 1: {
                    ForgeBE.this.litDuration = j;
                    break;
                }
                case 2: {
                    ForgeBE.this.cookingProgress = j;
                    break;
                }
                case 3: {
                    ForgeBE.this.cookingTotalTime = j;
                }
            }
        }

        public int getCount() {
            return 4;
        }
    };

    public ForgeBE(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
        this.recipesUsed = new Object2IntOpenHashMap();
        this.quickCheck = RecipeManager.createCheck((RecipeType)((RecipeType)AllRecipes.DOUBLE_SMELTING.get()));
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)this.getBlockState().getBlock().getDescriptionId());
    }

    @NotNull
    protected Component getDefaultName() {
        return this.getDisplayName();
    }

    @NotNull
    protected AbstractContainerMenu createMenu(int syncId, Inventory inventory) {
        return new ForgeMenu(syncId, inventory, (Container)this, this.data);
    }

    public int getContainerSize() {
        return this.items.size();
    }

    @NotNull
    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.items, (HolderLookup.Provider)provider);
        this.litTime = nbt.getInt("LitTime");
        this.cookingProgress = nbt.getInt("CookingProgress");
        this.cookingTotalTime = nbt.getInt("CookingTotalTime");
        this.litDuration = this.getBurnDuration((ItemStack)this.items.get(2));
        CompoundTag tag = nbt.getCompound("RecipesUsed");
        for (String s : tag.getAllKeys()) {
            this.recipesUsed.put((Object)ResourceLocation.parse((String)s), tag.getInt(s));
        }
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.saveAdditional(nbt, provider);
        nbt.putInt("LitTime", this.litTime);
        nbt.putInt("CookingProgress", this.cookingProgress);
        nbt.putInt("CookingTotalTime", this.cookingTotalTime);
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.items, (HolderLookup.Provider)provider);
        CompoundTag tag = new CompoundTag();
        this.recipesUsed.forEach((loc, i) -> tag.putInt(loc.toString(), i.intValue()));
        nbt.put("RecipesUsed", (Tag)tag);
    }

    public void setItem(int slot, ItemStack stack) {
        assert (this.level != null);
        ItemStack slotStack = (ItemStack)this.items.get(slot);
        boolean flag = !stack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)stack);
        this.items.set(slot, (Object)stack);
        stack.limitSize(this.getMaxStackSize(stack));
        if (slot == 0 && !flag) {
            this.cookingTotalTime = ForgeBE.getTotalCookTime(this.level, this);
            this.cookingProgress = 0;
            this.setChanged();
        }
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        if (index == 3) {
            return false;
        }
        if (index != 2) {
            return true;
        }
        return ForgeBE.getBurnTime(stack) > 0 || stack.is(Items.BUCKET) && !((ItemStack)this.items.get(2)).is(Items.BUCKET);
    }

    public void fillStackedContents(StackedContents helper) {
        for (ItemStack stack : this.items) {
            helper.accountStack(stack);
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public boolean isLit() {
        return this.litTime > 0;
    }

    protected int getBurnDuration(ItemStack fuel) {
        return fuel.isEmpty() ? 0 : fuel.getBurnTime((RecipeType)AllRecipes.DOUBLE_SMELTING.get());
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ForgeBE be) {
        boolean flag = be.isLit();
        boolean flag1 = false;
        if (be.isLit()) {
            --be.litTime;
        }
        ItemStack fuel = (ItemStack)be.items.get(2);
        ItemStack stackA = (ItemStack)be.items.get(0);
        ItemStack stackB = (ItemStack)be.items.get(1);
        boolean flag2 = !stackA.isEmpty() && !stackB.isEmpty();
        boolean flag3 = !fuel.isEmpty();
        RegistryAccess access = level.registryAccess();
        if (be.isLit() || flag3 && flag2) {
            RecipeHolder recipeholder = null;
            if (flag2) {
                recipeholder = be.quickCheck.getRecipeFor((RecipeInput)new DoubleSmeltingRecipe.DoubleRecipeInput(stackA, stackB), level).orElse(null);
            }
            int i = be.getMaxStackSize();
            if (!be.isLit() && ForgeBE.canBurn(access, recipeholder, be.items, i, be)) {
                be.litDuration = be.litTime = be.getBurnDuration(fuel);
                if (be.isLit()) {
                    flag1 = true;
                    if (fuel.hasCraftingRemainingItem()) {
                        be.items.set(2, (Object)fuel.getCraftingRemainingItem());
                    } else if (flag3) {
                        Item fuelItem = fuel.getItem();
                        fuel.shrink(1);
                        if (fuel.isEmpty()) {
                            be.items.set(2, (Object)fuel.getCraftingRemainingItem());
                        }
                    }
                }
            }
            if (be.isLit() && ForgeBE.canBurn(access, recipeholder, be.items, i, be)) {
                ++be.cookingProgress;
                if (be.cookingProgress == be.cookingTotalTime) {
                    be.cookingProgress = 0;
                    be.cookingTotalTime = ForgeBE.getTotalCookTime(level, be);
                    if (ForgeBE.burn(access, recipeholder, be.items, i, be)) {
                        be.setRecipeUsed(recipeholder);
                    }
                    flag1 = true;
                }
            } else {
                be.cookingProgress = 0;
            }
        } else if (!be.isLit() && be.cookingProgress > 0) {
            be.cookingProgress = Mth.clamp((int)(be.cookingProgress - 2), (int)0, (int)be.cookingTotalTime);
        }
        if (flag != be.isLit()) {
            flag1 = true;
            state = (BlockState)state.setValue((Property)ForgeBlock.LIT, (Comparable)Boolean.valueOf(be.isLit()));
            level.setBlock(pos, state, 3);
        }
        if (flag1) {
            ForgeBE.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos blockPos, BlockState blockState, T t) {
        if (t instanceof ForgeBE) {
            ForgeBE be = (ForgeBE)t;
            ForgeBE.serverTick(level, blockPos, blockState, be);
        }
    }

    private static void createExperience(ServerLevel level, Vec3 popVec, int recipeIndex, float experience) {
        int i = Mth.floor((float)((float)recipeIndex * experience));
        float f = Mth.frac((float)((float)recipeIndex * experience));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        ExperienceOrb.award((ServerLevel)level, (Vec3)popVec, (int)i);
    }

    private static int getBurnTime(ItemStack stack) {
        return stack.getBurnTime(RecipeType.SMELTING);
    }

    private static int getTotalCookTime(Level level, ForgeBE be) {
        DoubleSmeltingRecipe.DoubleRecipeInput input = new DoubleSmeltingRecipe.DoubleRecipeInput(be.getItem(0), be.getItem(1));
        return be.quickCheck.getRecipeFor((RecipeInput)input, level).map(holder -> ((DoubleSmeltingRecipe)holder.value()).getCookingTime()).orElse(200);
    }

    private static boolean canBurn(RegistryAccess access, @Nullable RecipeHolder<?> holder, NonNullList<ItemStack> inventory, int maxStackSize, ForgeBE be) {
        Recipe recipe;
        if (!((ItemStack)inventory.get(0)).isEmpty() && !((ItemStack)inventory.get(1)).isEmpty() && holder != null && (recipe = holder.value()) instanceof DoubleSmeltingRecipe) {
            DoubleSmeltingRecipe recipe2 = (DoubleSmeltingRecipe)recipe;
            ItemStack assembled = recipe2.assemble(new DoubleSmeltingRecipe.DoubleRecipeInput(be.getItem(0), be.getItem(1)), (HolderLookup.Provider)access);
            if (assembled.isEmpty()) {
                return false;
            }
            ItemStack result = (ItemStack)inventory.get(3);
            if (result.isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)result, (ItemStack)assembled)) {
                return false;
            }
            return result.getCount() + assembled.getCount() <= maxStackSize && result.getCount() + assembled.getCount() <= result.getMaxStackSize() || result.getCount() + assembled.getCount() <= assembled.getMaxStackSize();
        }
        return false;
    }

    private static boolean burn(RegistryAccess access, @Nullable RecipeHolder<?> holder, NonNullList<ItemStack> inventory, int maxStackSize, ForgeBE be) {
        Recipe recipe;
        if (holder != null && (recipe = holder.value()) instanceof DoubleSmeltingRecipe) {
            DoubleSmeltingRecipe recipe2 = (DoubleSmeltingRecipe)recipe;
            if (ForgeBE.canBurn(access, holder, inventory, maxStackSize, be)) {
                ItemStack stackA = (ItemStack)inventory.get(0);
                ItemStack stackB = (ItemStack)inventory.get(1);
                ItemStack assembled = recipe2.assemble(new DoubleSmeltingRecipe.DoubleRecipeInput(be.getItem(0), be.getItem(1)), (HolderLookup.Provider)access);
                ItemStack result = (ItemStack)inventory.get(3);
                if (result.isEmpty()) {
                    inventory.set(3, (Object)assembled.copy());
                } else if (ItemStack.isSameItemSameComponents((ItemStack)result, (ItemStack)assembled)) {
                    result.grow(assembled.getCount());
                }
                stackA.shrink(1);
                stackB.shrink(1);
                return true;
            }
        }
        return false;
    }

    @Nullable
    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    public void awardUsedRecipes(Player player, List<ItemStack> items) {
    }

    public void setRecipeUsed(@Nullable RecipeHolder<?> recipe) {
        if (recipe != null) {
            this.recipesUsed.addTo((Object)recipe.id(), 1);
        }
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer player) {
        List<RecipeHolder<?>> list = this.getRecipesToAwardAndPopExperience(player.serverLevel(), player.position());
        player.awardRecipes(list);
        for (RecipeHolder<?> holder : list) {
            if (holder == null) continue;
            player.triggerRecipeCrafted(holder, this.items);
        }
        this.recipesUsed.clear();
    }

    public List<RecipeHolder<?>> getRecipesToAwardAndPopExperience(ServerLevel level, Vec3 popVec) {
        ArrayList list = new ArrayList();
        for (Object2IntMap.Entry resourceLocationEntry : this.recipesUsed.object2IntEntrySet()) {
            level.getRecipeManager().byKey((ResourceLocation)resourceLocationEntry.getKey()).ifPresent(holder -> {
                Recipe patt0$temp = holder.value();
                if (patt0$temp instanceof DoubleSmeltingRecipe) {
                    DoubleSmeltingRecipe recipe = (DoubleSmeltingRecipe)patt0$temp;
                    list.add((RecipeHolder<?>)holder);
                    ForgeBE.createExperience(level, popVec, resourceLocationEntry.getIntValue(), recipe.getExperience());
                }
            });
        }
        return list;
    }

    public int @NotNull [] getSlotsForFace(Direction direction) {
        int[] nArray;
        Direction facing = (Direction)this.getBlockState().getValue((Property)ForgeBlock.FACING);
        if (direction == Direction.DOWN) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 3;
        } else if (direction == Direction.UP) {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 2;
        } else if (facing == direction) {
            nArray = new int[]{};
        } else {
            switch (facing) {
                case NORTH: 
                case SOUTH: 
                case WEST: 
                case EAST: {
                    if (facing.getClockWise() == direction) {
                        int[] nArray4 = new int[1];
                        nArray = nArray4;
                        nArray4[0] = 0;
                        break;
                    }
                    if (facing.getCounterClockWise() == direction) {
                        int[] nArray5 = new int[1];
                        nArray = nArray5;
                        nArray5[0] = 1;
                        break;
                    }
                    int[] nArray6 = new int[1];
                    nArray = nArray6;
                    nArray6[0] = 2;
                    break;
                }
                default: {
                    nArray = new int[]{};
                }
            }
        }
        return nArray;
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack stack, @Nullable Direction direction) {
        return this.canPlaceItem(index, stack);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return direction != Direction.DOWN || index != 2 || stack.is(Items.WATER_BUCKET) || stack.is(Items.BUCKET);
    }
}

