/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.forge;

import com.mojang.serialization.MapCodec;
import dev.lopyluna.slag.content.blocks.BEBlock;
import dev.lopyluna.slag.content.blocks.forge.ForgeBE;
import dev.lopyluna.slag.register.AllBETypes;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class ForgeBlock
extends BEBlock {
    public static final MapCodec<ForgeBlock> CODEC = ForgeBlock.simpleCodec(ForgeBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;

    public ForgeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, LIT});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)blockPlaceContext.getHorizontalDirection().getOpposite());
    }

    public void stepOn(Level pLevel, BlockPos pPos, BlockState pState, Entity pEntity) {
        LivingEntity living;
        if (pLevel.random.nextDouble() < 0.2 && ((Boolean)pState.getValue((Property)LIT)).booleanValue() && !pEntity.isSteppingCarefully() && pEntity instanceof LivingEntity && (living = (LivingEntity)pEntity).getHealth() > 1.0f) {
            pEntity.hurt(pLevel.damageSources().hotFloor(), 1.0f);
        }
        super.stepOn(pLevel, pPos, pState, pEntity);
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (((Boolean)pState.getValue((Property)LIT)).booleanValue()) {
            double d0 = (double)pPos.getX() + 0.5;
            double d1 = pPos.getY();
            double d2 = (double)pPos.getZ() + 0.5;
            if (pRandom.nextDouble() < 0.1) {
                pLevel.playLocalSound(d0, d1 + 0.625, d2, SoundEvents.FURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 0.75f, 0.95f, false);
                pLevel.playLocalSound(d0, d1 + 0.625, d2, SoundEvents.SMOKER_SMOKE, SoundSource.BLOCKS, 0.75f, 0.95f, false);
            }
            Direction direction = (Direction)pState.getValue((Property)FACING);
            Direction.Axis axis = direction.getAxis();
            double d4 = pRandom.nextDouble() * 0.6 - 0.3;
            double d5 = axis == Direction.Axis.Z ? (double)direction.getStepZ() * 0.5 : d4;
            double d6 = pRandom.nextDouble() * 0.15625;
            double d7 = axis == Direction.Axis.X ? (double)direction.getStepX() * 0.5 : d4;
            double d8 = axis == Direction.Axis.Z ? (double)direction.getStepZ() * -0.5 : d4;
            double d9 = axis == Direction.Axis.X ? (double)direction.getStepX() * -0.5 : d4;
            double d10 = axis == Direction.Axis.X ? (double)direction.getStepX() * 0.5 : d4;
            double d11 = axis == Direction.Axis.Z ? (double)direction.getStepZ() * 0.5 : d4;
            pLevel.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 + d5, d1 + 0.53125 + d6, d2 + d7, 0.0, 0.0, 0.0);
            pLevel.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 + d5, d1 + 0.53125 + d6, d2 + d7, 0.0, 0.0, 0.0);
            pLevel.addParticle((ParticleOptions)ParticleTypes.FLAME, d0 + d5, d1 + 0.53125 + d6, d2 + d7, 0.0, 0.0, 0.0);
            pLevel.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 + d8, d1 + 0.53125 + d6, d2 + d9, 0.0, 0.0, 0.0);
            pLevel.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 + d8, d1 + 0.53125 + d6, d2 + d9, 0.0, 0.0, 0.0);
            pLevel.addParticle((ParticleOptions)ParticleTypes.FLAME, d0 + d8, d1 + 0.53125 + d6, d2 + d9, 0.0, 0.0, 0.0);
            pLevel.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 + d10, d1 + 0.625 + d6, d2 + d11, 0.0, 0.0, 0.0);
            pLevel.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 + d10, d1 + 0.625 + d6, d2 + d11, 0.0, 0.0, 0.0);
            pLevel.addParticle((ParticleOptions)ParticleTypes.FLAME, d0 + d10, d1 + 0.625 + d6, d2 + d11, 0.0, 0.0, 0.0);
            pLevel.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 + d4 / 0.9, d1 + 1.1, d2 + d4 / 0.9, 0.0, 0.0, 0.0);
            pLevel.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 + d4 / 0.9, d1 + 1.1, d2 + d4 / 0.9, 0.0, 0.0, 0.0);
            pLevel.addParticle((ParticleOptions)ParticleTypes.FLAME, d0 + d4 / 0.9, d1 + 1.1, d2 + d4 / 0.9, 0.0, 0.0, 0.0);
        }
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        MenuProvider provider;
        if (!level.isClientSide && (provider = state.getMenuProvider(level, pos)) != null) {
            player.openMenu(provider);
        }
        return InteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof ForgeBE) {
                ForgeBE be = (ForgeBE)blockEntity;
                Containers.dropContents((Level)level, (BlockPos)pos, (Container)be);
                if (level instanceof ServerLevel) {
                    ServerLevel server = (ServerLevel)level;
                    be.getRecipesToAwardAndPopExperience(server, Vec3.atCenterOf((Vec3i)pos));
                }
                super.onRemove(state, level, pos, newState, moved);
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            } else {
                super.onRemove(state, level, pos, newState, moved);
            }
        }
    }

    @NotNull
    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return super.rotate(pState, pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    public boolean hasAnalogOutputSignal(BlockState blockState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos blockPos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)level.getBlockEntity(blockPos));
    }

    @NotNull
    public RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    @Override
    @NotNull
    public BlockEntityType<? extends BlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBETypes.FORGE.get();
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : ForgeBE::serverTick;
    }
}

