/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.melter;

import dev.lopyluna.slag.content.blocks.melter.MelterBlock;
import dev.lopyluna.slag.content.blocks.melter.MelterInventory;
import dev.lopyluna.slag.content.blocks.melter.MeltingRecipe;
import dev.lopyluna.slag.content.blocks.melter.client.MelterMenu;
import dev.lopyluna.slag.content.blocks.multiblock.LerpedFloat;
import dev.lopyluna.slag.content.blocks.smart.BlockEntityBehaviour;
import dev.lopyluna.slag.content.blocks.smart.SmartBlockEntity;
import dev.lopyluna.slag.content.blocks.smart.SmartFluidTank;
import dev.lopyluna.slag.register.AllBETypes;
import dev.lopyluna.slag.register.AllRecipes;
import dev.lopyluna.slag.register.AllTags;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MelterBE
extends SmartBlockEntity
implements MenuProvider {
    public static final int BLOCK_SIZE = 648;
    public static final int SMALL_BLOCK_SIZE = 288;
    public static final int CRYSTAL_SIZE = 162;
    public static final int INGOT_SIZE = 72;
    public static final int SHARD_SIZE = 18;
    public static final int NUGGET_SIZE = 8;
    private final RecipeManager.CachedCheck<SingleRecipeInput, MeltingRecipe> quickCheck = RecipeManager.createCheck((RecipeType)((RecipeType)AllRecipes.MELTING.get()));
    protected IItemHandler itemCapability;
    protected IFluidHandler fluidCapability;
    protected boolean forceFluidLevelUpdate = true;
    protected MelterInventory itemInventory = new MelterInventory(1, this);
    protected SmartFluidTank tankInventory = this.createInventory();
    protected boolean updateCapability = false;
    protected int luminosity;
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;
    private LerpedFloat fluidLevel;
    public int meltingTarget;
    public int meltingProgress;
    public boolean melting;

    public MelterBE(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.refreshCapability();
    }

    public int getLuminosity() {
        return this.luminosity;
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)AllBETypes.MELTER.get(), (be, context) -> {
            if (be.fluidCapability == null) {
                be.refreshCapability();
            }
            return be.fluidCapability;
        });
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)AllBETypes.MELTER.get(), (be, context) -> {
            if (be.itemCapability == null) {
                be.refreshCapability();
            }
            return be.itemCapability;
        });
    }

    @Override
    public void tick() {
        int outputCapacity;
        super.tick();
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
        if (this.updateCapability) {
            this.updateCapability = false;
            this.refreshCapability();
        }
        if (this.fluidLevel != null) {
            this.fluidLevel.tickChaser();
        }
        if (this.level == null) {
            return;
        }
        this.melting = this.tickRecipe(this.level);
        if (this.level.isClientSide) {
            return;
        }
        Direction facing = (Direction)this.getBlockState().getValue((Property)MelterBlock.FACING);
        IFluidHandler outputInv = this.getFluidHandlerDir(this.worldPosition.relative(facing.getOpposite()).below());
        if (outputInv == null) {
            return;
        }
        FluidStack outputFluid = outputInv.getFluidInTank(0);
        SmartFluidTank inputInv = this.getTankInventory();
        if (inputInv == null) {
            return;
        }
        FluidStack inputFluid = inputInv.getFluidInTank(0);
        if (inputFluid.isEmpty()) {
            return;
        }
        int outputAmount = outputFluid.getAmount();
        if (outputAmount >= (outputCapacity = outputInv.getTankCapacity(0))) {
            return;
        }
        int targetDrain = Mth.clamp((int)(outputFluid.isEmpty() ? 1 : 10), (int)0, (int)(outputCapacity - outputAmount));
        if (targetDrain == 0) {
            return;
        }
        FluidStack drained = inputInv.drain(targetDrain, IFluidHandler.FluidAction.SIMULATE);
        if (drained.getAmount() != outputInv.fill(drained, IFluidHandler.FluidAction.SIMULATE)) {
            return;
        }
        inputInv.drain(targetDrain, IFluidHandler.FluidAction.EXECUTE);
        outputInv.fill(drained, IFluidHandler.FluidAction.EXECUTE);
    }

    public boolean tickRecipe(Level level) {
        Recipe recipe;
        ItemStack stack = this.getStack();
        if (stack.isEmpty()) {
            this.meltingTarget = 0;
            this.meltingProgress = 0;
            return false;
        }
        BlockState belowState = this.getBelowState(level);
        if (!belowState.is(AllTags.MELTER_HEATER)) {
            this.notMelting();
            return false;
        }
        SingleRecipeInput input = new SingleRecipeInput(stack);
        RecipeHolder recipeholder = this.quickCheck.getRecipeFor((RecipeInput)input, level).orElse(null);
        SmartFluidTank tank = this.getTankInventory();
        if (tank != null && recipeholder != null && (recipe = recipeholder.value()) instanceof MeltingRecipe) {
            MeltingRecipe recipe2 = (MeltingRecipe)recipe;
            RegistryAccess access = level.registryAccess();
            FluidStack fluid = recipe2.getResultFluid((HolderLookup.Provider)access);
            int amount = fluid.getAmount();
            this.meltingTarget = Mth.clamp((int)((int)((float)amount * 0.5f)), (int)4, (int)256);
            if (this.meltingTarget > this.meltingProgress) {
                ++this.meltingProgress;
            } else {
                if (amount + tank.getFluidAmount() > tank.getCapacity()) {
                    return true;
                }
                this.meltingProgress = 0;
                stack.shrink(1);
                tank.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
            }
            return true;
        }
        this.notMelting();
        return false;
    }

    public void notMelting() {
        if (this.meltingProgress > 0) {
            --this.meltingProgress;
        }
    }

    public BlockState getBelowState(Level level) {
        return level.getBlockState(this.worldPosition.below());
    }

    private IFluidHandler getFluidHandlerDir(BlockPos pos) {
        assert (this.level != null);
        if (!this.level.isLoaded(pos)) {
            return null;
        }
        BlockEntity be = this.level.getBlockEntity(pos);
        if (be == null) {
            return null;
        }
        return (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, pos, (Object)Direction.DOWN);
    }

    protected SmartFluidTank createInventory() {
        return new SmartFluidTank(3000, this::onFluidStackChanged);
    }

    public void refreshCapability() {
        this.fluidCapability = this.handlerForCapability();
        this.itemCapability = this.handlerForCapabilityItem();
        this.invalidateCapabilities();
    }

    private IItemHandler handlerForCapabilityItem() {
        return this.itemInventory;
    }

    private IFluidHandler handlerForCapability() {
        return this.tankInventory;
    }

    protected void onFluidStackChanged(FluidStack newFluids) {
        if (this.level == null) {
            return;
        }
        this.level.updateNeighbourForOutputSignal(this.worldPosition, this.getBlockState().getBlock());
        if (!this.level.isClientSide) {
            this.setChanged();
            this.sendData();
        } else {
            if (this.fluidLevel == null) {
                this.fluidLevel = LerpedFloat.linear().startWithValue(this.getFillState());
            }
            this.fluidLevel.chase(this.getFillState(), 0.5, LerpedFloat.Chaser.EXP);
        }
    }

    protected void setLuminosity(int luminosity) {
        assert (this.level != null);
        if (this.level.isClientSide) {
            return;
        }
        if (this.luminosity == luminosity) {
            return;
        }
        this.luminosity = luminosity;
        this.sendData();
    }

    public float getFillState() {
        return (float)this.tankInventory.getFluidAmount() / (float)this.tankInventory.getCapacity();
    }

    @Override
    public void destroy() {
        super.destroy();
        MelterBE.dropContents(this.level, this.worldPosition, (IItemHandler)this.itemInventory);
    }

    public static void dropContents(Level level, BlockPos pos, IItemHandler inv) {
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)inv.getStackInSlot(slot));
        }
    }

    @Override
    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.meltingProgress = tag.getInt("MeltingProgress");
        this.melting = tag.getBoolean("Melting");
        this.itemInventory.load(tag, registries);
        assert (this.level != null);
        int prevLum = this.luminosity;
        this.luminosity = tag.getInt("Luminosity");
        this.tankInventory.setCapacity(3000);
        this.tankInventory.readFromNBT(registries, tag.getCompound("TankContent"));
        if (this.tankInventory.getSpace() < 0) {
            this.tankInventory.drain(-this.tankInventory.getSpace(), IFluidHandler.FluidAction.EXECUTE);
        }
        if (tag.contains("ForceFluidLevel") || this.fluidLevel == null) {
            this.fluidLevel = LerpedFloat.linear().startWithValue(this.getFillState());
        }
        this.updateCapability = true;
        if (!clientPacket) {
            return;
        }
        float fillState = this.getFillState();
        if (tag.contains("ForceFluidLevel") || this.fluidLevel == null) {
            this.fluidLevel = LerpedFloat.linear().startWithValue(fillState);
        }
        this.fluidLevel.chase(fillState, 0.5, LerpedFloat.Chaser.EXP);
        if (this.luminosity != prevLum && this.hasLevel()) {
            this.level.getChunkSource().getLightEngine().checkBlock(this.worldPosition);
        }
        if (tag.contains("LazySync")) {
            this.fluidLevel.chase(this.fluidLevel.getChaseTarget(), 0.125, LerpedFloat.Chaser.EXP);
        }
    }

    @Override
    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        tag.put("TankContent", (Tag)this.tankInventory.writeToNBT(registries, new CompoundTag()));
        tag.putInt("Luminosity", this.luminosity);
        super.write(tag, registries, clientPacket);
        tag.putInt("MeltingProgress", this.meltingProgress);
        tag.putBoolean("Melting", this.melting);
        this.itemInventory.save(tag, registries);
        if (!clientPacket) {
            return;
        }
        if (this.forceFluidLevelUpdate) {
            tag.putBoolean("ForceFluidLevel", true);
        }
        if (this.queuedSync) {
            tag.putBoolean("LazySync", true);
        }
        this.forceFluidLevelUpdate = false;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.sendData();
    }

    @Override
    public void invalidate() {
        if (this.itemInventory != null || this.fluidCapability != null) {
            this.invalidateCapabilities();
        }
        super.invalidate();
    }

    public void setChanged() {
        super.setChanged();
        this.itemInventory.setChanged();
    }

    public void sendDataImmediately() {
        this.syncCooldown = 0;
        this.queuedSync = false;
        this.sendData();
    }

    @Override
    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public ItemStack getStack() {
        return this.getItemInventory().getFirstItem();
    }

    public MelterInventory getItemInventory() {
        return this.itemInventory;
    }

    public SmartFluidTank getTankInventory() {
        return this.tankInventory;
    }

    public LerpedFloat getFluidLevel() {
        return this.fluidLevel;
    }

    public void setFluidLevel(LerpedFloat fluidLevel) {
        this.fluidLevel = fluidLevel;
    }

    @NotNull
    public Component getDisplayName() {
        return this.getBlockState().getBlock().getName();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, @NotNull Inventory inventory, @NotNull Player player) {
        if (this.itemInventory == null) {
            this.itemInventory = new MelterInventory(1, this);
        }
        return new MelterMenu(i, inventory, this.itemInventory, this.worldPosition);
    }

    public void writeClientSideData(@NotNull AbstractContainerMenu menu, RegistryFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.worldPosition);
    }
}

