/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.melter;

import dev.lopyluna.slag.content.blocks.crucible.AlloyingRecipe;
import dev.lopyluna.slag.register.AllRecipes;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class MeltingRecipe
implements Recipe<SingleRecipeInput> {
    protected final RecipeType<?> type;
    protected final String group;
    private final Ingredient input;
    private final FluidStack output;

    public MeltingRecipe(String group, Ingredient input, FluidStack output) {
        this((RecipeType)AllRecipes.MELTING.get(), group, input, output);
    }

    public MeltingRecipe(RecipeType<?> type, String group, Ingredient input, FluidStack output) {
        this.type = type;
        this.group = group;
        this.input = input;
        this.output = output;
    }

    public boolean matches(SingleRecipeInput input, Level level) {
        return this.input.test(input.item());
    }

    public FluidStack assembleWithFluid(AlloyingRecipe.AlloyRecipeInput alloyRecipeInput, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public FluidStack getResultFluid(HolderLookup.Provider provider) {
        return this.output.copy();
    }

    @NotNull
    public String getGroup() {
        return this.group;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public FluidStack getOutput() {
        return this.output;
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return false;
    }

    @NotNull
    public ItemStack assemble(SingleRecipeInput input, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)AllRecipes.MELTING_SER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return this.type;
    }

    public static interface Factory {
        public MeltingRecipe create(String var1, Ingredient var2, FluidStack var3);
    }

    public static class Type
    implements RecipeType<MeltingRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }

        public String toString() {
            return "melting";
        }
    }
}

