/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.melter;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lopyluna.slag.content.blocks.melter.MeltingRecipe;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class MeltingRecipeSer
implements RecipeSerializer<MeltingRecipe> {
    private final MeltingRecipe.Factory factory;
    private final MapCodec<MeltingRecipe> codec;
    private final StreamCodec<RegistryFriendlyByteBuf, MeltingRecipe> streamCodec;

    public MeltingRecipeSer(MeltingRecipe.Factory factory) {
        this.factory = factory;
        this.codec = RecordCodecBuilder.mapCodec(instance -> {
            Products.P3 recipe = instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(Recipe::getGroup), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(MeltingRecipe::getInput), (App)FluidStack.CODEC.fieldOf("result").forGetter(MeltingRecipe::getOutput));
            Objects.requireNonNull(factory);
            return recipe.apply((Applicative)instance, factory::create);
        });
        this.streamCodec = StreamCodec.of(this::toNetwork, this::fromNetwork);
    }

    @NotNull
    public MapCodec<MeltingRecipe> codec() {
        return this.codec;
    }

    @NotNull
    public StreamCodec<RegistryFriendlyByteBuf, MeltingRecipe> streamCodec() {
        return this.streamCodec;
    }

    public String toString() {
        return "melting";
    }

    private MeltingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
        String s = buffer.readUtf();
        Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
        FluidStack fluidStack = (FluidStack)FluidStack.STREAM_CODEC.decode((Object)buffer);
        return this.factory.create(s, input, fluidStack);
    }

    private void toNetwork(RegistryFriendlyByteBuf buffer, MeltingRecipe recipe) {
        buffer.writeUtf(recipe.getGroup());
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.getInput());
        FluidStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.getOutput());
    }

    public MeltingRecipe create(String group, Ingredient input, FluidStack result) {
        return this.factory.create(group, input, result);
    }
}

