/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.melter.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import dev.lopyluna.slag.SlagEmbers;
import dev.lopyluna.slag.client.ClientUtils;
import dev.lopyluna.slag.client.FluidRenderHelper;
import dev.lopyluna.slag.content.blocks.crucible_interface.client.InterfaceScreen;
import dev.lopyluna.slag.content.blocks.melter.client.MelterMenu;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class MelterScreen
extends AbstractContainerScreen<MelterMenu> {
    static Minecraft mc = Minecraft.getInstance();
    private static final ResourceLocation TEXTURE = SlagEmbers.loc("textures/gui/melter.png");
    private static final ResourceLocation TEXTURE_OVERLAY = SlagEmbers.loc("textures/gui/melter_overlay.png");
    private static final int BOX_X = 112;
    private static final int BOX_Y = 19;
    private static final int BOX_W = 24;
    private static final int BOX_H = 48;
    private final Level level;

    public MelterScreen(MelterMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.level = Minecraft.getInstance().level;
    }

    protected void renderBg(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        PoseStack p = graphics.pose();
        p.pushPose();
        RenderSystem.enableBlend();
        graphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        this.renderFluidLayers(graphics, mouseX, mouseY);
        RenderSystem.disableBlend();
        p.popPose();
        Pair<Float, Boolean> melting = ((MelterMenu)this.menu).isMelting();
        if (((Boolean)melting.getSecond()).booleanValue()) {
            graphics.blit(TEXTURE, this.leftPos + 57, this.topPos + 36, 176, 0, 14, 14);
        }
        if (((Float)melting.getFirst()).floatValue() == -1.0f) {
            return;
        }
        int cook = Mth.ceil((float)(((Float)melting.getFirst()).floatValue() * 24.0f));
        graphics.blit(TEXTURE, this.leftPos + 79, this.topPos + 34, 176, 14, cook, 16);
    }

    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTick) {
        super.render(gui, mouseX, mouseY, partialTick);
        PoseStack p = gui.pose();
        BlockState state = ((MelterMenu)this.menu).getBelowState();
        if (!state.isAir()) {
            Pair<ItemStack, Boolean> data = ((MelterMenu)this.menu).getBelowData();
            ItemStack stack = (ItemStack)data.getFirst();
            if (stack.isEmpty()) {
                return;
            }
            stack.set(DataComponents.HIDE_TOOLTIP, (Object)Unit.INSTANCE);
            stack.set(DataComponents.HIDE_ADDITIONAL_TOOLTIP, (Object)Unit.INSTANCE);
            Boolean heatable = (Boolean)data.getSecond();
            int l = this.leftPos + 56;
            int t = this.topPos + 54;
            if (heatable.booleanValue()) {
                gui.blit(TEXTURE, this.leftPos + 54, this.topPos + 52, 176, 31, 20, 20);
            }
            ClientUtils.renderFakeSlot(gui, stack, l, t, heatable != false ? "\u2714" : "\u2193", this.imageWidth, this.font);
            if (mouseX >= l && mouseX < l + 18 && mouseY >= t && mouseY < t + 18) {
                TooltipFlag.Default tooltipFlag = MelterScreen.mc.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL;
                ArrayList<Object> tooltip = new ArrayList<Object>();
                tooltip.add(stack.getHoverName());
                if (tooltipFlag.advanced()) {
                    tooltip.add(Component.literal((String)BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).toString()).withStyle(ChatFormatting.DARK_GRAY));
                }
                gui.renderTooltip(this.font, tooltip, stack.getTooltipImage(), mouseX, mouseY);
            }
        }
        p.pushPose();
        RenderSystem.enableBlend();
        this.renderTooltip(gui, mouseX, mouseY);
        RenderSystem.disableBlend();
        p.popPose();
    }

    protected void init() {
        super.init();
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
    }

    public void renderFluidLayers(GuiGraphics g, int mx, int my) {
        if (this.level == null) {
            return;
        }
        FluidStack fluid = ((MelterMenu)this.menu).getFluid();
        if (fluid.isEmpty()) {
            return;
        }
        int capacity = ((MelterMenu)this.menu).getCapacity();
        if (capacity <= 0) {
            return;
        }
        int amount = fluid.getAmount();
        if (amount <= 0) {
            return;
        }
        float fillState = Mth.clamp((float)((float)amount / (float)capacity), (float)0.0f, (float)1.0f);
        int boxX = this.leftPos + 112;
        int boxY = this.topPos + 19;
        int boxW = 24;
        int h = (int)(49.0f * fillState);
        int y = boxY + (int)(49.0f * (1.0f - fillState));
        FluidRenderHelper.drawFluidBox(g, boxX, y, boxW, h, fluid);
        PoseStack p = g.pose();
        p.pushPose();
        RenderSystem.enableBlend();
        g.blit(TEXTURE_OVERLAY, (this.width - this.imageWidth) / 2, (this.height - this.imageHeight) / 2, 0, 0, this.imageWidth, this.imageHeight);
        RenderSystem.disableBlend();
        p.popPose();
        if (mx >= boxX && mx < boxX + boxW && my >= y && my < y + h) {
            TooltipFlag.Default tooltipFlag = MelterScreen.mc.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL;
            ArrayList<Component> tooltip = new ArrayList<Component>();
            tooltip.add(fluid.getDisplayName());
            InterfaceScreen.createLang(fluid, tooltip).run();
            if (tooltipFlag.advanced()) {
                tooltip.add((Component)Component.literal((String)BuiltInRegistries.FLUID.getKey((Object)fluid.getFluid()).toString()).withStyle(ChatFormatting.DARK_GRAY));
            }
            g.renderTooltip(this.font, tooltip, Optional.empty(), mx, my);
        }
    }
}

