/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.multiblock;

import dev.lopyluna.slag.content.blocks.crucible.CrucibleBE;
import dev.lopyluna.slag.content.blocks.crucible.CrucibleTank;
import dev.lopyluna.slag.content.blocks.multiblock.IMultiBlockEntityContainer;
import dev.lopyluna.slag.content.blocks.multiblock.LerpedFloat;
import dev.lopyluna.slag.content.blocks.multiblock.connectivity.ConnectivityHandler;
import dev.lopyluna.slag.content.blocks.smart.BlockEntityBehaviour;
import dev.lopyluna.slag.content.blocks.smart.SmartBlockEntity;
import dev.lopyluna.slag.content.utils.NBTHelper;
import dev.lopyluna.slag.register.AllBETypes;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class FluidMultiBlockEntity
extends SmartBlockEntity
implements IMultiBlockEntityContainer.FluidMulti {
    protected IFluidHandler fluidCapability;
    protected boolean forceFluidLevelUpdate = true;
    protected CrucibleTank tankInventory = this.createInventory();
    protected BlockPos controller;
    protected BlockPos lastKnownPos;
    protected boolean updateConnectivity = false;
    protected boolean updateCapability = false;
    protected boolean window = false;
    protected int luminosity;
    protected int widthX = 1;
    protected int widthZ = 1;
    protected int height = 1;
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;
    private LerpedFloat fluidLevel;

    public FluidMultiBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.refreshCapability();
    }

    public boolean isWindow() {
        return this.window;
    }

    public int getLuminosity() {
        return this.luminosity;
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)AllBETypes.CRUCIBLE.get(), (be, context) -> {
            if (be.fluidCapability == null) {
                be.refreshCapability();
            }
            return be.fluidCapability;
        });
    }

    protected CrucibleTank createInventory() {
        return new CrucibleTank(FluidMultiBlockEntity.getCapacityMultiplier(), this::onFluidStackChanged);
    }

    public void updateConnectivity() {
        assert (this.level != null);
        this.updateConnectivity = false;
        if (this.level.isClientSide) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ConnectivityHandler.formMulti(this);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.getBlockPos();
        } else if (!this.lastKnownPos.equals((Object)this.worldPosition)) {
            this.onPositionChanged();
            return;
        }
        if (this.updateCapability) {
            this.updateCapability = false;
            this.refreshCapability();
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
        if (this.fluidLevel != null) {
            this.fluidLevel.tickChaser();
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
    }

    @Override
    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    @Override
    public boolean isController() {
        return this.controller == null || this.worldPosition.getX() == this.controller.getX() && this.worldPosition.getY() == this.controller.getY() && this.worldPosition.getZ() == this.controller.getZ();
    }

    @Override
    public void initialize() {
        super.initialize();
        assert (this.level != null);
        this.sendData();
        if (this.level.isClientSide) {
            this.invalidateRenderBoundingBox();
        }
    }

    protected void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.worldPosition;
    }

    protected void onFluidStackChanged(List<FluidStack> newFluids) {
        if (this.level == null) {
            return;
        }
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.widthX; ++x) {
                for (int z = 0; z < this.widthZ; ++z) {
                    BlockPos pos = this.worldPosition.offset(x, y, z);
                    FluidMultiBlockEntity part = (FluidMultiBlockEntity)ConnectivityHandler.partAt(this.getType(), (BlockGetter)this.level, pos);
                    if (part == null) continue;
                    this.level.updateNeighbourForOutputSignal(pos, part.getBlockState().getBlock());
                }
            }
        }
        if (!this.level.isClientSide) {
            this.setChanged();
            this.sendData();
        } else {
            if (this.fluidLevel == null) {
                this.fluidLevel = LerpedFloat.linear().startWithValue(this.getFillState());
            }
            this.fluidLevel.chase(this.getFillState(), 0.5, LerpedFloat.Chaser.EXP);
        }
    }

    protected void setLuminosity(int luminosity) {
        assert (this.level != null);
        if (this.level.isClientSide) {
            return;
        }
        if (this.luminosity == luminosity) {
            return;
        }
        this.luminosity = luminosity;
        this.sendData();
    }

    public FluidMultiBlockEntity getControllerBE() {
        assert (this.level != null);
        if (this.isController() || !this.hasLevel()) {
            return this;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this.getController());
        if (blockEntity instanceof FluidMultiBlockEntity) {
            FluidMultiBlockEntity be = (FluidMultiBlockEntity)blockEntity;
            return be;
        }
        return null;
    }

    public void applyFluidTankSize(int blocks) {
        int newCap = blocks * FluidMultiBlockEntity.getCapacityMultiplier();
        this.tankInventory.setCapacity(newCap);
        int overflow = this.tankInventory.getTotalFluidAmount() - newCap;
        if (overflow > 0) {
            this.tankInventory.drain(overflow, IFluidHandler.FluidAction.EXECUTE);
        }
        this.forceFluidLevelUpdate = true;
    }

    @Override
    public void removeController(boolean keepFluids) {
        assert (this.level != null);
        if (this.level.isClientSide) {
            return;
        }
        this.updateConnectivity = true;
        if (!keepFluids) {
            this.applyFluidTankSize(1);
        }
        this.controller = null;
        this.widthX = 1;
        this.widthZ = 1;
        this.height = 1;
        this.onFluidStackChanged(this.tankInventory.getFluids());
        BlockState state = this.getBlockState();
        if (state.hasProperty((Property)CrucibleBE.BOTTOM) && state.hasProperty((Property)CrucibleBE.TOP)) {
            state = (BlockState)state.setValue((Property)CrucibleBE.BOTTOM, (Comparable)Boolean.valueOf(true));
            state = (BlockState)state.setValue((Property)CrucibleBE.TOP, (Comparable)Boolean.valueOf(true));
            this.level.setBlock(this.worldPosition, state, 22);
        }
        this.refreshCapability();
        this.setChanged();
        this.sendData();
    }

    public void toggleWindows() {
        FluidMultiBlockEntity be = this.getControllerBE();
        if (be == null) {
            return;
        }
        be.setWindows(!be.window);
    }

    public void sendDataImmediately() {
        this.syncCooldown = 0;
        this.queuedSync = false;
        this.sendData();
    }

    @Override
    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    public void setWindows(boolean window) {
        this.window = window;
    }

    @Override
    public void setController(BlockPos controller) {
        assert (this.level != null);
        if (this.level.isClientSide) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.refreshCapability();
        this.setChanged();
        this.sendData();
    }

    public void refreshCapability() {
        this.fluidCapability = this.handlerForCapability();
        this.invalidateCapabilities();
    }

    private IFluidHandler handlerForCapability() {
        return this.isController() ? this.tankInventory : (this.getControllerBE() != null ? this.getControllerBE().handlerForCapability() : new FluidTank(0));
    }

    @Override
    public BlockPos getController() {
        return this.isController() ? this.worldPosition : this.controller;
    }

    @Override
    protected AABB createRenderBoundingBox() {
        if (this.isController()) {
            return super.createRenderBoundingBox().expandTowards((double)(this.widthX - 1), (double)(this.height - 1), (double)(this.widthZ - 1));
        }
        return super.createRenderBoundingBox();
    }

    @Nullable
    public FluidMultiBlockEntity getOtherFluidMultiBlockEntity(Direction direction) {
        assert (this.level != null);
        BlockEntity otherBE = this.level.getBlockEntity(this.worldPosition.relative(direction));
        if (otherBE instanceof FluidMultiBlockEntity) {
            FluidMultiBlockEntity be = (FluidMultiBlockEntity)otherBE;
            return be;
        }
        return null;
    }

    @Override
    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        boolean changeOfController;
        super.read(compound, registries, clientPacket);
        assert (this.level != null);
        BlockPos controllerBefore = this.controller;
        int prevWX = this.widthX;
        int prevWZ = this.widthZ;
        int prevHeight = this.height;
        int prevLum = this.luminosity;
        this.updateConnectivity = compound.contains("Uninitialized");
        this.luminosity = compound.getInt("Luminosity");
        this.lastKnownPos = null;
        if (compound.contains("LastKnownPos")) {
            this.lastKnownPos = NBTHelper.readBlockPos(compound, "LastKnownPos");
        }
        this.controller = null;
        if (compound.contains("Controller")) {
            this.controller = NBTHelper.readBlockPos(compound, "Controller");
        }
        if (this.isController()) {
            this.window = compound.getBoolean("Window");
            this.widthX = compound.getInt("WidthX");
            this.widthZ = compound.getInt("WidthZ");
            this.height = compound.getInt("Height");
            this.tankInventory.setCapacity(this.getTotalSize() * FluidMultiBlockEntity.getCapacityMultiplier());
            this.tankInventory.readFromNBT(registries, compound.getCompound("TankContent"));
            if (this.tankInventory.getSpace() < 0) {
                this.tankInventory.drain(-this.tankInventory.getSpace(), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        if (compound.contains("ForceFluidLevel") || this.fluidLevel == null) {
            this.fluidLevel = LerpedFloat.linear().startWithValue(this.getFillState());
        }
        this.updateCapability = true;
        if (!clientPacket) {
            return;
        }
        boolean bl = changeOfController = !Objects.equals(controllerBefore, this.controller);
        if (changeOfController || prevWX != this.widthX || prevWZ != this.widthZ || prevHeight != this.height) {
            if (this.hasLevel()) {
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 16);
            }
            if (this.isController()) {
                this.tankInventory.setCapacity(FluidMultiBlockEntity.getCapacityMultiplier() * this.getTotalSize());
            }
            this.invalidateRenderBoundingBox();
        }
        if (this.isController()) {
            float fillState = this.getFillState();
            if (compound.contains("ForceFluidLevel") || this.fluidLevel == null) {
                this.fluidLevel = LerpedFloat.linear().startWithValue(fillState);
            }
            this.fluidLevel.chase(fillState, 0.5, LerpedFloat.Chaser.EXP);
        }
        if (this.luminosity != prevLum && this.hasLevel()) {
            this.level.getChunkSource().getLightEngine().checkBlock(this.worldPosition);
        }
        if (compound.contains("LazySync")) {
            this.fluidLevel.chase(this.fluidLevel.getChaseTarget(), 0.125, LerpedFloat.Chaser.EXP);
        }
    }

    public float getFillState() {
        return (float)this.tankInventory.getTotalFluidAmount() / (float)this.tankInventory.getCapacity();
    }

    @Override
    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        if (this.updateConnectivity) {
            compound.putBoolean("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            compound.put("LastKnownPos", NbtUtils.writeBlockPos((BlockPos)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.put("Controller", NbtUtils.writeBlockPos((BlockPos)this.controller));
        }
        if (this.isController()) {
            compound.putBoolean("Window", this.window);
            compound.put("TankContent", (Tag)this.tankInventory.writeToNBT(registries, new CompoundTag()));
            compound.putInt("WidthX", this.widthX);
            compound.putInt("WidthZ", this.widthZ);
            compound.putInt("Height", this.height);
        }
        compound.putInt("Luminosity", this.luminosity);
        super.write(compound, registries, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (this.forceFluidLevelUpdate) {
            compound.putBoolean("ForceFluidLevel", true);
        }
        if (this.queuedSync) {
            compound.putBoolean("LazySync", true);
        }
        this.forceFluidLevelUpdate = false;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public CrucibleTank getTankInventory() {
        return this.tankInventory;
    }

    public int getTotalSize() {
        return this.widthX * this.widthZ * this.height;
    }

    @Override
    public int getTotalTankSize() {
        return this.getTotalSize() * FluidMultiBlockEntity.getCapacityMultiplier();
    }

    public static int getCapacityMultiplier() {
        return 1000;
    }

    public LerpedFloat getFluidLevel() {
        return this.fluidLevel;
    }

    public void setFluidLevel(LerpedFloat fluidLevel) {
        this.fluidLevel = fluidLevel;
    }

    @Override
    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    @Override
    public void notifyMultiUpdated() {
        assert (this.level != null);
        BlockState state = this.getBlockState();
        if (state.hasProperty((Property)CrucibleBE.BOTTOM) && state.hasProperty((Property)CrucibleBE.TOP)) {
            state = (BlockState)state.setValue((Property)CrucibleBE.BOTTOM, (Comparable)Boolean.valueOf(this.getController().getY() == this.getBlockPos().getY()));
            state = (BlockState)state.setValue((Property)CrucibleBE.TOP, (Comparable)Boolean.valueOf(this.getController().getY() + this.height - 1 == this.getBlockPos().getY()));
            this.level.setBlock(this.getBlockPos(), state, 6);
        }
        if (this.isController()) {
            this.setWindows(this.window);
        }
        this.onFluidStackChanged(this.tankInventory.getFluids());
        this.setChanged();
    }

    @Override
    public void setExtraData(@Nullable Object data) {
        if (data instanceof Boolean) {
            this.window = (Boolean)data;
        }
    }

    @Override
    @Nullable
    public Object getExtraData() {
        return this.window;
    }

    @Override
    public Object modifyExtraData(Object data) {
        if (data instanceof Boolean) {
            Boolean windows = (Boolean)data;
            windows = windows | this.window;
            return windows;
        }
        return data;
    }

    @Override
    public Direction.Axis getMainConnectionAxis() {
        return Direction.Axis.Y;
    }

    @Override
    public int getMaxLength(Direction.Axis longAxis, int width) {
        if (longAxis == Direction.Axis.Y) {
            return 9;
        }
        return this.getMaxWidth();
    }

    @Override
    public int getMaxWidth() {
        return 7;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int getWidthX() {
        return this.widthX;
    }

    @Override
    public int getWidthZ() {
        return this.widthZ;
    }

    @Override
    public void setWidthX(int width) {
        this.widthX = width;
    }

    @Override
    public void setWidthZ(int width) {
        this.widthZ = width;
    }

    @Override
    public boolean hasTank() {
        return true;
    }

    @Override
    public int getTankSize() {
        return FluidMultiBlockEntity.getCapacityMultiplier();
    }

    @Override
    public void setTankSize(int blocks) {
        this.applyFluidTankSize(blocks);
    }

    @Override
    public IFluidTank getTank() {
        return this.tankInventory;
    }

    @Override
    public List<FluidStack> getFluids() {
        return this.tankInventory.getFluidCopy();
    }
}

