/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.table;

import com.mojang.serialization.MapCodec;
import dev.lopyluna.slag.content.blocks.smart.SmartBlock;
import dev.lopyluna.slag.content.blocks.table.TableBE;
import dev.lopyluna.slag.content.items.dynamic_mold.DynamicMoldItem;
import dev.lopyluna.slag.content.utils.ShapeUtils;
import dev.lopyluna.slag.register.AllBETypes;
import dev.lopyluna.slag.register.AllDataComponents;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class TableBlock
extends SmartBlock<TableBE> {
    public static final MapCodec<TableBlock> CODEC = TableBlock.simpleCodec(TableBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    public TableBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Override
    public Class<TableBE> getBlockEntityClass() {
        return TableBE.class;
    }

    @Override
    public BlockEntityType<? extends TableBE> getBlockEntityType() {
        return (BlockEntityType)AllBETypes.TABLE.get();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        TableBE be;
        block8: {
            block7: {
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (!(blockEntity instanceof TableBE)) break block7;
                be = (TableBE)blockEntity;
                if (be.coolingProgress <= 0) break block8;
            }
            return InteractionResult.PASS;
        }
        boolean shift = player.isShiftKeyDown();
        boolean empty = player.getMainHandItem().isEmpty();
        if (shift && empty && be.tankInventory != null && !be.tankInventory.isEmpty()) {
            be.tankInventory.drain(be.tankInventory.getFluidAmount(), IFluidHandler.FluidAction.EXECUTE);
            return InteractionResult.SUCCESS;
        }
        if (be.itemInventory == null || player.isShiftKeyDown() && !empty) {
            return InteractionResult.PASS;
        }
        ItemStack stack = be.getStack();
        if (stack.isEmpty()) {
            ItemStack mold = be.getMold();
            if (mold.isEmpty()) {
                return InteractionResult.PASS;
            }
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)mold);
            be.itemInventory.getFirstMoldItem().setCount(0);
            return InteractionResult.SUCCESS;
        }
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
        be.itemInventory.getFirstItem().setCount(0);
        return InteractionResult.SUCCESS;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        TableBE be;
        ItemInteractionResult pass;
        block6: {
            block5: {
                pass = ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (!(blockEntity instanceof TableBE)) break block5;
                be = (TableBE)blockEntity;
                if (!player.isShiftKeyDown() && stack.getItem() instanceof DynamicMoldItem) break block6;
            }
            return pass;
        }
        if (be.itemInventory == null || !stack.has(AllDataComponents.CAST_TYPE)) {
            return pass;
        }
        if (!be.getMold().isEmpty()) {
            return pass;
        }
        be.itemInventory.insertItem(1, stack.copyWithCount(1), false);
        stack.shrink(1);
        return ItemInteractionResult.SUCCESS;
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return ShapeUtils.shape(0.0, 0.0, 0.0, 5.0, 4.0, 5.0).add(0.0, 0.0, 11.0, 5.0, 4.0, 16.0).add(11.0, 0.0, 11.0, 16.0, 4.0, 16.0).add(11.0, 0.0, 0.0, 16.0, 4.0, 5.0).add(0.0, 4.0, 0.0, 16.0, 9.0, 16.0).add(0.0, 9.0, 0.0, 2.0, 12.0, 16.0).add(14.0, 9.0, 0.0, 16.0, 12.0, 16.0).add(0.0, 9.0, 14.0, 16.0, 12.0, 16.0).add(0.0, 9.0, 0.0, 16.0, 12.0, 2.0).build();
    }
}

