/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.table;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lopyluna.slag.content.AllUtils;
import dev.lopyluna.slag.content.blocks.table.TableCastingRecipe;
import java.util.Objects;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class TableCastingRecipeSer
implements RecipeSerializer<TableCastingRecipe> {
    private final TableCastingRecipe.Factory factory;
    private final MapCodec<TableCastingRecipe> codec;
    private final StreamCodec<RegistryFriendlyByteBuf, TableCastingRecipe> streamCodec;

    public TableCastingRecipeSer(TableCastingRecipe.Factory factory) {
        this.factory = factory;
        this.codec = RecordCodecBuilder.mapCodec(instance -> {
            Products.P4 recipe = instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(Recipe::getGroup), (App)TagKey.codec((ResourceKey)Registries.ITEM).fieldOf("cast").forGetter(TableCastingRecipe::getCastType), (App)FluidStack.CODEC.fieldOf("ingredient").forGetter(TableCastingRecipe::getInput), (App)ItemStack.CODEC.fieldOf("result").forGetter(TableCastingRecipe::getOutput));
            Objects.requireNonNull(factory);
            return recipe.apply((Applicative)instance, factory::create);
        });
        this.streamCodec = StreamCodec.of(this::toNetwork, this::fromNetwork);
    }

    @NotNull
    public MapCodec<TableCastingRecipe> codec() {
        return this.codec;
    }

    @NotNull
    public StreamCodec<RegistryFriendlyByteBuf, TableCastingRecipe> streamCodec() {
        return this.streamCodec;
    }

    public String toString() {
        return "table_casting";
    }

    private TableCastingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
        String s = buffer.readUtf();
        FluidStack input = (FluidStack)FluidStack.STREAM_CODEC.decode((Object)buffer);
        TagKey type = (TagKey)AllUtils.tagKeyStreamCodec(Registries.ITEM).decode((Object)buffer);
        ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
        return this.factory.create(s, (TagKey<Item>)type, input, output);
    }

    private void toNetwork(RegistryFriendlyByteBuf buffer, TableCastingRecipe recipe) {
        buffer.writeUtf(recipe.getGroup());
        FluidStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.getInput());
        AllUtils.tagKeyStreamCodec(Registries.ITEM).encode((Object)buffer, recipe.getCastType());
        ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.getOutput());
    }

    public TableCastingRecipe create(String group, TagKey<Item> type, FluidStack input, ItemStack result) {
        return this.factory.create(group, type, input, result);
    }
}

