/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.datagen;

import dev.lopyluna.slag.content.blocks.crucible.AlloyingRecipe;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class AlloyingRecipeBuilder
implements RecipeBuilder {
    private final Fluid result;
    private final FluidStack stackResult;
    private final List<FluidStack> inputs;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();
    @Nullable
    private String group;
    private final AlloyingRecipe.Factory factory;

    private AlloyingRecipeBuilder(Fluid result, int count, List<FluidStack> inputs) {
        this(new FluidStack(result, count), inputs);
    }

    private AlloyingRecipeBuilder(FluidStack result, List<FluidStack> inputs) {
        this.result = result.getFluid();
        this.stackResult = result;
        this.inputs = inputs;
        this.factory = AlloyingRecipe::new;
    }

    @NotNull
    public RecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    @NotNull
    public RecipeBuilder group(@Nullable String name) {
        this.group = name;
        return this;
    }

    public void save(RecipeOutput recipeOutput, ResourceLocation loc) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(loc));
        }
        Advancement.Builder builder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)loc)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)loc)).requirements(AdvancementRequirements.Strategy.OR);
        Objects.requireNonNull(builder);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
        AlloyingRecipe recipe = this.factory.create(Objects.requireNonNullElse(this.group, ""), this.inputs, this.stackResult);
        recipeOutput.accept(loc, (Recipe)recipe, builder.build(loc.withPrefix("recipes/misc/")));
    }

    @NotNull
    public Item getResult() {
        return Items.AIR;
    }

    public Fluid getResultFluid() {
        return this.result;
    }

    public void save(RecipeOutput recipeOutput) {
        this.save(recipeOutput, AlloyingRecipeBuilder.getDefaultRecipeId(this.getResultFluid()));
    }

    public void save(RecipeOutput recipeOutput, String id) {
        ResourceLocation loc = AlloyingRecipeBuilder.getDefaultRecipeId(this.getResultFluid());
        ResourceLocation parse = ResourceLocation.parse((String)id);
        if (parse.equals((Object)loc)) {
            throw new IllegalStateException("Recipe " + id + " should remove its 'save' argument as it is equal to default one");
        }
        this.save(recipeOutput, parse);
    }

    static ResourceLocation getDefaultRecipeId(Fluid fluid) {
        return BuiltInRegistries.FLUID.getKey((Object)fluid);
    }

    public static AlloyingRecipeBuilder create(Fluid result, int mb, List<FluidStack> fluids) {
        return new AlloyingRecipeBuilder(result, mb, fluids);
    }

    public static AlloyingRecipeBuilder create(FluidStack result, List<FluidStack> fluids) {
        return new AlloyingRecipeBuilder(result, fluids);
    }

    public static AlloyingRecipeBuilder create(Fluid result, int mb, FluidStack ... fluids) {
        return new AlloyingRecipeBuilder(result, mb, AlloyingRecipeBuilder.fluids(fluids));
    }

    public static AlloyingRecipeBuilder create(FluidStack result, FluidStack ... fluids) {
        return new AlloyingRecipeBuilder(result, AlloyingRecipeBuilder.fluids(fluids));
    }

    public static FluidStack fluid(Fluid fluid, int mb) {
        return new FluidStack(fluid, mb);
    }

    public static List<FluidStack> fluids(FluidStack ... fluids) {
        return new ArrayList<FluidStack>(List.of(fluids));
    }
}

