/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.datagen;

import dev.lopyluna.slag.content.blocks.basin.BasinCastingRecipe;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class BasinCastingRecipeBuilder
implements RecipeBuilder {
    private final Item result;
    private final ItemStack stackResult;
    private final FluidStack input;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();
    @Nullable
    private String group;
    private final BasinCastingRecipe.Factory factory;

    private BasinCastingRecipeBuilder(ItemStack result, FluidStack input) {
        this.result = result.getItem();
        this.stackResult = result;
        this.input = input;
        this.factory = BasinCastingRecipe::new;
    }

    @NotNull
    public RecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    @NotNull
    public RecipeBuilder group(@Nullable String name) {
        this.group = name;
        return this;
    }

    public void save(RecipeOutput recipeOutput, ResourceLocation loc) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(loc));
        }
        Advancement.Builder builder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)loc)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)loc)).requirements(AdvancementRequirements.Strategy.OR);
        Objects.requireNonNull(builder);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
        BasinCastingRecipe recipe = this.factory.create(Objects.requireNonNullElse(this.group, ""), this.input, this.stackResult);
        recipeOutput.accept(loc, (Recipe)recipe, builder.build(loc.withPrefix("recipes/misc/")));
    }

    @NotNull
    public Item getResult() {
        return this.result;
    }

    public void save(RecipeOutput recipeOutput) {
        this.save(recipeOutput, BasinCastingRecipeBuilder.getDefaultRecipeId(this.getResult()));
    }

    public void save(RecipeOutput recipeOutput, String id) {
        ResourceLocation loc = BasinCastingRecipeBuilder.getDefaultRecipeId(this.getResult());
        ResourceLocation parse = ResourceLocation.parse((String)id);
        if (parse.equals((Object)loc)) {
            throw new IllegalStateException("Recipe " + id + " should remove its 'save' argument as it is equal to default one");
        }
        this.save(recipeOutput, parse);
    }

    static ResourceLocation getDefaultRecipeId(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }

    public static BasinCastingRecipeBuilder create(Item result, int count, Fluid fluid, int mb) {
        return new BasinCastingRecipeBuilder(BasinCastingRecipeBuilder.item(result, count), BasinCastingRecipeBuilder.fluid(fluid, mb));
    }

    public static BasinCastingRecipeBuilder create(Item result, int count, FluidStack fluid) {
        return new BasinCastingRecipeBuilder(BasinCastingRecipeBuilder.item(result, count), fluid);
    }

    public static BasinCastingRecipeBuilder create(ItemStack result, Fluid fluid, int mb) {
        return new BasinCastingRecipeBuilder(result, BasinCastingRecipeBuilder.fluid(fluid, mb));
    }

    public static BasinCastingRecipeBuilder create(ItemStack result, FluidStack fluid) {
        return new BasinCastingRecipeBuilder(result, fluid);
    }

    public static FluidStack fluid(Fluid fluid, int mb) {
        return new FluidStack(fluid, mb);
    }

    public static ItemStack item(Item item, int count) {
        return new ItemStack((ItemLike)item, count);
    }
}

