/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.datagen;

import dev.lopyluna.slag.content.blocks.forge.DoubleSmeltingRecipe;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DualCookingRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory category;
    private final Item result;
    private final ItemStack stackResult;
    private final Ingredient ingA;
    private final Ingredient ingB;
    private final float exp;
    private final int time;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();
    @Nullable
    private String group;
    private final DoubleSmeltingRecipe.Factory factory;

    private DualCookingRecipeBuilder(RecipeCategory category, ItemLike result, int count, Ingredient ingA, Ingredient ingB, float exp, int time) {
        this(category, new ItemStack(result, count), ingA, ingB, exp, time);
    }

    private DualCookingRecipeBuilder(RecipeCategory category, ItemStack result, Ingredient ingA, Ingredient ingB, float exp, int time) {
        this.category = category;
        this.result = result.getItem();
        this.stackResult = result;
        this.ingA = ingA;
        this.ingB = ingB;
        this.exp = exp;
        this.time = time;
        this.factory = DoubleSmeltingRecipe::new;
    }

    @NotNull
    public RecipeBuilder unlockedBy(@NotNull String name, @NotNull Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    @NotNull
    public RecipeBuilder group(@Nullable String name) {
        this.group = name;
        return this;
    }

    @NotNull
    public Item getResult() {
        return this.result;
    }

    public void save(@NotNull RecipeOutput recipeOutput, @NotNull ResourceLocation loc) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(loc));
        }
        Advancement.Builder builder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)loc)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)loc)).requirements(AdvancementRequirements.Strategy.OR);
        Objects.requireNonNull(builder);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
        DoubleSmeltingRecipe recipe = this.factory.create(Objects.requireNonNullElse(this.group, ""), this.ingA, this.ingB, this.stackResult, this.exp, this.time);
        recipeOutput.accept(loc, (Recipe)recipe, builder.build(loc.withPrefix("recipes/" + this.category.getFolderName() + "/")));
    }

    public static DualCookingRecipeBuilder create(RecipeCategory category, ItemLike result, int count, TagKey<Item> ingA, TagKey<Item> ingB, float exp, int time) {
        return new DualCookingRecipeBuilder(category, result, count, Ingredient.of(ingA), Ingredient.of(ingB), exp, time);
    }

    public static DualCookingRecipeBuilder create(RecipeCategory category, ItemLike result, int count, ItemLike ingA, ItemLike ingB, float exp, int time) {
        return new DualCookingRecipeBuilder(category, result, count, Ingredient.of((ItemLike[])new ItemLike[]{ingA}), Ingredient.of((ItemLike[])new ItemLike[]{ingB}), exp, time);
    }

    public static DualCookingRecipeBuilder create(RecipeCategory category, ItemLike result, int count, ItemLike ingA, TagKey<Item> ingB, float exp, int time) {
        return new DualCookingRecipeBuilder(category, result, count, Ingredient.of((ItemLike[])new ItemLike[]{ingA}), Ingredient.of(ingB), exp, time);
    }

    public static DualCookingRecipeBuilder create(RecipeCategory category, ItemLike result, int count, TagKey<Item> ingA, ItemLike ingB, float exp, int time) {
        return new DualCookingRecipeBuilder(category, result, count, Ingredient.of(ingA), Ingredient.of((ItemLike[])new ItemLike[]{ingB}), exp, time);
    }

    public static DualCookingRecipeBuilder create(RecipeCategory category, ItemLike result, int count, ItemLike ingA, Ingredient ingB, float exp, int time) {
        return new DualCookingRecipeBuilder(category, result, count, Ingredient.of((ItemLike[])new ItemLike[]{ingA}), ingB, exp, time);
    }

    public static DualCookingRecipeBuilder create(RecipeCategory category, ItemLike result, int count, TagKey<Item> ingA, Ingredient ingB, float exp, int time) {
        return new DualCookingRecipeBuilder(category, result, count, Ingredient.of(ingA), ingB, exp, time);
    }

    public static DualCookingRecipeBuilder create(RecipeCategory category, ItemLike result, int count, Ingredient ingA, TagKey<Item> ingB, float exp, int time) {
        return new DualCookingRecipeBuilder(category, result, count, ingA, Ingredient.of(ingB), exp, time);
    }

    public static DualCookingRecipeBuilder create(RecipeCategory category, ItemLike result, int count, Ingredient ingA, ItemLike ingB, float exp, int time) {
        return new DualCookingRecipeBuilder(category, result, count, ingA, Ingredient.of((ItemLike[])new ItemLike[]{ingB}), exp, time);
    }

    public static DualCookingRecipeBuilder create(RecipeCategory category, ItemLike result, int count, Ingredient ingA, Ingredient ingB, float exp, int time) {
        return new DualCookingRecipeBuilder(category, result, count, ingA, ingB, exp, time);
    }

    public static DualCookingRecipeBuilder doubleSingle(RecipeCategory category, ItemLike result, Ingredient ing, float exp) {
        return new DualCookingRecipeBuilder(category, result, 2, ing, ing, exp * 2.0f, 200);
    }

    public static DualCookingRecipeBuilder create(RecipeCategory category, ItemLike result, TagKey<Item> ingA, TagKey<Item> ingB, float exp, int time) {
        return new DualCookingRecipeBuilder(category, result, 1, Ingredient.of(ingA), Ingredient.of(ingB), exp, time);
    }

    public static DualCookingRecipeBuilder create(RecipeCategory category, ItemLike result, ItemLike ingA, ItemLike ingB, float exp, int time) {
        return new DualCookingRecipeBuilder(category, result, 1, Ingredient.of((ItemLike[])new ItemLike[]{ingA}), Ingredient.of((ItemLike[])new ItemLike[]{ingB}), exp, time);
    }

    public static DualCookingRecipeBuilder create(RecipeCategory category, ItemLike result, ItemLike ingA, TagKey<Item> ingB, float exp, int time) {
        return new DualCookingRecipeBuilder(category, result, 1, Ingredient.of((ItemLike[])new ItemLike[]{ingA}), Ingredient.of(ingB), exp, time);
    }

    public static DualCookingRecipeBuilder create(RecipeCategory category, ItemLike result, TagKey<Item> ingA, ItemLike ingB, float exp, int time) {
        return new DualCookingRecipeBuilder(category, result, 1, Ingredient.of(ingA), Ingredient.of((ItemLike[])new ItemLike[]{ingB}), exp, time);
    }

    public static DualCookingRecipeBuilder create(RecipeCategory category, ItemLike result, ItemLike ingA, Ingredient ingB, float exp, int time) {
        return new DualCookingRecipeBuilder(category, result, 1, Ingredient.of((ItemLike[])new ItemLike[]{ingA}), ingB, exp, time);
    }

    public static DualCookingRecipeBuilder create(RecipeCategory category, ItemLike result, TagKey<Item> ingA, Ingredient ingB, float exp, int time) {
        return new DualCookingRecipeBuilder(category, result, 1, Ingredient.of(ingA), ingB, exp, time);
    }

    public static DualCookingRecipeBuilder create(RecipeCategory category, ItemLike result, Ingredient ingA, TagKey<Item> ingB, float exp, int time) {
        return new DualCookingRecipeBuilder(category, result, 1, ingA, Ingredient.of(ingB), exp, time);
    }

    public static DualCookingRecipeBuilder create(RecipeCategory category, ItemLike result, Ingredient ingA, ItemLike ingB, float exp, int time) {
        return new DualCookingRecipeBuilder(category, result, 1, ingA, Ingredient.of((ItemLike[])new ItemLike[]{ingB}), exp, time);
    }

    public static DualCookingRecipeBuilder create(RecipeCategory category, ItemLike result, Ingredient ingA, Ingredient ingB, float exp, int time) {
        return new DualCookingRecipeBuilder(category, result, 1, ingA, ingB, exp, time);
    }

    public static DualCookingRecipeBuilder create(RecipeCategory category, ItemLike result, int count, TagKey<Item> ingA, TagKey<Item> ingB, float exp) {
        return new DualCookingRecipeBuilder(category, result, count, Ingredient.of(ingA), Ingredient.of(ingB), exp, 200);
    }

    public static DualCookingRecipeBuilder create(RecipeCategory category, ItemLike result, int count, ItemLike ingA, ItemLike ingB, float exp) {
        return new DualCookingRecipeBuilder(category, result, count, Ingredient.of((ItemLike[])new ItemLike[]{ingA}), Ingredient.of((ItemLike[])new ItemLike[]{ingB}), exp, 200);
    }

    public static DualCookingRecipeBuilder create(RecipeCategory category, ItemLike result, int count, ItemLike ingA, TagKey<Item> ingB, float exp) {
        return new DualCookingRecipeBuilder(category, result, count, Ingredient.of((ItemLike[])new ItemLike[]{ingA}), Ingredient.of(ingB), exp, 200);
    }

    public static DualCookingRecipeBuilder create(RecipeCategory category, ItemLike result, int count, TagKey<Item> ingA, ItemLike ingB, float exp) {
        return new DualCookingRecipeBuilder(category, result, count, Ingredient.of(ingA), Ingredient.of((ItemLike[])new ItemLike[]{ingB}), exp, 200);
    }

    public static DualCookingRecipeBuilder create(RecipeCategory category, ItemLike result, int count, ItemLike ingA, Ingredient ingB, float exp) {
        return new DualCookingRecipeBuilder(category, result, count, Ingredient.of((ItemLike[])new ItemLike[]{ingA}), ingB, exp, 200);
    }

    public static DualCookingRecipeBuilder create(RecipeCategory category, ItemLike result, int count, TagKey<Item> ingA, Ingredient ingB, float exp) {
        return new DualCookingRecipeBuilder(category, result, count, Ingredient.of(ingA), ingB, exp, 200);
    }

    public static DualCookingRecipeBuilder create(RecipeCategory category, ItemLike result, int count, Ingredient ingA, TagKey<Item> ingB, float exp) {
        return new DualCookingRecipeBuilder(category, result, count, ingA, Ingredient.of(ingB), exp, 200);
    }

    public static DualCookingRecipeBuilder create(RecipeCategory category, ItemLike result, int count, Ingredient ingA, ItemLike ingB, float exp) {
        return new DualCookingRecipeBuilder(category, result, count, ingA, Ingredient.of((ItemLike[])new ItemLike[]{ingB}), exp, 200);
    }

    public static DualCookingRecipeBuilder create(RecipeCategory category, ItemLike result, int count, Ingredient ingA, Ingredient ingB, float exp) {
        return new DualCookingRecipeBuilder(category, result, count, ingA, ingB, exp, 200);
    }

    public static DualCookingRecipeBuilder create(RecipeCategory category, ItemLike result, TagKey<Item> ingA, TagKey<Item> ingB, float exp) {
        return new DualCookingRecipeBuilder(category, result, 1, Ingredient.of(ingA), Ingredient.of(ingB), exp, 200);
    }

    public static DualCookingRecipeBuilder create(RecipeCategory category, ItemLike result, ItemLike ingA, ItemLike ingB, float exp) {
        return new DualCookingRecipeBuilder(category, result, 1, Ingredient.of((ItemLike[])new ItemLike[]{ingA}), Ingredient.of((ItemLike[])new ItemLike[]{ingB}), exp, 200);
    }

    public static DualCookingRecipeBuilder create(RecipeCategory category, ItemLike result, ItemLike ingA, TagKey<Item> ingB, float exp) {
        return new DualCookingRecipeBuilder(category, result, 1, Ingredient.of((ItemLike[])new ItemLike[]{ingA}), Ingredient.of(ingB), exp, 200);
    }

    public static DualCookingRecipeBuilder create(RecipeCategory category, ItemLike result, TagKey<Item> ingA, ItemLike ingB, float exp) {
        return new DualCookingRecipeBuilder(category, result, 1, Ingredient.of(ingA), Ingredient.of((ItemLike[])new ItemLike[]{ingB}), exp, 200);
    }

    public static DualCookingRecipeBuilder create(RecipeCategory category, ItemLike result, ItemLike ingA, Ingredient ingB, float exp) {
        return new DualCookingRecipeBuilder(category, result, 1, Ingredient.of((ItemLike[])new ItemLike[]{ingA}), ingB, exp, 200);
    }

    public static DualCookingRecipeBuilder create(RecipeCategory category, ItemLike result, TagKey<Item> ingA, Ingredient ingB, float exp) {
        return new DualCookingRecipeBuilder(category, result, 1, Ingredient.of(ingA), ingB, exp, 200);
    }

    public static DualCookingRecipeBuilder create(RecipeCategory category, ItemLike result, Ingredient ingA, TagKey<Item> ingB, float exp) {
        return new DualCookingRecipeBuilder(category, result, 1, ingA, Ingredient.of(ingB), exp, 200);
    }

    public static DualCookingRecipeBuilder create(RecipeCategory category, ItemLike result, Ingredient ingA, ItemLike ingB, float exp) {
        return new DualCookingRecipeBuilder(category, result, 1, ingA, Ingredient.of((ItemLike[])new ItemLike[]{ingB}), exp, 200);
    }

    public static DualCookingRecipeBuilder create(RecipeCategory category, ItemLike result, Ingredient ingA, Ingredient ingB, float exp) {
        return new DualCookingRecipeBuilder(category, result, 1, ingA, ingB, exp, 200);
    }
}

