/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.items;

import com.mojang.datafixers.util.Pair;
import dev.lopyluna.slag.content.items.DataToolParts;
import dev.lopyluna.slag.content.items.IToolPart;
import dev.lopyluna.slag.content.items.ModularToolItem;
import dev.lopyluna.slag.mixin.AxeItemAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class BakedModularToolItem
extends ModularToolItem {
    public BakedModularToolItem(Item.Properties properties) {
        super(properties.durability(924));
    }

    @NotNull
    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        boolean flag = false;
        for (IToolPart part : this.getToolParts(stack)) {
            if (!part.getMaterialType().fireProof) continue;
            flag = true;
            break;
        }
        if (flag) {
            stack.set(DataComponents.FIRE_RESISTANT, (Object)Unit.INSTANCE);
        }
        return super.getDefaultAttributeModifiers(stack).withModifierAdded(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, (double)(this.averageMod(stack, IToolPart::getSharp) * this.averageMod(stack, IToolPart::getSharpMod)), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)(-this.averageMod(stack, IToolPart::getSpeedMod)), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
    }

    @Override
    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        return false;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return Math.round(this.averageMod(stack, IToolPart::getEnch));
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        return this.isCorrectToolForDrops(stack, state) ? this.averageMod(stack, IToolPart::getSpeed) : super.getDestroySpeed(stack, state);
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack repairCandidate) {
        DataToolParts pParts = this.getParts(stack);
        if (pParts == null) {
            return false;
        }
        List<ItemStack> parts = pParts.itemsCopy();
        for (ItemStack partStack : parts) {
            Item item = partStack.getItem();
            if (!(item instanceof IToolPart)) continue;
            IToolPart part = (IToolPart)item;
            if (!part.getMaterialType().repairMaterials.get().test(repairCandidate)) continue;
            return true;
        }
        return false;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        boolean flag = false;
        for (IToolPart part : this.getToolParts(stack)) {
            if (flag) break;
            switch (part.getPartSegment().getPath()) {
                case "pickaxe_head": {
                    flag = state.is(BlockTags.MINEABLE_WITH_PICKAXE);
                    break;
                }
                case "axe_head": {
                    flag = state.is(BlockTags.MINEABLE_WITH_AXE);
                    break;
                }
                case "shovel_head": {
                    flag = state.is(BlockTags.MINEABLE_WITH_SHOVEL);
                    break;
                }
                case "hoe_head": {
                    flag = state.is(BlockTags.MINEABLE_WITH_HOE);
                    break;
                }
                case "sword_blade": {
                    flag = state.is(BlockTags.SWORD_EFFICIENT);
                }
            }
        }
        float i = 0.0f;
        if (state.is(BlockTags.INCORRECT_FOR_WOODEN_TOOL)) {
            i = 1.0f;
        }
        if (state.is(BlockTags.INCORRECT_FOR_GOLD_TOOL)) {
            i = 2.0f;
        }
        if (state.is(BlockTags.INCORRECT_FOR_STONE_TOOL)) {
            i = 3.0f;
        }
        if (state.is(BlockTags.INCORRECT_FOR_IRON_TOOL)) {
            i = 4.0f;
        }
        if (state.is(BlockTags.INCORRECT_FOR_DIAMOND_TOOL)) {
            i = 5.0f;
        }
        if (state.is(BlockTags.INCORRECT_FOR_NETHERITE_TOOL)) {
            i = 6.0f;
        }
        return this.averageMod(stack, IToolPart::getTough) > i + 0.5f && flag;
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return true;
    }

    public void postHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
    }

    public boolean isDamageable(ItemStack stack) {
        return true;
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        if (!level.isClientSide && state.getDestroySpeed((BlockGetter)level, pos) != 0.0f) {
            stack.hurtAndBreak(2, miningEntity, EquipmentSlot.MAINHAND);
        }
        return true;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
    }

    public int getMaxDamage(ItemStack stack) {
        return (int)(this.averageMod(stack, IToolPart::getDura) * this.averageMod(stack, IToolPart::getDuraMod));
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        for (IToolPart part : this.getToolParts(stack)) {
            if (!part.getPartSegment().getPath().equals("axe_head")) continue;
            return true;
        }
        return super.canDisableShield(stack, shield, entity, attacker);
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        ArrayList<Boolean> actions = new ArrayList<Boolean>();
        for (IToolPart part : this.getToolParts(stack)) {
            String path = part.getPartSegment().getPath();
            if (path.equals("pickaxe_head")) {
                actions.add(ItemAbilities.DEFAULT_PICKAXE_ACTIONS.contains(itemAbility));
            }
            if (path.equals("axe_head")) {
                actions.add(ItemAbilities.DEFAULT_AXE_ACTIONS.contains(itemAbility));
            }
            if (path.equals("shovel_head")) {
                actions.add(ItemAbilities.DEFAULT_SHOVEL_ACTIONS.contains(itemAbility));
            }
            if (path.equals("hoe_head")) {
                actions.add(ItemAbilities.DEFAULT_HOE_ACTIONS.contains(itemAbility));
            }
            if (!path.equals("sword_blade")) continue;
            actions.add(ItemAbilities.DEFAULT_SWORD_ACTIONS.contains(itemAbility));
        }
        return actions.contains(true);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        ArrayList<String> tool = new ArrayList<String>();
        for (IToolPart part : this.getToolParts(stack)) {
            String path = part.getPartSegment().getPath();
            if (path.equals("pickaxe_head") && !tool.contains("pickaxe")) {
                tool.add("pickaxe");
            }
            if (path.equals("axe_head") && !tool.contains("axe")) {
                tool.add("axe");
            }
            if (path.equals("shovel_head") && !tool.contains("shovel")) {
                tool.add("shovel");
            }
            if (path.equals("hoe_head") && !tool.contains("hoe")) {
                tool.add("hoe");
            }
            if (!path.equals("sword_blade") || tool.contains("sword")) continue;
            tool.add("sword");
        }
        if (tool.contains("shovel") && tool.contains("hoe")) {
            if (context.getHand().equals((Object)InteractionHand.OFF_HAND)) {
                shovel = this.shovelUseOn(context);
                if (shovel.consumesAction()) {
                    return shovel;
                }
            } else {
                hoe = this.hoeUseOn(context);
                if (hoe.consumesAction()) {
                    return hoe;
                }
            }
            if (tool.contains("axe") && (axe = this.axeUseOn(context)).consumesAction()) {
                return axe;
            }
        } else {
            if (tool.contains("shovel") && (shovel = this.shovelUseOn(context)).consumesAction()) {
                return shovel;
            }
            if (tool.contains("hoe") && (hoe = this.hoeUseOn(context)).consumesAction()) {
                return hoe;
            }
            if (tool.contains("axe") && (axe = this.axeUseOn(context)).consumesAction()) {
                return axe;
            }
        }
        return super.useOn(context);
    }

    public InteractionResult hoeUseOn(UseOnContext context) {
        Pair pair;
        BlockPos blockpos;
        Level level = context.getLevel();
        BlockState toolModifiedState = level.getBlockState(blockpos = context.getClickedPos()).getToolModifiedState(context, ItemAbilities.HOE_TILL, false);
        Pair pair2 = pair = toolModifiedState == null ? null : Pair.of(ctx -> true, (Object)HoeItem.changeIntoState((BlockState)toolModifiedState));
        if (pair == null) {
            return InteractionResult.PASS;
        }
        Predicate predicate = (Predicate)pair.getFirst();
        Consumer consumer = (Consumer)pair.getSecond();
        if (predicate.test(context)) {
            Player player = context.getPlayer();
            level.playSound(player, blockpos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!level.isClientSide) {
                consumer.accept(context);
                if (player != null) {
                    context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
                }
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public InteractionResult shovelUseOn(UseOnContext context) {
        BlockState state;
        Level level = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        BlockState blockstate = level.getBlockState(blockpos);
        if (context.getClickedFace() == Direction.DOWN) {
            return InteractionResult.PASS;
        }
        Player player = context.getPlayer();
        BlockState flatten = blockstate.getToolModifiedState(context, ItemAbilities.SHOVEL_FLATTEN, false);
        if (flatten != null && level.getBlockState(blockpos.above()).isAir()) {
            level.playSound(player, blockpos, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS, 1.0f, 1.0f);
            state = flatten;
        } else {
            state = blockstate.getToolModifiedState(context, ItemAbilities.SHOVEL_DOUSE, false);
            if (state != null && !level.isClientSide()) {
                level.levelEvent(null, 1009, blockpos, 0);
            }
        }
        if (state != null) {
            if (!level.isClientSide) {
                level.setBlock(blockpos, state, 11);
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockpos, GameEvent.Context.of((Entity)player, (BlockState)state));
                if (player != null) {
                    context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
                }
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public InteractionResult axeUseOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        Player player = context.getPlayer();
        if (AxeItemAccessor.playerHasShieldUseIntent(context)) {
            return InteractionResult.PASS;
        }
        Optional<BlockState> optional = this.evaluateNewBlockState(level, blockpos, player, level.getBlockState(blockpos), context);
        if (optional.isEmpty()) {
            return InteractionResult.PASS;
        }
        ItemStack itemstack = context.getItemInHand();
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, blockpos, itemstack);
        }
        level.setBlock(blockpos, optional.get(), 11);
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockpos, GameEvent.Context.of((Entity)player, (BlockState)optional.get()));
        if (player != null) {
            itemstack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    private Optional<BlockState> evaluateNewBlockState(Level level, BlockPos pos, @Nullable Player player, BlockState state, UseOnContext p_40529_) {
        Optional<BlockState> optional = Optional.ofNullable(state.getToolModifiedState(p_40529_, ItemAbilities.AXE_STRIP, false));
        if (optional.isPresent()) {
            level.playSound(player, pos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
            return optional;
        }
        Optional<BlockState> optional1 = Optional.ofNullable(state.getToolModifiedState(p_40529_, ItemAbilities.AXE_SCRAPE, false));
        if (optional1.isPresent()) {
            level.playSound(player, pos, SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.levelEvent(player, 3005, pos, 0);
            return optional1;
        }
        Optional<BlockState> optional2 = Optional.ofNullable(state.getToolModifiedState(p_40529_, ItemAbilities.AXE_WAX_OFF, false));
        if (optional2.isPresent()) {
            level.playSound(player, pos, SoundEvents.AXE_WAX_OFF, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.levelEvent(player, 3004, pos, 0);
            return optional2;
        }
        return Optional.empty();
    }
}

