/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.items;

import com.mojang.serialization.Codec;
import dev.lopyluna.slag.SlagEmbers;
import dev.lopyluna.slag.content.items.IToolPart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class DataToolParts
implements TooltipComponent {
    public static final DataToolParts EMPTY = new DataToolParts(new ArrayList<ItemStack>());
    public static final Codec<DataToolParts> CODEC = ItemStack.CODEC.listOf().xmap(DataToolParts::new, parts -> parts.items);
    public static final StreamCodec<RegistryFriendlyByteBuf, DataToolParts> STREAM_CODEC = ItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()).map(DataToolParts::new, parts -> parts.items);
    public List<ItemStack> items;

    public DataToolParts(List<ItemStack> items) {
        this.items = items;
    }

    public ItemStack getItem(Item item) {
        for (ItemStack itemstack : this.items) {
            if (!itemstack.is(item)) continue;
            return itemstack;
        }
        return ItemStack.EMPTY;
    }

    public boolean contains(Item item) {
        for (ItemStack itemstack : this.items) {
            if (!itemstack.is(item)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(ItemStack stack) {
        for (ItemStack itemstack : this.items) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)itemstack, (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    public boolean containsPartSegment(IToolPart part) {
        return this.containsPartSegment(part.getPartSegment());
    }

    public boolean containsPartSegment(String part) {
        if (part.contains(":")) {
            return this.containsPartSegment(ResourceLocation.parse((String)part));
        }
        return this.containsPartSegment(SlagEmbers.loc(part));
    }

    public boolean containsPartSegment(ResourceLocation part) {
        for (ItemStack itemstack : this.items) {
            IToolPart toolPart;
            Item item = itemstack.getItem();
            if (!(item instanceof IToolPart) || !(toolPart = (IToolPart)item).getPartSegment().equals((Object)part)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAllPartSegments(String ... required) {
        if (required == null) {
            return false;
        }
        ArrayList<ResourceLocation> loc = new ArrayList<ResourceLocation>();
        for (String r : required) {
            if (r.contains(":")) {
                loc.add(ResourceLocation.parse((String)r));
            }
            loc.add(SlagEmbers.loc(r));
        }
        if (loc.isEmpty()) {
            return false;
        }
        HashMap<ResourceLocation, Integer> need = new HashMap<ResourceLocation, Integer>();
        for (ResourceLocation r : loc) {
            if (r == null) {
                return false;
            }
            need.merge(r, 1, Integer::sum);
        }
        HashMap<ResourceLocation, Integer> have = new HashMap<ResourceLocation, Integer>();
        int partCount = 0;
        for (ItemStack s : this.items) {
            Item item = s.getItem();
            if (!(item instanceof IToolPart)) continue;
            IToolPart p = (IToolPart)item;
            ResourceLocation seg = p.getPartSegment();
            if (seg == null) {
                return false;
            }
            have.merge(seg, 1, Integer::sum);
            ++partCount;
        }
        if (partCount != loc.size()) {
            return false;
        }
        return have.equals(need);
    }

    public boolean hasAllPartSegments(ResourceLocation ... required) {
        if (required == null) {
            return false;
        }
        HashMap<ResourceLocation, Integer> need = new HashMap<ResourceLocation, Integer>();
        for (ResourceLocation r : required) {
            if (r == null) {
                return false;
            }
            need.merge(r, 1, Integer::sum);
        }
        HashMap<ResourceLocation, Integer> have = new HashMap<ResourceLocation, Integer>();
        int partCount = 0;
        for (ItemStack s : this.items) {
            Item item = s.getItem();
            if (!(item instanceof IToolPart)) continue;
            IToolPart p = (IToolPart)item;
            ResourceLocation seg = p.getPartSegment();
            if (seg == null) {
                return false;
            }
            have.merge(seg, 1, Integer::sum);
            ++partCount;
        }
        if (partCount != required.length) {
            return false;
        }
        return have.equals(need);
    }

    public ItemStack getItemUnsafe(int index) {
        return this.items.get(index);
    }

    public Stream<ItemStack> itemCopyStream() {
        return this.items.stream().map(ItemStack::copy);
    }

    public List<ItemStack> items() {
        return this.items;
    }

    public List<ItemStack> itemsCopy() {
        if (this.isEmpty()) {
            return new ArrayList<ItemStack>();
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemStack stack : this.items) {
            items.add(stack.copy());
        }
        return items;
    }

    public int size() {
        return this.items.size();
    }

    public boolean isEmpty() {
        return this.items == null || this.items.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof DataToolParts)) return false;
        DataToolParts parts = (DataToolParts)other;
        if (!DataToolParts.listMatches(this.items, parts.items)) return false;
        return true;
    }

    public static boolean listMatches(List<ItemStack> list, List<ItemStack> other) {
        if (list.size() != other.size()) {
            return false;
        }
        int i = 0;
        while (i < list.size()) {
            int finalI = i++;
            if (!other.stream().noneMatch(s -> DataToolParts.matches((ItemStack)list.get(finalI), s))) continue;
            return false;
        }
        return true;
    }

    public static boolean matches(ItemStack stack, ItemStack other) {
        if (stack.getItem() != other.getItem()) {
            return false;
        }
        return stack.getCount() == other.getCount() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)other);
    }

    public int hashCode() {
        return ItemStack.hashStackList(this.items);
    }

    public String toString() {
        return "ToolParts" + String.valueOf(this.items);
    }
}

