/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.items;

import java.util.function.Supplier;
import net.minecraft.world.item.crafting.Ingredient;
import org.joml.Math;

public class MaterialType {
    final float speed;
    final float dura;
    final float tough;
    final float sharp;
    final float ench;
    public final String texture;
    public final String id;
    public final boolean fireProof;
    public final Supplier<Ingredient> repairMaterials;

    private MaterialType(String id, float speed, float dura, float tough, float sharp, float ench, boolean fireProof, String texture, Supplier<Ingredient> repairMaterials) {
        this.id = id;
        this.speed = speed;
        this.dura = dura;
        this.tough = tough;
        this.sharp = sharp;
        this.ench = ench;
        this.texture = texture;
        this.fireProof = fireProof;
        this.repairMaterials = repairMaterials;
    }

    public static class Builder {
        private float speed = 0.0f;
        private float dura = 0.0f;
        private float tough = 0.0f;
        private float sharp = 0.0f;
        private float ench = 0.0f;
        private boolean fireProof = false;
        private final Supplier<Ingredient> repair;
        private String texture = "base";
        private final String id;

        public Builder(String id, Supplier<Ingredient> repairMaterial) {
            this.id = id;
            this.repair = repairMaterial;
        }

        public Builder setSpeed(int value) {
            this.speed = Math.max((float)value, (float)0.0f);
            return this;
        }

        public Builder setDura(int value) {
            this.dura = Math.max((float)value, (float)0.0f);
            return this;
        }

        public Builder setTough(int value) {
            this.tough = Math.max((float)value, (float)0.0f);
            return this;
        }

        public Builder setSharp(float value) {
            this.sharp = Math.max((float)value, (float)0.0f);
            return this;
        }

        public Builder setEnch(int value) {
            this.ench = Math.max((float)value, (float)0.0f);
            return this;
        }

        public Builder setTexture(String texture) {
            this.texture = texture;
            return this;
        }

        public Builder fireProof() {
            this.fireProof = true;
            return this;
        }

        public MaterialType register() {
            return new MaterialType(this.id, this.speed, this.dura, this.tough, this.sharp, this.ench, this.fireProof, this.texture, this.repair);
        }
    }
}

