/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.items;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.lopyluna.slag.SlagEmbers;
import dev.lopyluna.slag.content.items.BakedModularToolItem;
import dev.lopyluna.slag.content.items.DataToolParts;
import dev.lopyluna.slag.content.items.IToolPart;
import dev.lopyluna.slag.register.AllDataComponents;
import dev.lopyluna.slag.register.AllItems;
import dev.lopyluna.slag.register.AllLangs;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.ToDoubleFunction;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.IItemDecorator;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterItemDecorationsEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class ModularToolItem
extends Item {
    public ModularToolItem(Item.Properties properties) {
        super(properties.stacksTo(1).component(AllDataComponents.TOOL_PARTS, (Object)DataToolParts.EMPTY));
    }

    public List<IToolPart> getToolParts(ItemStack pStack) {
        ArrayList<IToolPart> toolParts = new ArrayList<IToolPart>();
        DataToolParts pParts = this.getParts(pStack);
        if (pParts == null) {
            return toolParts;
        }
        List<ItemStack> parts = pParts.itemsCopy();
        for (ItemStack stack : parts) {
            Item item = stack.getItem();
            if (!(item instanceof IToolPart)) continue;
            IToolPart part = (IToolPart)item;
            toolParts.add(part);
        }
        return toolParts;
    }

    public DataToolParts getParts(ItemStack pStack) {
        return (DataToolParts)pStack.get(AllDataComponents.TOOL_PARTS);
    }

    public void setParts(ItemStack pStack, List<ItemStack> pStacks) {
        pStack.set(AllDataComponents.TOOL_PARTS, (Object)new DataToolParts(pStacks));
    }

    @NotNull
    public String getDescriptionId(ItemStack stack) {
        String mixture = this.getToolMixture(stack);
        String material = "";
        DataToolParts pParts = this.getParts(stack);
        if (pParts == null) {
            return super.getDescriptionId(stack);
        }
        List<ItemStack> parts = pParts.itemsCopy();
        for (ItemStack partStack : parts) {
            Item item = partStack.getItem();
            if (!(item instanceof IToolPart)) continue;
            IToolPart part = (IToolPart)item;
            material = part.getMaterialType().id;
            break;
        }
        return mixture.isEmpty() || material.isEmpty() ? super.getDescriptionId(stack) : Util.makeDescriptionId((String)"item", (ResourceLocation)SlagEmbers.loc(BuiltInRegistries.ITEM.getKey((Object)this).getNamespace(), material + "_" + mixture));
    }

    public String getToolMixture(ItemStack pStack) {
        DataToolParts parts = this.getParts(pStack);
        if (parts == null) {
            return "";
        }
        if (parts.hasAllPartSegments("pickaxe_head")) {
            return "pickaxe";
        }
        if (parts.hasAllPartSegments("axe_head")) {
            return "axe";
        }
        if (parts.hasAllPartSegments("shovel_head")) {
            return "shovel";
        }
        if (parts.hasAllPartSegments("hoe_head")) {
            return "hoe";
        }
        if (parts.hasAllPartSegments("sword_blade", "guard")) {
            return "sword";
        }
        if (parts.hasAllPartSegments("axe_head", "hoe_head")) {
            return "mattock";
        }
        if (parts.hasAllPartSegments("pickaxe_head", "shovel_head")) {
            return "prybar";
        }
        if (parts.hasAllPartSegments("shovel_head", "hoe_head")) {
            return "graip";
        }
        if (parts.hasAllPartSegments("pickaxe_head", "axe_head")) {
            return "mallet";
        }
        if (parts.hasAllPartSegments("pickaxe_head", "axe_head", "shovel_head")) {
            return "hammer";
        }
        if (parts.hasAllPartSegments("hoe_head", "sword_blade", "guard")) {
            return "scythe";
        }
        if (parts.hasAllPartSegments("pickaxe_head", "axe_head", "sword_blade")) {
            return "maul";
        }
        if (parts.hasAllPartSegments("pickaxe_head", "axe_head", "shovel_head", "hoe_head", "sword_blade")) {
            return "paxel";
        }
        return "";
    }

    public String getPureMixture(ItemStack pStack) {
        DataToolParts parts = this.getParts(pStack);
        if (parts == null) {
            return "";
        }
        if (parts.hasAllPartSegments("axe_head", "hoe_head")) {
            return "mattock";
        }
        if (parts.hasAllPartSegments("pickaxe_head", "shovel_head")) {
            return "prybar";
        }
        if (parts.hasAllPartSegments("shovel_head", "hoe_head")) {
            return "graip";
        }
        if (parts.hasAllPartSegments("pickaxe_head", "axe_head")) {
            return "mallet";
        }
        if (parts.hasAllPartSegments("pickaxe_head", "axe_head", "shovel_head")) {
            return "hammer";
        }
        if (parts.hasAllPartSegments("hoe_head", "sword_blade", "guard")) {
            return "scythe";
        }
        if (parts.hasAllPartSegments("pickaxe_head", "axe_head", "sword_blade")) {
            return "maul";
        }
        if (parts.hasAllPartSegments("pickaxe_head", "axe_head", "shovel_head", "hoe_head", "sword_blade")) {
            return "paxel";
        }
        return "";
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (stack.getCount() != 1) {
            return false;
        }
        if (action == ClickAction.PRIMARY && slot.allowModification(player)) {
            DataToolParts parts = this.getParts(stack);
            if (parts == null) {
                return false;
            }
            List<ItemStack> toolParts = parts.itemsCopy();
            if (other.isEmpty()) {
                if (toolParts.isEmpty()) {
                    return false;
                }
                ItemStack itemstack = !parts.contains(Items.STICK) ? toolParts.getFirst() : toolParts.getLast();
                this.playRemoveOneSound((Entity)player);
                access.set(itemstack);
                if (!parts.contains(Items.STICK)) {
                    toolParts.removeFirst();
                } else {
                    toolParts.removeLast();
                }
                this.setParts(stack, toolParts);
                return true;
            }
            Item item = other.getItem();
            if (item instanceof IToolPart) {
                IToolPart part = (IToolPart)item;
                if (toolParts.size() > 5 || parts.containsPartSegment(part) || parts.contains(other) || parts.contains(Items.STICK)) {
                    this.plaFailSound((Entity)player);
                } else {
                    this.playInsertSound((Entity)player);
                    toolParts.add(other);
                    access.set(ItemStack.EMPTY);
                    this.setParts(stack, toolParts);
                }
                return true;
            }
            if (other.is(Items.STICK)) {
                if (toolParts.isEmpty() || toolParts.size() > 6 || parts.contains(other) || other.getCount() > 3) {
                    this.plaFailSound((Entity)player);
                } else {
                    this.playInsertSound((Entity)player);
                    toolParts.add(other);
                    access.set(ItemStack.EMPTY);
                    this.setParts(stack, toolParts);
                }
                return true;
            }
            if (this.testIsHammer(other)) {
                if (!parts.contains(Items.STICK) || ModularToolItem.testParts(parts) || !this.test(parts, player) || !this.testHammer(stack, other)) {
                    this.plaFailSound((Entity)player);
                } else {
                    this.playBuildSound((Entity)player, this.testStation(player));
                    slot.set(stack.transmuteCopy(AllItems.BAKED_TOOL));
                    if (other.getItem() instanceof BakedModularToolItem) {
                        ModularToolItem.hurtAndBreak(other, 4, player.level(), (LivingEntity)player);
                    } else {
                        other.shrink(1);
                    }
                }
                return true;
            }
        }
        return false;
    }

    public static void hurtAndBreak(ItemStack stack, int amount, Level level, @Nullable LivingEntity livingEntity) {
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (stack.isDamageableItem()) {
                Consumer<Item> onBreak = item -> {
                    if (!stack.isEmpty() && livingEntity != null && !livingEntity.isSilent()) {
                        level.playLocalSound(livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), stack.getBreakingSound(), livingEntity.getSoundSource(), 0.8f, 0.8f + level.random.nextFloat() * 0.4f, false);
                    }
                };
                amount = stack.getItem().damageItem(stack, amount, livingEntity, onBreak);
                if (livingEntity == null || !livingEntity.hasInfiniteMaterials()) {
                    if (amount > 0 && (amount = EnchantmentHelper.processDurabilityChange((ServerLevel)server, (ItemStack)stack, (int)amount)) <= 0) {
                        return;
                    }
                    if (livingEntity instanceof ServerPlayer) {
                        ServerPlayer sp = (ServerPlayer)livingEntity;
                        if (amount != 0) {
                            CriteriaTriggers.ITEM_DURABILITY_CHANGED.trigger(sp, stack, stack.getDamageValue() + amount);
                        }
                    }
                    int i = stack.getDamageValue() + amount;
                    stack.setDamageValue(i);
                    if (i >= stack.getMaxDamage()) {
                        stack.shrink(1);
                        onBreak.accept(stack.getItem());
                    }
                }
            }
        }
    }

    public static boolean testParts(DataToolParts parts) {
        if (parts.hasAllPartSegments("pickaxe_head")) {
            return false;
        }
        if (parts.hasAllPartSegments("axe_head")) {
            return false;
        }
        if (parts.hasAllPartSegments("shovel_head")) {
            return false;
        }
        if (parts.hasAllPartSegments("hoe_head")) {
            return false;
        }
        if (parts.hasAllPartSegments("sword_blade", "guard")) {
            return false;
        }
        if (parts.hasAllPartSegments("axe_head", "hoe_head")) {
            return false;
        }
        if (parts.hasAllPartSegments("pickaxe_head", "shovel_head")) {
            return false;
        }
        if (parts.hasAllPartSegments("shovel_head", "hoe_head")) {
            return false;
        }
        if (parts.hasAllPartSegments("pickaxe_head", "axe_head")) {
            return false;
        }
        if (parts.hasAllPartSegments("pickaxe_head", "axe_head", "shovel_head")) {
            return false;
        }
        if (parts.hasAllPartSegments("hoe_head", "sword_blade", "guard")) {
            return false;
        }
        if (parts.hasAllPartSegments("pickaxe_head", "axe_head", "shovel_head", "hoe_head", "sword_blade")) {
            return false;
        }
        return !parts.hasAllPartSegments("pickaxe_head", "axe_head", "sword_blade");
    }

    public static int testRodCount(DataToolParts parts) {
        if (parts.hasAllPartSegments("pickaxe_head")) {
            return 2;
        }
        if (parts.hasAllPartSegments("axe_head")) {
            return 2;
        }
        if (parts.hasAllPartSegments("shovel_head")) {
            return 2;
        }
        if (parts.hasAllPartSegments("hoe_head")) {
            return 2;
        }
        if (parts.hasAllPartSegments("sword_blade", "guard")) {
            return 1;
        }
        if (parts.hasAllPartSegments("axe_head", "hoe_head")) {
            return 2;
        }
        if (parts.hasAllPartSegments("pickaxe_head", "shovel_head")) {
            return 2;
        }
        if (parts.hasAllPartSegments("shovel_head", "hoe_head")) {
            return 2;
        }
        if (parts.hasAllPartSegments("pickaxe_head", "axe_head")) {
            return 2;
        }
        if (parts.hasAllPartSegments("pickaxe_head", "axe_head", "shovel_head")) {
            return 3;
        }
        if (parts.hasAllPartSegments("hoe_head", "sword_blade", "guard")) {
            return 3;
        }
        if (parts.hasAllPartSegments("pickaxe_head", "axe_head", "sword_blade")) {
            return 3;
        }
        if (parts.hasAllPartSegments("pickaxe_head", "axe_head", "shovel_head", "hoe_head", "sword_blade")) {
            return 3;
        }
        return 0;
    }

    private void plaFailSound(Entity entity) {
        entity.playSound(SoundEvents.CRAFTER_FAIL, 1.25f, 0.5f + entity.level().getRandom().nextFloat() * 0.4f);
        entity.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_BASS.value(), 0.5f, 0.5f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playRemoveOneSound(Entity entity) {
        entity.playSound(SoundEvents.DECORATED_POT_INSERT, 0.8f, 0.5f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playInsertSound(Entity entity) {
        entity.playSound(SoundEvents.DECORATED_POT_INSERT, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playBuildSound(Entity entity, @Nullable SoundEvent event) {
        entity.playSound(event != null ? event : SoundEvents.ANVIL_USE, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    public boolean testIsHammer(ItemStack other) {
        if (other.is(ItemTags.STONE_TOOL_MATERIALS) || other.is(ItemTags.LOGS)) {
            return true;
        }
        Item item = other.getItem();
        if (item instanceof BakedModularToolItem) {
            BakedModularToolItem item2 = (BakedModularToolItem)item;
            DataToolParts otherParts = item2.getParts(other);
            return otherParts.hasAllPartSegments("pickaxe_head", "axe_head", "shovel_head") || otherParts.hasAllPartSegments("pickaxe_head", "axe_head");
        }
        return false;
    }

    public boolean testHammer(ItemStack stack, ItemStack other) {
        float tier = this.averageMod(stack, IToolPart::getTough);
        if (other.is(ItemTags.STONE_TOOL_MATERIALS) || other.is(ItemTags.LOGS)) {
            return 3.5f >= tier;
        }
        Item item = other.getItem();
        if (item instanceof BakedModularToolItem) {
            BakedModularToolItem item2 = (BakedModularToolItem)item;
            DataToolParts otherParts = item2.getParts(other);
            float otherTier = this.averageMod(other, IToolPart::getTough);
            if (Math.max(otherTier + 1.5f, 4.0f) >= tier && otherParts.hasAllPartSegments("pickaxe_head", "axe_head", "shovel_head")) {
                return true;
            }
            return Math.max(otherTier + 1.0f, 3.5f) >= tier && otherParts.hasAllPartSegments("pickaxe_head", "axe_head");
        }
        return false;
    }

    public SoundEvent testStation(Player player) {
        Level level = player.level();
        BlockState state = level.getBlockState(Item.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE).getBlockPos());
        if (state.is(BlockTags.ANVIL)) {
            return SoundEvents.ANVIL_USE;
        }
        if (state.is(Blocks.SMITHING_TABLE)) {
            return SoundEvents.SMITHING_TABLE_USE;
        }
        if (state.is(Blocks.CRAFTING_TABLE)) {
            return SoundEvents.CRAFTER_CRAFT;
        }
        return null;
    }

    public float hammerTier(DataToolParts parts, ItemStack stack) {
        if (parts.hasAllPartSegments("pickaxe_head", "axe_head", "shovel_head")) {
            return Math.max(this.averageMod(stack, IToolPart::getTough) + 1.5f, 4.0f);
        }
        if (parts.hasAllPartSegments("pickaxe_head", "axe_head")) {
            return Math.max(this.averageMod(stack, IToolPart::getTough) + 1.0f, 3.5f);
        }
        return 0.0f;
    }

    public boolean test(DataToolParts parts, Player player) {
        Level level = player.level();
        int rodCount = ModularToolItem.testRodCount(parts);
        if (!parts.contains(Items.STICK)) {
            return false;
        }
        if (rodCount != parts.getItem(Items.STICK).getCount()) {
            return false;
        }
        BlockState lookState = level.getBlockState(Item.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE).getBlockPos());
        int size = parts.size();
        if (size > 4) {
            return lookState.is(BlockTags.ANVIL);
        }
        if (size > 3) {
            return lookState.is(Blocks.SMITHING_TABLE) || lookState.is(BlockTags.ANVIL);
        }
        return lookState.is(Blocks.CRAFTING_TABLE) || lookState.is(Blocks.SMITHING_TABLE) || lookState.is(BlockTags.ANVIL);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        Level level = context.level();
        if (level instanceof ClientLevel) {
            ClientLevel level2 = (ClientLevel)level;
            DataToolParts parts = this.getParts(stack);
            if (parts != null && !parts.isEmpty()) {
                List<ItemStack> toolParts = parts.itemsCopy();
                if (toolParts.isEmpty()) {
                    tooltip.add((Component)Component.translatableWithFallback((String)"item.slag.modular_tool", (String)"Insert Tool Parts to get started!").withStyle(ChatFormatting.GRAY));
                    return;
                }
                LocalPlayer player = Minecraft.getInstance().player;
                float tier = this.averageMod(stack, IToolPart::getTough);
                if (!(this instanceof BakedModularToolItem)) {
                    int rodCount = ModularToolItem.testRodCount(parts);
                    boolean f = true;
                    if (!parts.contains(Items.STICK)) {
                        if (rodCount <= 0) {
                            tooltip.add((Component)Component.translatableWithFallback((String)"item.slag.modular_tool.invalid", (String)"Invalid Tool").withStyle(ChatFormatting.RED));
                        } else {
                            tooltip.add((Component)Component.translatableWithFallback((String)"item.slag.modular_tool.rods", (String)("Insert " + rodCount + "x Stick" + (rodCount > 1 ? "s!" : "!"))).withStyle(ChatFormatting.RED));
                        }
                        f = false;
                    } else if (rodCount != parts.getItem(Items.STICK).getCount()) {
                        tooltip.add((Component)Component.translatableWithFallback((String)"item.slag.modular_tool.rod_count", (String)"Too much Sticks!").withStyle(ChatFormatting.RED));
                        f = false;
                    } else if (player != null) {
                        BlockState lookState = level2.getBlockState(Item.getPlayerPOVHitResult((Level)level2, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE).getBlockPos());
                        int size = parts.size();
                        if (size > 4) {
                            if (!lookState.is(BlockTags.ANVIL)) {
                                tooltip.add((Component)Component.translatableWithFallback((String)"item.slag.modular_tool.anvil", (String)"Must look at an Anvil atleast to combine said planned tool!!!").withStyle(ChatFormatting.RED));
                                f = false;
                            }
                        } else if (size > 3) {
                            if (!lookState.is(Blocks.SMITHING_TABLE) && !lookState.is(BlockTags.ANVIL)) {
                                tooltip.add((Component)Component.translatableWithFallback((String)"item.slag.modular_tool.smithing", (String)"Must look at an Smithing Table atleast to combine said planned tool!!!").withStyle(ChatFormatting.RED));
                                f = false;
                            }
                        } else if (!(lookState.is(Blocks.CRAFTING_TABLE) || lookState.is(Blocks.SMITHING_TABLE) || lookState.is(BlockTags.ANVIL))) {
                            tooltip.add((Component)Component.translatableWithFallback((String)"item.slag.modular_tool.crafting", (String)"Must look at an Crafting Table atleast to combine said planned tool!!!").withStyle(ChatFormatting.RED));
                            f = false;
                        }
                    }
                    if (f) {
                        if (3.5f >= tier) {
                            tooltip.add((Component)Component.translatableWithFallback((String)"item.slag.modular_tool.crafting", (String)"Use Rock/Wood type item or Mallet/Hammers on the Blueprint to combine!").withStyle(ChatFormatting.RED));
                        } else {
                            tooltip.add((Component)Component.translatableWithFallback((String)"item.slag.modular_tool.crafting", (String)("Use Mallet/Hammers with Forging Tier >= '" + tier + "' on the Blueprint to combine!")).withStyle(ChatFormatting.RED));
                        }
                    }
                }
                AllLangs.modularToolStats(tooltip, parts, stack, this);
                AllLangs.modularToolParts(tooltip, toolParts);
            } else {
                tooltip.add((Component)Component.translatableWithFallback((String)"item.slag.modular_tool.waiting", (String)"Insert Tool Parts to get started!").withStyle(ChatFormatting.GRAY));
            }
        }
    }

    public float averageMod(ItemStack stack, ToDoubleFunction<IToolPart> getter) {
        List<IToolPart> parts = this.getToolParts(stack);
        if (parts.isEmpty()) {
            return 0.0f;
        }
        double sum = 0.0;
        for (IToolPart p : parts) {
            sum += getter.applyAsDouble(p);
        }
        return ModularToolItem.round2((float)(sum / (double)parts.size()));
    }

    static float round2(float v) {
        return (float)((int)(v * 100.0f)) / 100.0f;
    }

    @EventBusSubscriber(modid="slag", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
    public static class ModularToolPartRenderer {
        public static final IItemDecorator DECORATOR = (guiGraphics, font, stack, xOffset, yOffset) -> {
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof ModularToolItem) {
                ModularToolItem item = (ModularToolItem)patt0$temp;
                DataToolParts parts = item.getParts(stack);
                PoseStack ms = guiGraphics.pose();
                int i = 0;
                if (parts != null && !parts.isEmpty()) {
                    for (ItemStack pStack : parts.itemsCopy()) {
                        if (pStack.isEmpty()) continue;
                        ms.pushPose();
                        Random random = new Random(pStack.getItem().hashCode() + i + parts.size());
                        ms.translate((float)xOffset + random.nextFloat() * 5.0f - 2.5f, (float)yOffset + random.nextFloat() * 5.0f - 2.5f, (float)(100 + i));
                        guiGraphics.renderItem(pStack, 0, 0);
                        ms.popPose();
                        i += 2;
                    }
                }
            }
            return false;
        };

        @SubscribeEvent
        public static void registerItemDecorations(RegisterItemDecorationsEvent event) {
            for (Map.Entry entry : BuiltInRegistries.ITEM.entrySet()) {
                ModularToolItem item;
                Object v = entry.getValue();
                if (!(v instanceof ModularToolItem) || (item = (ModularToolItem)((Object)v)) instanceof BakedModularToolItem) continue;
                event.register((ItemLike)item, DECORATOR);
            }
        }

        @SubscribeEvent
        public static void registerAdditionalModels(ModelEvent.RegisterAdditional e) {
            for (Map.Entry entry : BuiltInRegistries.ITEM.entrySet()) {
                Item item = (Item)entry.getValue();
                if (!(item instanceof IToolPart)) continue;
                IToolPart tool = (IToolPart)item;
                ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)item);
                e.register(ModelResourceLocation.standalone((ResourceLocation)SlagEmbers.loc(key.getNamespace(), "item/" + key.getPath() + "_built")));
                for (String mixture : AllItems.testMixture(tool.getPartSegment().getPath())) {
                    e.register(ModelResourceLocation.standalone((ResourceLocation)SlagEmbers.loc(key.getNamespace(), "item/" + key.getPath() + "_" + mixture)));
                }
            }
            for (String mixture : List.of("pickaxe", "axe", "shovel", "hoe", "sword", "mattock", "prybar", "graip", "mallet", "hammer", "scythe", "maul", "paxel")) {
                e.register(ModelResourceLocation.standalone((ResourceLocation)SlagEmbers.loc("item/handle_fire_proof_" + mixture)));
                e.register(ModelResourceLocation.standalone((ResourceLocation)SlagEmbers.loc("item/handle_" + mixture)));
            }
        }

        @SubscribeEvent
        public static void registerItemClientExtension(RegisterClientExtensionsEvent event) {
            IClientItemExtensions ext = new IClientItemExtensions(){
                private BlockEntityWithoutLevelRenderer bewlr;

                @NotNull
                public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                    if (this.bewlr == null) {
                        final Minecraft mc = Minecraft.getInstance();
                        this.bewlr = new BlockEntityWithoutLevelRenderer(this, mc.getBlockEntityRenderDispatcher(), mc.getEntityModels()){

                            public void renderByItem(ItemStack stack, ItemDisplayContext ctx, PoseStack ms, MultiBufferSource buf, int light, int overlay) {
                                ItemRenderer itemRenderer = mc.getItemRenderer();
                                ClientLevel level = mc.level;
                                LocalPlayer player = mc.player;
                                Item item = stack.getItem();
                                if (!(item instanceof ModularToolItem)) {
                                    BakedModel self = itemRenderer.getModel(stack, (Level)level, (LivingEntity)player, 0);
                                    1.applyHandheldLikeTransform(ms, ctx, mc.getModelManager());
                                    itemRenderer.render(stack, ctx, false, ms, buf, light, overlay, self);
                                    return;
                                }
                                ModularToolItem tool = (ModularToolItem)item;
                                1.applyHandheldLikeTransform(ms, ctx, mc.getModelManager());
                                ms.translate(0.5f, 0.5f, 0.5f);
                                float nudge = ctx == ItemDisplayContext.GUI ? 1.0E-4f : 0.0f;
                                int i = 0;
                                DataToolParts parts = tool.getParts(stack);
                                boolean fireImmune = stack.has(DataComponents.FIRE_RESISTANT);
                                if (parts != null && !parts.isEmpty()) {
                                    for (ItemStack pStack : parts.itemsCopy()) {
                                        if (pStack.isEmpty()) continue;
                                        ms.pushPose();
                                        if (nudge != 0.0f) {
                                            ms.translate(0.0f, 0.0f, (float)i * nudge);
                                        }
                                        ItemModelShaper shaper = itemRenderer.getItemModelShaper();
                                        ResourceLocation loc = BuiltInRegistries.ITEM.getKey((Object)pStack.getItem());
                                        ModelManager manager = shaper.getModelManager();
                                        String mixture = tool.getToolMixture(stack);
                                        String pureMixture = tool.getPureMixture(stack);
                                        if (!mixture.isEmpty() && stack.getItem() instanceof BakedModularToolItem) {
                                            BakedModel builtModel = pStack.is(Items.STICK) ? manager.getModel(ModelResourceLocation.standalone((ResourceLocation)SlagEmbers.loc(fireImmune ? "item/handle_fire_proof_" + mixture : "item/handle_" + mixture))) : (pureMixture.isEmpty() ? manager.getModel(ModelResourceLocation.standalone((ResourceLocation)SlagEmbers.loc(loc.getNamespace(), "item/" + loc.getPath() + "_built"))) : manager.getModel(ModelResourceLocation.standalone((ResourceLocation)SlagEmbers.loc(loc.getNamespace(), "item/" + loc.getPath() + "_" + pureMixture))));
                                            itemRenderer.render(stack, ItemDisplayContext.NONE, false, ms, buf, light, overlay, builtModel);
                                        } else {
                                            BakedModel model = itemRenderer.getModel(pStack, (Level)level, (LivingEntity)player, 0);
                                            itemRenderer.render(stack, ItemDisplayContext.NONE, false, ms, buf, light, overlay, model);
                                        }
                                        ms.popPose();
                                        ++i;
                                    }
                                }
                            }

                            private static void applyHandheldLikeTransform(PoseStack ms, ItemDisplayContext ctx, ModelManager models) {
                                boolean left = ctx == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || ctx == ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
                                ms.translate(0.5f, 0.5f, 0.5f);
                                switch (ctx) {
                                    case THIRD_PERSON_RIGHT_HAND: {
                                        1.trans(ms, 0.0f, 4.0f, 0.5f);
                                        1.scale(ms, 0.85f);
                                        1.rot(ms, 0.0f, -90.0f, 55.0f);
                                        break;
                                    }
                                    case THIRD_PERSON_LEFT_HAND: {
                                        1.trans(ms, 0.0f, 4.0f, 0.5f);
                                        1.scale(ms, 0.85f);
                                        1.rot(ms, 0.0f, 90.0f, -55.0f);
                                        break;
                                    }
                                    case FIRST_PERSON_RIGHT_HAND: {
                                        1.trans(ms, 1.13f, 3.2f, 1.13f);
                                        1.scale(ms, 0.68f);
                                        1.rot(ms, 0.0f, -90.0f, 25.0f);
                                        break;
                                    }
                                    case FIRST_PERSON_LEFT_HAND: {
                                        1.trans(ms, -1.13f, 3.2f, 1.13f);
                                        1.scale(ms, 0.68f);
                                        1.rot(ms, 0.0f, 90.0f, -25.0f);
                                        break;
                                    }
                                    case GROUND: {
                                        1.trans(ms, 0.0f, 3.0f, 0.0f);
                                        1.scale(ms, 0.5f);
                                        break;
                                    }
                                    case FIXED: {
                                        1.rot(ms, 0.0f, 180.0f, 0.0f);
                                        break;
                                    }
                                    case HEAD: {
                                        1.trans(ms, 0.0f, 13.0f, 7.0f);
                                        1.rot(ms, 0.0f, 180.0f, 0.0f);
                                        break;
                                    }
                                }
                                if (left) {
                                    ms.mulPose(Axis.YP.rotationDegrees(180.0f));
                                }
                                ms.translate(-0.5f, -0.5f, -0.5f);
                            }

                            private static void rot(PoseStack ms, float x, float y, float z) {
                                if (x != 0.0f) {
                                    ms.mulPose(Axis.XP.rotationDegrees(x));
                                }
                                if (y != 0.0f) {
                                    ms.mulPose(Axis.YP.rotationDegrees(y));
                                }
                                if (z != 0.0f) {
                                    ms.mulPose(Axis.ZP.rotationDegrees(z));
                                }
                            }

                            private static void trans(PoseStack ms, float x, float y, float z) {
                                ms.translate(x / 16.0f, y / 16.0f, z / 16.0f);
                            }

                            private static void scale(PoseStack ms, float s) {
                                ms.scale(s, s, s);
                            }
                        };
                    }
                    return this.bewlr;
                }
            };
            for (Map.Entry entry : BuiltInRegistries.ITEM.entrySet()) {
                Object v = entry.getValue();
                if (!(v instanceof ModularToolItem)) continue;
                ModularToolItem item = (ModularToolItem)((Object)v);
                event.registerItem(ext, new Item[]{item});
            }
        }
    }
}

