/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.items.dynamic_mold;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.lopyluna.slag.SlagEmbers;
import dev.lopyluna.slag.client.render.CustomRenderedItemModel;
import dev.lopyluna.slag.client.render.CustomRenderedItemModelRenderer;
import dev.lopyluna.slag.client.render.PartialItemModelRenderer;
import dev.lopyluna.slag.content.items.dynamic_mold.DynamicMoldItem;
import dev.lopyluna.slag.register.AllDataComponents;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.data.Iterate;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ModelEvent;

@EventBusSubscriber(modid="slag", value={Dist.CLIENT})
@ParametersAreNonnullByDefault
public class DynamicMoldRenderer
extends CustomRenderedItemModelRenderer {
    @Override
    protected void render(ItemStack stack, ItemRenderer itemRenderer, CustomRenderedItemModel model, PartialItemModelRenderer renderer, ItemDisplayContext transformType, PoseStack ms, MultiBufferSource buf, int light, int overlay) {
        boolean hasMold = stack.has(AllDataComponents.CAST_TYPE);
        TagKey cast = (TagKey)stack.get(AllDataComponents.CAST_TYPE);
        boolean cutout = stack.has(AllDataComponents.CUTOUT);
        ItemModelShaper shaper = itemRenderer.getItemModelShaper();
        ModelManager manager = shaper.getModelManager();
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        String modID = id.getNamespace();
        String item = id.getPath();
        if (!hasMold || cast == null) {
            if (cutout) {
                renderer.render(manager.getModel(ModelResourceLocation.standalone((ResourceLocation)SlagEmbers.loc(modID, "item/cutout/" + item))), light);
            } else {
                renderer.render(model.getOriginalModel(), light);
            }
            return;
        }
        renderer.render(manager.getModel(ModelResourceLocation.standalone((ResourceLocation)SlagEmbers.loc(modID, "item/" + (cutout ? "cutout/" : "") + item + "/" + cast.location().getPath().split("/")[1]))), light);
    }

    @SubscribeEvent
    public static void registerAdditionalModels(ModelEvent.RegisterAdditional e) {
        ArrayList<String> castTypes = new ArrayList<String>(List.of("axe_heads", "balls", "dusts", "gems", "guards", "hoe_heads", "ingots", "nuggets", "pickaxe_heads", "rods", "shovel_heads", "sword_blades"));
        for (Map.Entry entry : BuiltInRegistries.ITEM.entrySet()) {
            Item item = (Item)entry.getValue();
            if (!(item instanceof DynamicMoldItem)) continue;
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
            String modID = id.getNamespace();
            String itemID = id.getPath();
            e.register(ModelResourceLocation.standalone((ResourceLocation)SlagEmbers.loc(modID, "item/cutout/" + itemID)));
            for (String cast : castTypes) {
                for (boolean cutout : Iterate.trueAndFalse) {
                    e.register(ModelResourceLocation.standalone((ResourceLocation)SlagEmbers.loc(modID, "item/" + (cutout ? "cutout/" : "") + itemID + "/" + cast)));
                }
            }
        }
    }
}

