/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.jei;

import dev.lopyluna.slag.SlagEmbers;
import dev.lopyluna.slag.content.blocks.forge.DoubleSmeltingRecipe;
import dev.lopyluna.slag.content.blocks.forge.client.ForgeMenu;
import dev.lopyluna.slag.content.blocks.forge.client.ForgeScreen;
import dev.lopyluna.slag.content.blocks.melter.MeltingRecipe;
import dev.lopyluna.slag.content.blocks.melter.client.MelterMenu;
import dev.lopyluna.slag.content.blocks.melter.client.MelterScreen;
import dev.lopyluna.slag.content.items.DataToolParts;
import dev.lopyluna.slag.content.items.MaterialType;
import dev.lopyluna.slag.content.jei.EmbersRecipesJEI;
import dev.lopyluna.slag.content.jei.category.DoubleSmeltingCategory;
import dev.lopyluna.slag.content.jei.category.MeltingCategory;
import dev.lopyluna.slag.register.AllBlocks;
import dev.lopyluna.slag.register.AllCreativeTab;
import dev.lopyluna.slag.register.AllDataComponents;
import dev.lopyluna.slag.register.AllItems;
import dev.lopyluna.slag.register.AllMenuTypes;
import dev.lopyluna.slag.register.AllRecipes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.library.plugins.vanilla.crafting.CategoryRecipeValidator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class EmbersJEI
implements IModPlugin {
    @Nullable
    private IRecipeCategory<RecipeHolder<DoubleSmeltingRecipe>> forgeCategory;
    @Nullable
    private IRecipeCategory<RecipeHolder<MeltingRecipe>> melterCategory;

    @NotNull
    public ResourceLocation getPluginUid() {
        return SlagEmbers.loc("main");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        IRecipeCategory[] iRecipeCategoryArray = new IRecipeCategory[1];
        this.forgeCategory = new DoubleSmeltingCategory(guiHelper);
        iRecipeCategoryArray[0] = this.forgeCategory;
        registration.addRecipeCategories(iRecipeCategoryArray);
        IRecipeCategory[] iRecipeCategoryArray2 = new IRecipeCategory[1];
        this.melterCategory = new MeltingCategory(guiHelper);
        iRecipeCategoryArray2[0] = this.melterCategory;
        registration.addRecipeCategories(iRecipeCategoryArray2);
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        ErrorUtil.checkNotNull(this.forgeCategory, (String)"furnaceCategory");
        ErrorUtil.checkNotNull(this.melterCategory, (String)"melterCategory");
        IIngredientManager ingredientManager = registration.getIngredientManager();
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        registration.addRecipes(EmbersRecipesJEI.DOUBLE_SMELTING.get(), this.getBrickForgeRecipes(this.forgeCategory, level, ingredientManager));
        registration.addRecipes(EmbersRecipesJEI.MELTING.get(), this.getMelterRecipes(this.melterCategory, level, ingredientManager));
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(ForgeScreen.class, 78, 32, 28, 23, new RecipeType[]{EmbersRecipesJEI.DOUBLE_SMELTING.get(), RecipeTypes.FUELING});
        registration.addRecipeClickArea(MelterScreen.class, 78, 32, 28, 23, new RecipeType[]{EmbersRecipesJEI.MELTING.get()});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(ForgeMenu.class, (MenuType)AllMenuTypes.FORGE.get(), EmbersRecipesJEI.DOUBLE_SMELTING.get(), 0, 2, 4, 36);
        registration.addRecipeTransferHandler(MelterMenu.class, (MenuType)AllMenuTypes.MELTER.get(), EmbersRecipesJEI.MELTING.get(), 0, 1, 1, 36);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(AllBlocks.FORGE, new RecipeType[]{RecipeTypes.FUELING});
        registration.addRecipeCatalyst(AllBlocks.FORGE, new RecipeType[]{EmbersRecipesJEI.DOUBLE_SMELTING.get()});
        registration.addRecipeCatalyst(AllBlocks.MELTER, new RecipeType[]{EmbersRecipesJEI.MELTING.get()});
    }

    public List<RecipeHolder<DoubleSmeltingRecipe>> getBrickForgeRecipes(IRecipeCategory<RecipeHolder<DoubleSmeltingRecipe>> forgeCategory, ClientLevel level, IIngredientManager manager) {
        CategoryRecipeValidator validator = new CategoryRecipeValidator(forgeCategory, manager, 1);
        return EmbersJEI.getValidHandledRecipes(level.getRecipeManager(), (net.minecraft.world.item.crafting.RecipeType)AllRecipes.DOUBLE_SMELTING.get(), validator);
    }

    public List<RecipeHolder<MeltingRecipe>> getMelterRecipes(IRecipeCategory<RecipeHolder<MeltingRecipe>> forgeCategory, ClientLevel level, IIngredientManager manager) {
        CategoryRecipeValidator validator = new CategoryRecipeValidator(forgeCategory, manager, 1);
        return EmbersJEI.getValidHandledRecipes(level.getRecipeManager(), (net.minecraft.world.item.crafting.RecipeType)AllRecipes.MELTING.get(), validator);
    }

    private static <C extends RecipeInput, T extends Recipe<C>> List<RecipeHolder<T>> getValidHandledRecipes(RecipeManager recipeManager, net.minecraft.world.item.crafting.RecipeType<T> recipeType, CategoryRecipeValidator<T> validator) {
        return recipeManager.getAllRecipesFor(recipeType).stream().filter(arg_0 -> validator.isRecipeHandled(arg_0)).toList();
    }

    public void registerItemSubtypes(ISubtypeRegistration reg) {
        reg.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)AllItems.BAKED_TOOL.get()), (stack, ctx) -> {
            DataToolParts data = (DataToolParts)stack.get(AllDataComponents.TOOL_PARTS);
            if (data == null || data.isEmpty()) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (ItemStack s : data.itemsCopy()) {
                if (s.isEmpty()) continue;
                ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)s.getItem());
                sb.append(id).append('#').append(s.getCount()).append(';');
            }
            return sb.toString();
        });
    }

    public void onRuntimeAvailable(IJeiRuntime rt) {
        IIngredientManager im = rt.getIngredientManager();
        ArrayList variants = new ArrayList();
        for (MaterialType material : AllItems.MATERIAL_TYPES) {
            AllCreativeTab.getToolMixture(material).forEach((tool, parts) -> {
                if (parts.isEmpty()) {
                    return;
                }
                ItemStack toolStack = AllItems.BAKED_TOOL.asStack();
                NonNullList list = NonNullList.create();
                list.addAll((Collection)parts);
                ItemStack rod = Items.STICK.getDefaultInstance();
                rod.setCount(AllCreativeTab.testRodCount(tool));
                list.add((Object)rod);
                toolStack.set(AllDataComponents.TOOL_PARTS, (Object)new DataToolParts((List<ItemStack>)list));
                variants.add(toolStack);
            });
        }
        im.addIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, variants);
    }
}

