/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.jei.category;

import com.mojang.serialization.Codec;
import dev.lopyluna.slag.content.blocks.forge.DoubleSmeltingRecipe;
import dev.lopyluna.slag.content.jei.EmbersRecipesJEI;
import dev.lopyluna.slag.register.AllBlocks;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.placement.HorizontalAlignment;
import mezz.jei.api.gui.placement.VerticalAlignment;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.ITextWidget;
import mezz.jei.api.helpers.ICodecHelper;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;

public class DoubleSmeltingCategory
extends AbstractRecipeCategory<RecipeHolder<DoubleSmeltingRecipe>> {
    public DoubleSmeltingCategory(IGuiHelper guiHelper) {
        super(EmbersRecipesJEI.DOUBLE_SMELTING.get(), (Component)Component.translatableWithFallback((String)"gui.slag.category.double_smelting", (String)"Double Smelting"), guiHelper.createDrawableItemLike(AllBlocks.FORGE), 82, 54);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<DoubleSmeltingRecipe> holder, @NotNull IFocusGroup group) {
        DoubleSmeltingRecipe recipe = (DoubleSmeltingRecipe)holder.value();
        builder.addInputSlot(1, 1).setStandardSlotBackground().addIngredients(recipe.getInputA());
        builder.addInputSlot(20, 1).setStandardSlotBackground().addIngredients(recipe.getInputB());
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 1, 37).setStandardSlotBackground();
        builder.addOutputSlot(61, 19).setOutputSlotBackground().addItemStack(RecipeUtil.getResultItem((Recipe)recipe));
    }

    public void createRecipeExtras(@NotNull IRecipeExtrasBuilder builder, RecipeHolder<DoubleSmeltingRecipe> holder, @NotNull IFocusGroup group) {
        DoubleSmeltingRecipe recipe = (DoubleSmeltingRecipe)holder.value();
        int cookTime = recipe.getCookingTime();
        if (cookTime <= 0) {
            cookTime = 200;
        }
        builder.addAnimatedRecipeArrow(cookTime).setPosition(26, 17);
        builder.addAnimatedRecipeFlame(300).setPosition(1, 20);
        this.addExperience(builder, holder);
        this.addCookTime(builder, holder);
    }

    protected void addExperience(IRecipeExtrasBuilder builder, RecipeHolder<DoubleSmeltingRecipe> holder) {
        DoubleSmeltingRecipe recipe = (DoubleSmeltingRecipe)holder.value();
        float experience = recipe.getExperience();
        if (experience > 0.0f) {
            ((ITextWidget)builder.addText((FormattedText)Component.translatable((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(experience)}), this.getWidth() - 20, 10).setPosition(0, 0, this.getWidth(), this.getHeight(), HorizontalAlignment.RIGHT, VerticalAlignment.TOP)).setTextAlignment(HorizontalAlignment.RIGHT).setColor(-8355712);
        }
    }

    protected void addCookTime(IRecipeExtrasBuilder builder, RecipeHolder<DoubleSmeltingRecipe> holder) {
        DoubleSmeltingRecipe recipe = (DoubleSmeltingRecipe)holder.value();
        int cookTime = recipe.getCookingTime();
        if (cookTime <= 0) {
            cookTime = 200;
        }
        ((ITextWidget)builder.addText((FormattedText)Component.translatable((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTime / 20}), this.getWidth() - 20, 10).setPosition(0, 0, this.getWidth(), this.getHeight(), HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM)).setTextAlignment(HorizontalAlignment.RIGHT).setTextAlignment(VerticalAlignment.BOTTOM).setColor(-8355712);
    }

    public boolean isHandled(RecipeHolder<DoubleSmeltingRecipe> holder) {
        DoubleSmeltingRecipe recipe = (DoubleSmeltingRecipe)holder.value();
        if (recipe.isSpecial()) {
            return false;
        }
        if (recipe.getInputA().hasNoItems()) {
            return false;
        }
        return !recipe.getInputB().hasNoItems();
    }

    public ResourceLocation getRegistryName(RecipeHolder<DoubleSmeltingRecipe> recipe) {
        return recipe.id();
    }

    @NotNull
    public Codec<RecipeHolder<DoubleSmeltingRecipe>> getCodec(ICodecHelper helper, @NotNull IRecipeManager manager) {
        return helper.getRecipeHolderCodec();
    }
}

