/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.utils;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;

public record AABBInt(BlockPos min, BlockPos max) {
    public Vec3i sizeVec() {
        return new Vec3i(this.max.getX() - this.min.getX() + 1, this.max.getY() - this.min.getY() + 1, this.max.getZ() - this.min.getZ() + 1);
    }

    public Iterable<BlockPos> positions() {
        return BlockPos.betweenClosed((BlockPos)this.min, (BlockPos)this.max);
    }

    public static AABBInt fromPositions(List<BlockPos> positions) {
        if (positions.isEmpty()) {
            return null;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (BlockPos p : positions) {
            minX = Math.min(minX, p.getX());
            minY = Math.min(minY, p.getY());
            minZ = Math.min(minZ, p.getZ());
            maxX = Math.max(maxX, p.getX());
            maxY = Math.max(maxY, p.getY());
            maxZ = Math.max(maxZ, p.getZ());
        }
        return new AABBInt(new BlockPos(minX, minY, minZ), new BlockPos(maxX, maxY, maxZ));
    }
}

