/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.utils;

import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;

public class BlockHelper {
    public static Boolean always(BlockState state, BlockGetter blockGetter, BlockPos pos, EntityType<?> entity) {
        return true;
    }

    private static boolean always(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        return true;
    }

    public static Boolean never(BlockState state, BlockGetter blockGetter, BlockPos pos, EntityType<?> entity) {
        return false;
    }

    private static boolean never(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        return false;
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> empty() {
        return (ctx, p) -> {};
    }

    public static ToIntFunction<BlockState> litBlockEmission(int i) {
        return blockState -> (Boolean)blockState.getValue((Property)BlockStateProperties.LIT) != false ? i : 0;
    }

    public static void genDirectional(ConfiguredModel.Builder<?> builder, BlockState state) {
        switch ((Direction)state.getValue((Property)BlockStateProperties.FACING)) {
            case DOWN: {
                builder.rotationX(90);
                break;
            }
            case UP: {
                builder.rotationX(270);
                break;
            }
            case NORTH: {
                break;
            }
            case SOUTH: {
                builder.rotationY(180);
                break;
            }
            case WEST: {
                builder.rotationY(270);
                break;
            }
            case EAST: {
                builder.rotationY(90);
            }
        }
    }

    public static void genHorizontalDirectional(ConfiguredModel.Builder<?> builder, BlockState state) {
        Direction dir = state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING) ? (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) : (state.hasProperty((Property)BlockStateProperties.FACING) ? (Direction)state.getValue((Property)BlockStateProperties.FACING) : (state.hasProperty((Property)BlockStateProperties.FACING_HOPPER) ? (Direction)state.getValue((Property)BlockStateProperties.FACING_HOPPER) : Direction.NORTH));
        switch (dir) {
            case SOUTH: {
                builder.rotationY(180);
                break;
            }
            case WEST: {
                builder.rotationY(270);
                break;
            }
            case EAST: {
                builder.rotationY(90);
                break;
            }
        }
    }

    public static void genHorizontalDirectional(DataGenContext<Block, ? extends Block> c, RegistrateBlockstateProvider p) {
        p.getVariantBuilder((Block)c.get()).forAllStates(state -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            builder.modelFile((ModelFile)p.models().getExistingFile(p.modLoc("block/" + c.getName())));
            BlockHelper.genHorizontalDirectional(builder, state);
            return builder.build();
        });
    }

    public static ModelFile getExistingModel(DataGenContext<Block, ? extends Block> ctx, RegistrateBlockstateProvider prov, String ... suffix) {
        StringBuilder string = new StringBuilder("/block");
        for (String suf : suffix) {
            if (suf.isEmpty()) continue;
            string.append("_").append(suf);
        }
        String location = "block/" + ctx.getName() + String.valueOf(string);
        return prov.models().getExistingFile(prov.modLoc(location.contains("empty") ? "block/" + ctx.getName() + "/empty" : location));
    }
}

