/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.utils;

import com.tterrag.registrate.util.entry.ItemEntry;
import dev.lopyluna.slag.content.utils.ListProvider;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;

public class ItemEntriesList<T extends Item, L extends ListProvider>
implements Iterable<ItemEntry<T>> {
    private final ItemEntry<?>[] values;

    public ItemEntriesList(List<L> list, Function<L, ItemEntry<T>> func) {
        this.values = new ItemEntry[list.size()];
        for (ListProvider type : list) {
            int index = list.indexOf(type);
            if (index < 0) continue;
            this.values[index] = func.apply(type);
        }
    }

    public ItemEntry<T> get(List<L> list, L type) {
        int index = list.indexOf(type);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public ItemEntry<T>[] toArray() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    @Override
    @NotNull
    public Iterator<ItemEntry<T>> iterator() {
        return new Iterator<ItemEntry<T>>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < ItemEntriesList.this.values.length;
            }

            @Override
            public ItemEntry<T> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ItemEntriesList.this.values[this.index++];
            }
        };
    }
}

