/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.events;

import com.mojang.datafixers.util.Pair;
import dev.lopyluna.slag.content.blocks.basin.BasinBE;
import dev.lopyluna.slag.content.blocks.basin.BasinCastingRecipe;
import dev.lopyluna.slag.content.blocks.table.TableBE;
import dev.lopyluna.slag.content.blocks.table.TableCastingRecipe;
import dev.lopyluna.slag.content.items.BakedModularToolItem;
import dev.lopyluna.slag.content.items.DataToolParts;
import dev.lopyluna.slag.register.AllRecipes;
import dev.lopyluna.slag.register.AllTags;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.GrindstoneEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;

@EventBusSubscriber(modid="slag", bus=EventBusSubscriber.Bus.GAME)
public class ServerEvents {
    private static final ObjectOpenHashSet<FluidType> HOT_TYPES = new ObjectOpenHashSet();

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        ServerEvents.setupTableHandlers(server);
        ServerEvents.setupBasinHandlers(server);
        ServerEvents.setupFluids(server);
    }

    @SubscribeEvent
    public static void onEntityTick(EntityTickEvent.Post event) {
        Entity entity;
        Entity entity2 = event.getEntity();
        if (entity2 instanceof Entity && (entity = entity2).isInFluidType((type, height) -> HOT_TYPES.contains(type))) {
            entity.lavaHurt();
            entity.fallDistance *= entity.getFluidFallDistanceModifier((FluidType)NeoForgeMod.LAVA_TYPE.value());
        }
    }

    public static void setupFluids(MinecraftServer server) {
        HOT_TYPES.clear();
        server.registryAccess().registryOrThrow(Registries.FLUID).getTag(AllTags.HOT_FLUIDS).ifPresent(tag -> tag.forEach(h -> HOT_TYPES.add((Object)((Fluid)h.value()).getFluidType())));
    }

    public static void setupTableHandlers(MinecraftServer server) {
        if (!TableBE.tableHandlers.isEmpty()) {
            return;
        }
        List recipes = server.getRecipeManager().getAllRecipesFor((RecipeType)AllRecipes.TABLE_CASTING.get());
        if (recipes.isEmpty()) {
            return;
        }
        for (RecipeHolder holder : recipes) {
            TableCastingRecipe recipe = (TableCastingRecipe)holder.value();
            FluidStack input = recipe.getInput();
            Fluid fluid = input.getFluid();
            TagKey<Item> type = recipe.getCastType();
            TableBE.tableHandlers.put((Pair<Fluid, TagKey<Item>>)Pair.of((Object)fluid, type), new TableBE.TableHandler(fluid, input.getAmount(), type, recipe.getOutput()));
        }
    }

    public static void setupBasinHandlers(MinecraftServer server) {
        if (!BasinBE.basinHandlers.isEmpty()) {
            return;
        }
        List recipes = server.getRecipeManager().getAllRecipesFor((RecipeType)AllRecipes.BASIN_CASTING.get());
        if (recipes.isEmpty()) {
            return;
        }
        for (RecipeHolder holder : recipes) {
            BasinCastingRecipe recipe = (BasinCastingRecipe)holder.value();
            FluidStack input = recipe.getInput();
            Fluid fluid = input.getFluid();
            BasinBE.basinHandlers.put(fluid, new BasinBE.BasinHandler(fluid, input.getAmount(), recipe.getOutput()));
        }
    }

    @SubscribeEvent
    public static void onTakeItem(GrindstoneEvent.OnTakeItem event) {
        ItemStack stackA = event.getTopItem();
        ItemStack stackB = event.getBottomItem();
        Item item = stackA.getItem();
        if (item instanceof BakedModularToolItem) {
            BakedModularToolItem itemA = (BakedModularToolItem)item;
            item = stackB.getItem();
            if (item instanceof BakedModularToolItem) {
                DataToolParts partsB;
                BakedModularToolItem itemB = (BakedModularToolItem)item;
                DataToolParts partsA = itemA.getParts(stackA);
                if (!partsA.equals(partsB = itemB.getParts(stackB))) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void OnPlaceItem(GrindstoneEvent.OnPlaceItem event) {
        ItemStack stackA = event.getTopItem();
        ItemStack stackB = event.getBottomItem();
        Item item = stackA.getItem();
        if (item instanceof BakedModularToolItem) {
            BakedModularToolItem itemA = (BakedModularToolItem)item;
            item = stackB.getItem();
            if (item instanceof BakedModularToolItem) {
                DataToolParts partsB;
                BakedModularToolItem itemB = (BakedModularToolItem)item;
                DataToolParts partsA = itemA.getParts(stackA);
                if (!partsA.equals(partsB = itemB.getParts(stackB))) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onAnvilChange(AnvilUpdateEvent event) {
        ItemStack stackA = event.getLeft();
        ItemStack stackB = event.getRight();
        Item item = stackA.getItem();
        if (item instanceof BakedModularToolItem) {
            BakedModularToolItem itemA = (BakedModularToolItem)item;
            item = stackB.getItem();
            if (item instanceof BakedModularToolItem) {
                DataToolParts partsB;
                BakedModularToolItem itemB = (BakedModularToolItem)item;
                DataToolParts partsA = itemA.getParts(stackA);
                if (!partsA.equals(partsB = itemB.getParts(stackB))) {
                    event.setCanceled(true);
                }
            }
        }
    }
}

