/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.mixin;

import dev.lopyluna.slag.content.AllUtils;
import dev.lopyluna.slag.content.items.BakedModularToolItem;
import net.minecraft.core.HolderSet;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin {
    @Shadow
    public abstract Item getItem();

    @Inject(method={"is(Lnet/minecraft/tags/TagKey;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void isTag(TagKey<Item> tag, CallbackInfoReturnable<Boolean> cir) {
        BakedModularToolItem tool;
        Boolean value;
        ItemStack self = (ItemStack)this;
        Item item = self.getItem();
        if (item instanceof BakedModularToolItem && (value = AllUtils.matchesToolTag(tool = (BakedModularToolItem)item, self, tag)) != null) {
            cir.setReturnValue((Object)value);
        }
    }

    @Inject(method={"is(Lnet/minecraft/core/HolderSet;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void isHolder(HolderSet<Item> set, CallbackInfoReturnable<Boolean> cir) {
        HolderSet.Named named;
        Boolean value;
        ItemStack self = (ItemStack)this;
        Item item = self.getItem();
        if (!(item instanceof BakedModularToolItem)) {
            return;
        }
        BakedModularToolItem tool = (BakedModularToolItem)item;
        if (set instanceof HolderSet.Named && (value = AllUtils.matchesToolTag(tool, self, (TagKey<Item>)(named = (HolderSet.Named)set).key())) != null) {
            cir.setReturnValue((Object)value);
        }
    }
}

