/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.register;

import dev.lopyluna.slag.SlagEmbers;
import dev.lopyluna.slag.content.items.DataToolParts;
import dev.lopyluna.slag.content.items.IToolPart;
import dev.lopyluna.slag.content.items.MaterialType;
import dev.lopyluna.slag.content.items.ToolPartType;
import dev.lopyluna.slag.register.AllDataComponents;
import dev.lopyluna.slag.register.AllItems;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

public class AllCreativeTab {
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> BASE_TAB = SlagEmbers.REGISTER.creativeTab().register("base_tab", () -> CreativeModeTab.builder().title((Component)Component.translatableWithFallback((String)"itemGroup.slag.base", (String)"Slag n' Embers")).withTabsBefore(new ResourceKey[]{CreativeModeTabs.SPAWN_EGGS}).icon(() -> AllItems.MODULAR_TOOL.asStack()).withSearchBar().build());

    public static void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey().equals(BASE_TAB.getKey())) {
            event.remove(AllItems.BAKED_TOOL.asStack(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            for (MaterialType material : AllItems.MATERIAL_TYPES) {
                for (ToolPartType part : AllItems.TOOL_PART_TYPES) {
                    for (Map.Entry entry : BuiltInRegistries.ITEM.entrySet()) {
                        IToolPart tool2;
                        Item item = (Item)entry.getValue();
                        ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)item);
                        if (!key.getNamespace().equals("slag") || !(item instanceof IToolPart) || !(tool2 = (IToolPart)item).getToolPartSegment().equals(part) || !tool2.getMaterialType().equals(material)) continue;
                        event.remove(item.getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                        event.accept(item.getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                    }
                }
            }
            for (MaterialType material : AllItems.MATERIAL_TYPES) {
                AllCreativeTab.getToolMixture(material).forEach((tool, parts) -> {
                    if (parts.isEmpty()) {
                        return;
                    }
                    ItemStack baseTool = AllItems.BAKED_TOOL.asStack();
                    ItemStack stick = Items.STICK.getDefaultInstance();
                    stick.setCount(AllCreativeTab.testRodCount(tool));
                    parts.add(stick);
                    baseTool.set(AllDataComponents.TOOL_PARTS, (Object)new DataToolParts((List<ItemStack>)parts));
                    if (material.fireProof) {
                        baseTool.set(DataComponents.FIRE_RESISTANT, (Object)Unit.INSTANCE);
                    }
                    event.accept(baseTool, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                });
            }
        }
    }

    public static ItemStack findPart(MaterialType mat, String segment) {
        for (Map.Entry e : BuiltInRegistries.ITEM.entrySet()) {
            IToolPart p;
            Item item = (Item)e.getValue();
            if (!(item instanceof IToolPart) || !(p = (IToolPart)item).getMaterialType().equals(mat) || !p.getPartSegment().getPath().equals(segment)) continue;
            return new ItemStack((ItemLike)item);
        }
        return ItemStack.EMPTY;
    }

    private static List<ItemStack> findParts(MaterialType mat, String ... segments) {
        ArrayList<ItemStack> parts = new ArrayList<ItemStack>();
        for (String segment : segments) {
            ItemStack part = AllCreativeTab.findPart(mat, segment);
            if (part.isEmpty()) continue;
            parts.add(part);
        }
        return parts;
    }

    public static LinkedHashMap<String, List<ItemStack>> getToolMixture(MaterialType material) {
        LinkedHashMap<String, List<ItemStack>> parts = new LinkedHashMap<String, List<ItemStack>>();
        parts.put("sword", AllCreativeTab.findParts(material, "sword_blade", "guard"));
        parts.put("shovel", AllCreativeTab.findParts(material, "shovel_head"));
        parts.put("pickaxe", AllCreativeTab.findParts(material, "pickaxe_head"));
        parts.put("axe", AllCreativeTab.findParts(material, "axe_head"));
        parts.put("hoe", AllCreativeTab.findParts(material, "hoe_head"));
        parts.put("mattock", AllCreativeTab.findParts(material, "axe_head", "hoe_head"));
        parts.put("graip", AllCreativeTab.findParts(material, "shovel_head", "hoe_head"));
        parts.put("prybar", AllCreativeTab.findParts(material, "pickaxe_head", "shovel_head"));
        parts.put("mallet", AllCreativeTab.findParts(material, "pickaxe_head", "axe_head"));
        parts.put("hammer", AllCreativeTab.findParts(material, "pickaxe_head", "axe_head", "shovel_head"));
        parts.put("scythe", AllCreativeTab.findParts(material, "hoe_head", "sword_blade", "guard"));
        parts.put("maul", AllCreativeTab.findParts(material, "pickaxe_head", "axe_head", "sword_blade"));
        parts.put("paxel", AllCreativeTab.findParts(material, "pickaxe_head", "axe_head", "shovel_head", "hoe_head", "sword_blade"));
        return parts;
    }

    public static int testRodCount(String tool) {
        return switch (tool) {
            case "sword" -> 1;
            case "pickaxe", "axe", "shovel", "hoe", "mattock", "prybar", "graip", "mallet" -> 2;
            case "hammer", "scythe", "maul", "paxel" -> 3;
            default -> 0;
        };
    }

    public static void register() {
    }
}

