/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.register;

import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.entry.ItemEntry;
import dev.lopyluna.slag.SlagEmbers;
import dev.lopyluna.slag.content.AllUtils;
import dev.lopyluna.slag.content.datagen.DualCookingRecipeBuilder;
import dev.lopyluna.slag.content.items.BakedModularToolItem;
import dev.lopyluna.slag.content.items.MaterialType;
import dev.lopyluna.slag.content.items.ModularToolItem;
import dev.lopyluna.slag.content.items.ModularToolPartItem;
import dev.lopyluna.slag.content.items.ToolPartType;
import dev.lopyluna.slag.content.items.dynamic_mold.DynamicMoldItem;
import dev.lopyluna.slag.register.AllBlocks;
import dev.lopyluna.slag.register.AllCreativeTab;
import dev.lopyluna.slag.register.AllTags;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.data.Iterate;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelProvider;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class AllItems {
    public static final List<ToolPartType> TOOL_PART_TYPES = new ArrayList<ToolPartType>();
    public static final ToolPartType PICKAXE_HEAD = new ToolPartType.Builder("pickaxe_head").setSharpMod(0.6f).setDuraMod(1.0f).setSpeedMod(2.8f).register();
    public static final ToolPartType AXE_HEAD = new ToolPartType.Builder("axe_head").setSharpMod(1.6f).setDuraMod(1.0f).setSpeedMod(3.0f).register();
    public static final ToolPartType SHOVEL_HEAD = new ToolPartType.Builder("shovel_head").setSharpMod(0.75f).setDuraMod(1.0f).setSpeedMod(3.0f).register();
    public static final ToolPartType HOE_HEAD = new ToolPartType.Builder("hoe_head").setSharpMod(0.0f).setDuraMod(1.0f).setSpeedMod(0.0f).register();
    public static final ToolPartType SWORD_BLADE = new ToolPartType.Builder("sword_blade").setSharpMod(1.0f).setDuraMod(1.0f).setSpeedMod(2.4f).register();
    public static final ToolPartType GUARD = new ToolPartType.Builder("guard").setSharpMod(1.0f).setDuraMod(1.0f).setSpeedMod(2.4f).register();
    public static final List<MaterialType> MATERIAL_TYPES = new ArrayList<MaterialType>();
    public static final MaterialType WOOD = new MaterialType.Builder("wooden", () -> Ingredient.of((TagKey)ItemTags.PLANKS)).setSharp(3.0f).setDura(64).setTough(1).setSpeed(2).setEnch(15).setTexture("soft").register();
    public static final MaterialType GLOWSTONE = new MaterialType.Builder("glowstone", () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GLOWSTONE})).setSharp(3.5f).setDura(96).setTough(1).setSpeed(1).setEnch(12).setTexture("shiny").register();
    public static final MaterialType STONE = new MaterialType.Builder("stone", () -> Ingredient.of((TagKey)ItemTags.STONE_TOOL_MATERIALS)).setSharp(4.0f).setDura(128).setTough(3).setSpeed(4).setEnch(5).setTexture("soft").register();
    public static final MaterialType REDSTONE = new MaterialType.Builder("redstone", () -> Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_REDSTONE)).setSharp(4.0f).setDura(160).setTough(2).setSpeed(3).setEnch(16).setTexture("shiny").register();
    public static final MaterialType LAPIS = new MaterialType.Builder("lapis", () -> Ingredient.of((TagKey)Tags.Items.GEMS_LAPIS)).setSharp(4.5f).setDura(384).setTough(3).setSpeed(3).setEnch(32).register();
    public static final MaterialType COPPER = new MaterialType.Builder("copper", () -> Ingredient.of((TagKey)Tags.Items.INGOTS_COPPER)).setSharp(4.5f).setDura(192).setTough(3).setSpeed(5).setEnch(8).register();
    public static final MaterialType AMETHYST = new MaterialType.Builder("amethyst", () -> Ingredient.of((TagKey)Tags.Items.GEMS_AMETHYST)).setSharp(5.5f).setDura(224).setTough(3).setSpeed(7).setTexture("metal").setEnch(18).register();
    public static final MaterialType GOLD = new MaterialType.Builder("golden", () -> Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD)).setSharp(3.0f).setDura(32).setTough(2).setSpeed(12).setEnch(22).setTexture("shiny").register();
    public static final MaterialType IRON = new MaterialType.Builder("iron", () -> Ingredient.of((TagKey)Tags.Items.INGOTS_IRON)).setSharp(5.0f).setDura(256).setTough(4).setSpeed(6).setEnch(14).register();
    public static final MaterialType ROSE_GOLD = new MaterialType.Builder("rose_gold", () -> Ingredient.of(AllTags.itemC("ingots/rose_gold"))).setSharp(6.0f).setDura(480).setTough(4).setSpeed(10).setEnch(15).setTexture("shiny").register();
    public static final MaterialType QUARTZ = new MaterialType.Builder("quartz", () -> Ingredient.of((TagKey)Tags.Items.GEMS_QUARTZ)).setSharp(6.5f).setDura(288).setTough(4).setSpeed(7).setEnch(16).setTexture("metal").register();
    public static final MaterialType EMERALD = new MaterialType.Builder("emerald", () -> Ingredient.of((TagKey)Tags.Items.GEMS_EMERALD)).setSharp(5.5f).setDura(512).setTough(5).setSpeed(8).setEnch(9).setTexture("shiny").register();
    public static final MaterialType DEEP_ALLOY_MATERIAL = new MaterialType.Builder("deep_alloy", () -> Ingredient.of(AllTags.itemC("ingots/deep_alloy"))).setSharp(5.0f).setDura(704).setTough(4).setSpeed(5).setEnch(11).setTexture("shiny").fireProof().register();
    public static final MaterialType PRISMARINE = new MaterialType.Builder("prismarine", () -> Ingredient.of((TagKey)Tags.Items.GEMS_PRISMARINE)).setSharp(6.0f).setDura(1280).setTough(4).setSpeed(9).setEnch(11).register();
    public static final MaterialType BLUE_ICE = new MaterialType.Builder("blue_icy", () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.BLUE_ICE})).setSharp(7.0f).setDura(768).setTough(4).setSpeed(6).setEnch(6).setTexture("shiny").register();
    public static final MaterialType DIAMOND = new MaterialType.Builder("diamond", () -> Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND)).setSharp(6.0f).setDura(1024).setTough(5).setSpeed(8).setEnch(10).setTexture("shiny").register();
    public static final MaterialType OBSIDIAN = new MaterialType.Builder("obsidian", () -> Ingredient.of((TagKey)Tags.Items.OBSIDIANS)).setSharp(6.5f).setDura(2560).setTough(5).setSpeed(5).setEnch(21).setTexture("shiny").register();
    public static final MaterialType ECHO = new MaterialType.Builder("echo", () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.ECHO_SHARD})).setSharp(7.0f).setDura(1536).setTough(6).setSpeed(10).setEnch(24).setTexture("metal").register();
    public static final MaterialType NETHERITE = new MaterialType.Builder("netherite", () -> Ingredient.of((TagKey)Tags.Items.INGOTS_NETHERITE)).setSharp(7.0f).setDura(2048).setTough(6).setSpeed(9).setEnch(15).setTexture("metal").fireProof().register();
    public static final MaterialType POPPED_CHORUS = new MaterialType.Builder("purpur", () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.POPPED_CHORUS_FRUIT})).setSharp(6.5f).setDura(832).setTough(4).setSpeed(5).setEnch(16).register();
    public static final MaterialType NAUTILUS = new MaterialType.Builder("nautilus", () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NAUTILUS_SHELL})).setSharp(6.0f).setDura(1120).setTough(3).setSpeed(11).setEnch(19).setTexture("soft").register();
    public static final MaterialType BONE = new MaterialType.Builder("bone", () -> Ingredient.of((TagKey)Tags.Items.BONES)).setSharp(5.5f).setDura(144).setTough(3).setSpeed(4).setEnch(8).setTexture("soft").register();
    public static final MaterialType FLINT = new MaterialType.Builder("flint", () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.FLINT})).setSharp(5.0f).setDura(112).setTough(2).setSpeed(3).setEnch(5).setTexture("metal").register();
    public static final ItemEntry<BakedModularToolItem> BAKED_TOOL;
    public static final ItemEntry<ModularToolItem> MODULAR_TOOL;
    public static final ItemEntry<DynamicMoldItem> SANDSTONE_MOLD;
    public static final ItemEntry<DynamicMoldItem> TERRACOTTA_MOLD;
    public static final ItemEntry<Item> ROSE_GOLD_INGOT;
    public static final ItemEntry<Item> ROSE_GOLD_NUGGET;
    public static final ItemEntry<Item> DEEP_ALLOY;
    public static final List<ItemEntry<ModularToolPartItem>> TOOL_PARTS;

    public static void registerPart(MaterialType material, ToolPartType part) {
        ItemBuilder reg = SlagEmbers.REG.item(material.id + "_" + part.id, p -> new ModularToolPartItem(material, part, (Item.Properties)p)).model((c, p) -> {
            String textMat = material.texture.equals("base") ? "" : material.texture + "/";
            String partBase = part.id.replace("_head", "").replace("_blade", "");
            for (String mixture : AllItems.testMixture(part.id)) {
                String name = material.id + "_" + part.id + "_" + mixture;
                String texture = "item/built/" + textMat + partBase + "_" + mixture + "_" + material.id;
                p.existingFileHelper.trackGenerated(SlagEmbers.loc(texture), (ExistingFileHelper.IResourceType)ModelProvider.TEXTURE);
                ((ItemModelBuilder)p.withExistingParent(name, "item/handheld")).texture("layer0", SlagEmbers.loc(texture));
            }
            p.existingFileHelper.trackGenerated(SlagEmbers.loc("item/" + textMat + part.id + "_" + material.id), (ExistingFileHelper.IResourceType)ModelProvider.TEXTURE);
            p.existingFileHelper.trackGenerated(SlagEmbers.loc("item/built/" + textMat + part.id + "_" + material.id), (ExistingFileHelper.IResourceType)ModelProvider.TEXTURE);
            ((ItemModelBuilder)p.withExistingParent(c.getName() + "_built", "item/handheld")).texture("layer0", SlagEmbers.loc("item/built/" + textMat + part.id + "_" + material.id));
            ((ItemModelBuilder)p.withExistingParent(c.getName(), "item/generated")).texture("layer0", SlagEmbers.loc("item/" + textMat + part.id + "_" + material.id));
        }).recipe((c, p) -> {
            if (material.id.equals("netherite")) {
                ItemStack stack = AllCreativeTab.findPart(DIAMOND, part.id);
                if (!stack.isEmpty()) {
                    RegistrateRecipeProvider.netheriteSmithing((RecipeOutput)p, (Item)stack.getItem(), (RecipeCategory)RecipeCategory.TOOLS, (Item)((Item)c.get()));
                }
            } else {
                AllItems.buildPattern(ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)c.get())), part).define(Character.valueOf('M'), material.repairMaterials.get()).define(Character.valueOf('R'), (ItemLike)Items.PAPER).unlockedBy("has_blueprint", RegistrateRecipeProvider.has(MODULAR_TOOL)).save((RecipeOutput)p, SlagEmbers.loc("crafting/parts/" + c.getName()));
            }
        }).tag(new TagKey[]{AllTags.item("cast/" + part.id + "s")});
        if (material.fireProof) {
            reg = reg.properties(Item.Properties::fireResistant);
        }
        TOOL_PARTS.add((ItemEntry<ModularToolPartItem>)reg.register());
    }

    public static ShapedRecipeBuilder buildPattern(ShapedRecipeBuilder value, ToolPartType part) {
        return switch (part.id) {
            case "axe_head" -> value.pattern("MM").pattern("MR").pattern(" R");
            case "pickaxe_head" -> value.pattern("MMM").pattern(" R ").pattern(" R ");
            case "shovel_head" -> value.pattern("M").pattern("R").pattern("R");
            case "hoe_head" -> value.pattern("MM").pattern(" R").pattern(" R");
            case "sword_blade" -> value.pattern("M").pattern("M").pattern("R");
            case "guard" -> value.pattern("RMR");
            default -> value;
        };
    }

    public static List<String> testMixture(String part) {
        ArrayList<String> parts = new ArrayList<String>();
        if (List.of("axe_head", "hoe_head").contains(part)) {
            parts.add("mattock");
        }
        if (List.of("pickaxe_head", "shovel_head").contains(part)) {
            parts.add("prybar");
        }
        if (List.of("shovel_head", "hoe_head").contains(part)) {
            parts.add("graip");
        }
        if (List.of("pickaxe_head", "axe_head").contains(part)) {
            parts.add("mallet");
        }
        if (List.of("pickaxe_head", "axe_head", "shovel_head").contains(part)) {
            parts.add("hammer");
        }
        if (List.of("hoe_head", "sword_blade", "guard").contains(part)) {
            parts.add("scythe");
        }
        if (List.of("pickaxe_head", "axe_head", "sword_blade").contains(part)) {
            parts.add("maul");
        }
        if (List.of("pickaxe_head", "axe_head", "shovel_head", "hoe_head", "sword_blade").contains(part)) {
            parts.add("paxel");
        }
        return parts;
    }

    public static void register() {
    }

    static {
        MATERIAL_TYPES.add(WOOD);
        MATERIAL_TYPES.add(GOLD);
        MATERIAL_TYPES.add(STONE);
        MATERIAL_TYPES.add(COPPER);
        MATERIAL_TYPES.add(IRON);
        MATERIAL_TYPES.add(ROSE_GOLD);
        MATERIAL_TYPES.add(DIAMOND);
        MATERIAL_TYPES.add(NETHERITE);
        MATERIAL_TYPES.add(ECHO);
        MATERIAL_TYPES.add(OBSIDIAN);
        MATERIAL_TYPES.add(EMERALD);
        MATERIAL_TYPES.add(QUARTZ);
        MATERIAL_TYPES.add(BLUE_ICE);
        MATERIAL_TYPES.add(DEEP_ALLOY_MATERIAL);
        MATERIAL_TYPES.add(POPPED_CHORUS);
        MATERIAL_TYPES.add(PRISMARINE);
        MATERIAL_TYPES.add(AMETHYST);
        MATERIAL_TYPES.add(NAUTILUS);
        MATERIAL_TYPES.add(BONE);
        MATERIAL_TYPES.add(LAPIS);
        MATERIAL_TYPES.add(REDSTONE);
        MATERIAL_TYPES.add(FLINT);
        MATERIAL_TYPES.add(GLOWSTONE);
        TOOL_PART_TYPES.add(AXE_HEAD);
        TOOL_PART_TYPES.add(PICKAXE_HEAD);
        TOOL_PART_TYPES.add(SHOVEL_HEAD);
        TOOL_PART_TYPES.add(HOE_HEAD);
        TOOL_PART_TYPES.add(SWORD_BLADE);
        TOOL_PART_TYPES.add(GUARD);
        BAKED_TOOL = SlagEmbers.REG.item("baked_tool", BakedModularToolItem::new).model((c, p) -> p.withExistingParent(c.getName(), "slag:item/base_tool")).register();
        MODULAR_TOOL = SlagEmbers.REG.item("modular_tool", ModularToolItem::new).model((c, p) -> ((ItemModelBuilder)p.withExistingParent(c.getName(), "item/generated")).texture("layer0", SlagEmbers.loc("item/blueprint"))).recipe((c, p) -> ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)c.get())).requires((ItemLike)Items.PAPER).requires((ItemLike)Items.PAPER).requires((ItemLike)Items.PAPER).requires((ItemLike)Items.CLAY_BALL).unlockedBy("has_paper", RegistrateRecipeProvider.has((ItemLike)Items.PAPER)).save((RecipeOutput)p, SlagEmbers.loc("crafting/" + c.getName()))).lang("Modular Tool Blueprint").register();
        SANDSTONE_MOLD = SlagEmbers.REG.item("sandstone_mold", DynamicMoldItem::new).recipe((c, p) -> ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)c.get()), (int)4).requires(Tags.Items.SANDSTONE_UNCOLORED_BLOCKS).unlockedBy("has_sandstone", RegistrateRecipeProvider.has((TagKey)Tags.Items.SANDSTONE_UNCOLORED_BLOCKS)).save((RecipeOutput)p, SlagEmbers.loc("crafting/" + c.getName()))).model((c, p) -> {
            ArrayList<String> castTypes = new ArrayList<String>(List.of("axe_heads", "balls", "dusts", "gems", "guards", "hoe_heads", "ingots", "nuggets", "pickaxe_heads", "rods", "shovel_heads", "sword_blades"));
            for (String cast : castTypes) {
                for (boolean cutout : Iterate.trueAndFalse) {
                    ResourceLocation loc = SlagEmbers.loc("item/" + (cutout ? "cutout/" : "") + c.getName() + "/" + cast);
                    ((ItemModelBuilder)p.withExistingParent(loc.getPath(), "item/generated")).texture("layer0", loc);
                }
            }
            ((ItemModelBuilder)p.withExistingParent("item/cutout/" + c.getName(), "item/generated")).texture("layer0", SlagEmbers.loc("item/cutout/" + c.getName()));
            ((ItemModelBuilder)p.withExistingParent(c.getName(), "item/generated")).texture("layer0", SlagEmbers.loc("item/" + c.getName()));
        }).tag(new TagKey[]{AllTags.MOLDS_SINGLE}).register();
        TERRACOTTA_MOLD = SlagEmbers.REG.item("terracotta_mold", DynamicMoldItem::new).recipe((c, p) -> ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)c.get()), (int)2).requires(ItemTags.TERRACOTTA).unlockedBy("has_terracotta", RegistrateRecipeProvider.has((TagKey)ItemTags.TERRACOTTA)).save((RecipeOutput)p, SlagEmbers.loc("crafting/" + c.getName()))).model((c, p) -> {
            ArrayList<String> castTypes = new ArrayList<String>(List.of("axe_heads", "balls", "dusts", "gems", "guards", "hoe_heads", "ingots", "nuggets", "pickaxe_heads", "rods", "shovel_heads", "sword_blades"));
            for (String cast : castTypes) {
                for (boolean cutout : Iterate.trueAndFalse) {
                    ResourceLocation loc = SlagEmbers.loc("item/" + (cutout ? "cutout/" : "") + c.getName() + "/" + cast);
                    ((ItemModelBuilder)p.withExistingParent(loc.getPath(), "item/generated")).texture("layer0", loc);
                }
            }
            ((ItemModelBuilder)p.withExistingParent("item/cutout/" + c.getName(), "item/generated")).texture("layer0", SlagEmbers.loc("item/cutout/" + c.getName()));
            ((ItemModelBuilder)p.withExistingParent(c.getName(), "item/generated")).texture("layer0", SlagEmbers.loc("item/" + c.getName()));
        }).tag(new TagKey[]{AllTags.MOLDS_REUSABLE}).register();
        ROSE_GOLD_INGOT = SlagEmbers.REG.item("rose_gold_ingot", Item::new).recipe((c, p) -> {
            AllUtils.compressible9x((DataGenContext<Item, Item>)c, p, Ingredient.of(AllTags.itemC("ingots/rose_gold")), Ingredient.of(AllTags.itemC("storage_blocks/rose_gold")), (ItemLike)c.get(), AllBlocks.ROSE_GOLD_BLOCK);
            DualCookingRecipeBuilder.create(RecipeCategory.MISC, (ItemLike)c.get(), 2, AllTags.itemC("ingots/copper"), AllTags.itemC("ingots/gold"), 1.4f).unlockedBy("has_copper", RegistrateRecipeProvider.has(AllTags.itemC("ingots/copper"))).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/" + c.getName()));
        }).tag(new TagKey[]{AllTags.itemC("ingots/rose_gold"), AllTags.itemC("ingots"), ItemTags.BEACON_PAYMENT_ITEMS}).register();
        ROSE_GOLD_NUGGET = SlagEmbers.REG.item("rose_gold_nugget", Item::new).recipe((c, p) -> AllUtils.compressible9x((DataGenContext<Item, Item>)c, p, Ingredient.of(AllTags.itemC("nuggets/rose_gold")), Ingredient.of(AllTags.itemC("ingots/rose_gold")), (ItemLike)c.get(), ROSE_GOLD_INGOT)).tag(new TagKey[]{AllTags.itemC("nuggets/rose_gold"), AllTags.itemC("nuggets")}).register();
        DEEP_ALLOY = SlagEmbers.REG.item("deep_alloy", Item::new).recipe((c, p) -> {
            AllUtils.compressible9x((DataGenContext<Item, Item>)c, p, Ingredient.of(AllTags.itemC("ingots/deep_alloy")), Ingredient.of(AllTags.itemC("storage_blocks/deep_alloy")), (ItemLike)c.get(), AllBlocks.DEEP_ALLOY_BLOCK);
            DualCookingRecipeBuilder.create(RecipeCategory.MISC, (ItemLike)c.get(), AllTags.itemC("ingots/iron"), (ItemLike)Items.POLISHED_DEEPSLATE, 1.4f).unlockedBy("has_iron", RegistrateRecipeProvider.has(AllTags.itemC("ingots/iron"))).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/" + c.getName()));
        }).tag(new TagKey[]{AllTags.itemC("ingots/deep_alloy"), AllTags.itemC("ingots"), ItemTags.BEACON_PAYMENT_ITEMS}).register();
        TOOL_PARTS = new ArrayList<ItemEntry<ModularToolPartItem>>();
        for (MaterialType material : MATERIAL_TYPES) {
            for (ToolPartType part : TOOL_PART_TYPES) {
                AllItems.registerPart(material, part);
                AllItems.registerPart(material, part);
                AllItems.registerPart(material, part);
                AllItems.registerPart(material, part);
                AllItems.registerPart(material, part);
                AllItems.registerPart(material, part);
            }
        }
    }
}

