/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.register;

import com.tterrag.registrate.providers.RegistrateTagsProvider;
import dev.lopyluna.slag.SlagEmbers;
import dev.lopyluna.slag.register.AllFluids;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.Tags;

public class AllTags {
    public static TagKey<Fluid> HOT_FLUIDS = AllTags.fluid("hot_fluids");
    public static TagKey<Fluid> MOLTEN_METALS = AllTags.fluid("molten_metals");
    public static TagKey<Fluid> MOLTEN_GEMS = AllTags.fluid("molten_gems");
    public static TagKey<Fluid> MOLTEN_CRYSTALS = AllTags.fluid("molten_crystals");
    public static TagKey<Fluid> MOLTEN_DUSTS = AllTags.fluid("molten_dusts");
    public static TagKey<Fluid> MOLTEN_DUSTS_SMALL = AllTags.fluid("molten_dusts_small");
    public static TagKey<Fluid> MOLTEN_BALLS = AllTags.fluid("molten_balls");
    public static TagKey<Fluid> MOLTEN_BALLS_SMALL = AllTags.fluid("molten_balls_small");
    public static TagKey<Block> MELTER_HEATER = AllTags.block("melter_heater");
    public static TagKey<Item> COPPER_BLOCKS = AllTags.item("copper_blocks");
    public static TagKey<Item> QUARTZ_BLOCKS = AllTags.item("quartz_blocks");
    public static TagKey<Item> AMETHYST_BLOCKS = AllTags.item("amethyst_blocks");
    public static TagKey<Item> COPPER_RAW_MATERIALS = AllTags.item("copper_raw_materials");
    public static TagKey<Item> IRON_RAW_MATERIALS = AllTags.item("iron_raw_materials");
    public static TagKey<Item> GOLD_RAW_MATERIALS = AllTags.item("gold_raw_materials");
    public static TagKey<Item> CAST_AXE_HEADS = AllTags.item("cast/axe_heads");
    public static TagKey<Item> CAST_PICKAXE_HEADS = AllTags.item("cast/pickaxe_heads");
    public static TagKey<Item> CAST_SHOVEL_HEADS = AllTags.item("cast/shovel_heads");
    public static TagKey<Item> CAST_HOE_HEADS = AllTags.item("cast/hoe_heads");
    public static TagKey<Item> CAST_SWORD_BLADES = AllTags.item("cast/sword_blades");
    public static TagKey<Item> CAST_GUARDS = AllTags.item("cast/guards");
    public static TagKey<Item> CAST_INGOTS = AllTags.item("cast/ingots");
    public static TagKey<Item> CAST_GEMS = AllTags.item("cast/gems");
    public static TagKey<Item> CAST_BALLS = AllTags.item("cast/balls");
    public static TagKey<Item> CAST_NUGGETS = AllTags.item("cast/nuggets");
    public static TagKey<Item> CAST_DUSTS = AllTags.item("cast/dusts");
    public static TagKey<Item> CAST_RODS = AllTags.item("cast/rods");
    public static TagKey<Item> MOLDS_REUSABLE = AllTags.item("molds/reusable");
    public static TagKey<Item> MOLDS_SINGLE = AllTags.item("molds/single");

    public static void addGenerators() {
        SlagEmbers.REG.generateTags();
    }

    public static void genFluidTags(RegistrateTagsProvider<Fluid> provIn) {
        TagsProvider<Fluid> prov = new TagsProvider<Fluid>(provIn, Fluid::builtInRegistryHolder);
        prov.tag(MOLTEN_METALS).add((Fluid)AllFluids.MOLTEN_COPPER.getSource()).add((Fluid)AllFluids.MOLTEN_GOLD.getSource()).add((Fluid)AllFluids.MOLTEN_IRON.getSource()).add((Fluid)AllFluids.MOLTEN_NETHERITE.getSource()).add((Fluid)AllFluids.MOLTEN_ROSE_GOLD.getSource());
        prov.tag(MOLTEN_GEMS).add((Fluid)AllFluids.MOLTEN_DIAMOND.getSource()).add((Fluid)AllFluids.MOLTEN_EMERALD.getSource()).add((Fluid)AllFluids.MOLTEN_LAPIS.getSource());
        prov.tag(MOLTEN_CRYSTALS).add((Fluid)AllFluids.MOLTEN_AMETHYST.getSource()).add((Fluid)AllFluids.MOLTEN_PRISMARINE.getSource()).add((Fluid)AllFluids.MOLTEN_QUARTZ.getSource());
        prov.tag(MOLTEN_DUSTS).add((Fluid)AllFluids.MOLTEN_REDSTONE.getSource()).add((Fluid)AllFluids.MOLTEN_OBSIDIAN.getSource());
    }

    public static void genBlockTags(RegistrateTagsProvider<Block> provIn) {
        TagsProvider<Block> prov = new TagsProvider<Block>(provIn, Block::builtInRegistryHolder);
        prov.tag(MELTER_HEATER).add(Blocks.LAVA).add(Blocks.LAVA_CAULDRON).addTag(BlockTags.FIRE).addTag(BlockTags.CAMPFIRES);
    }

    public static void genItemTags(RegistrateTagsProvider<Item> provIn) {
        TagsProvider<Item> prov = new TagsProvider<Item>(provIn, Item::builtInRegistryHolder);
        prov.tag(CAST_INGOTS).addTag(Tags.Items.INGOTS).addTag(Tags.Items.BRICKS);
        prov.tag(CAST_GEMS).add(Items.ECHO_SHARD).addTag(ItemTags.COALS).addTag(Tags.Items.GEMS).addTag(Tags.Items.NETHER_STARS);
        prov.tag(CAST_BALLS).add(Items.WIND_CHARGE).add(Items.FIRE_CHARGE).add(Items.FIREWORK_STAR).add(Items.ENDER_EYE).add(Items.CLAY_BALL).add(Items.SNOWBALL).add(Items.MAGMA_CREAM).add(Items.HEART_OF_THE_SEA).addTag(Tags.Items.SLIME_BALLS).addTag(Tags.Items.ENDER_PEARLS);
        prov.tag(CAST_NUGGETS).addTag(Tags.Items.NUGGETS);
        prov.tag(CAST_DUSTS).add(Items.BLAZE_POWDER).add(Items.SUGAR).add(Items.GUNPOWDER).addTag(Tags.Items.DUSTS);
        prov.tag(CAST_RODS).add(Items.END_ROD).add(Items.LIGHTNING_ROD).add(Items.BAMBOO).addTag(Tags.Items.RODS);
        prov.tag(COPPER_RAW_MATERIALS).addTag(Tags.Items.ORES_COPPER).addTag(Tags.Items.RAW_MATERIALS_COPPER);
        prov.tag(IRON_RAW_MATERIALS).addTag(Tags.Items.ORES_IRON).addTag(Tags.Items.RAW_MATERIALS_IRON);
        prov.tag(GOLD_RAW_MATERIALS).addTag(Tags.Items.ORES_GOLD).addTag(Tags.Items.RAW_MATERIALS_GOLD);
        prov.tag(AMETHYST_BLOCKS).add(Items.AMETHYST_CLUSTER).add(Items.BUDDING_AMETHYST).add(Items.AMETHYST_BLOCK);
        prov.tag(QUARTZ_BLOCKS).add(Items.CHISELED_QUARTZ_BLOCK).add(Items.QUARTZ_PILLAR).add(Items.QUARTZ_BRICKS).add(Items.SMOOTH_QUARTZ).add(Items.QUARTZ_BLOCK);
        prov.tag(COPPER_BLOCKS).add(Items.EXPOSED_COPPER).add(Items.WEATHERED_COPPER).add(Items.OXIDIZED_COPPER).add(Items.WAXED_COPPER_BLOCK).add(Items.WAXED_EXPOSED_COPPER).add(Items.WAXED_WEATHERED_COPPER).add(Items.WAXED_OXIDIZED_COPPER).addTag(Tags.Items.STORAGE_BLOCKS_COPPER);
    }

    public static TagKey<Block> block(String name) {
        return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)SlagEmbers.loc(name));
    }

    public static TagKey<Block> blockC(String name) {
        return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
    }

    public static TagKey<Block> blockMC(String name) {
        return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)name));
    }

    public static TagKey<Item> item(String name) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)SlagEmbers.loc(name));
    }

    public static TagKey<Item> itemC(String name) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
    }

    public static TagKey<Item> itemMC(String name) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)name));
    }

    public static TagKey<Fluid> fluid(String name) {
        return TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)SlagEmbers.loc(name));
    }

    public static TagKey<Fluid> fluidC(String name) {
        return TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
    }

    public static TagKey<Fluid> fluidMC(String name) {
        return TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)name));
    }

    public static class TagsProvider<T> {
        private final RegistrateTagsProvider<T> provider;
        private final Function<T, ResourceKey<T>> keyExtractor;

        public TagsProvider(RegistrateTagsProvider<T> provider, Function<T, Holder.Reference<T>> refExtractor) {
            this.provider = provider;
            this.keyExtractor = refExtractor.andThen(Holder.Reference::key);
        }

        public TagAppender<T> tag(TagKey<T> tag) {
            TagBuilder tagbuilder = this.getOrCreateRawBuilder(tag);
            return new TagAppender<T>(tagbuilder, this.keyExtractor);
        }

        public TagBuilder getOrCreateRawBuilder(TagKey<T> tag) {
            return this.provider.addTag(tag).getInternalBuilder();
        }
    }

    public static class TagAppender<T>
    extends TagsProvider.TagAppender<T> {
        private final Function<T, ResourceKey<T>> keyExtractor;

        public TagAppender(TagBuilder pBuilder, Function<T, ResourceKey<T>> pKeyExtractor) {
            super(pBuilder);
            this.keyExtractor = pKeyExtractor;
        }

        public TagAppender<T> add(T entry) {
            this.add(this.keyExtractor.apply(entry));
            return this;
        }

        @SafeVarargs
        public final TagAppender<T> add(T ... entries) {
            Stream.of(entries).map(this.keyExtractor).forEach(arg_0 -> ((TagAppender)this).add(arg_0));
            return this;
        }
    }
}

