/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag;

import com.mojang.logging.LogUtils;
import dev.lopyluna.slag.client.ResourceFallbackGenerator;
import dev.lopyluna.slag.content.EmbersDatagen;
import dev.lopyluna.slag.content.jei.EmbersRecipesJEI;
import dev.lopyluna.slag.content.utils.EmbersRegistration;
import dev.lopyluna.slag.content.utils.Registration;
import dev.lopyluna.slag.network.AllNetworks;
import dev.lopyluna.slag.register.AllBETypes;
import dev.lopyluna.slag.register.AllBlocks;
import dev.lopyluna.slag.register.AllCreativeTabs;
import dev.lopyluna.slag.register.AllDataComponents;
import dev.lopyluna.slag.register.AllFluids;
import dev.lopyluna.slag.register.AllItems;
import dev.lopyluna.slag.register.AllLangs;
import dev.lopyluna.slag.register.AllMaterials;
import dev.lopyluna.slag.register.AllMenuTypes;
import dev.lopyluna.slag.register.AllModulars;
import dev.lopyluna.slag.register.AllParts;
import dev.lopyluna.slag.register.AllRecipes;
import dev.lopyluna.slag.register.AllSoundEvents;
import dev.lopyluna.slag.register.AllTags;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForgeMod;
import org.slf4j.Logger;

@Mod(value="slag")
public class SlagEmbers {
    public static final String NAME = "Slag n' Embers";
    public static final String MOD_ID = "slag";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static EmbersRegistration REGISTER = new EmbersRegistration("slag");
    public static Registration REG = new Registration("slag");

    public SlagEmbers(IEventBus modEventBus, ModContainer modContainer) {
        REGISTER.register(modEventBus);
        AllCreativeTabs.register();
        REG.registerEventListeners(modEventBus);
        AllSoundEvents.prepare();
        REG.defaultCreativeTab(AllCreativeTabs.BASE_TAB, "base_tab");
        if (ModList.get().isLoaded("jei")) {
            EmbersRecipesJEI.register();
        }
        AllTags.addGenerators();
        AllDataComponents.register();
        AllMaterials.register();
        AllParts.register();
        AllModulars.register();
        AllItems.register();
        AllBlocks.register();
        AllBETypes.register();
        AllFluids.register();
        AllMenuTypes.register();
        AllRecipes.register();
        AllLangs.addTranslations();
        NeoForgeMod.enableMilkFluid();
        modEventBus.addListener(AllCreativeTabs::addCreative);
        modEventBus.addListener(AllNetworks::onRegisterPayloadHandlers);
        modEventBus.addListener(AllSoundEvents::register);
        modEventBus.addListener(EventPriority.HIGHEST, EmbersDatagen::gatherDataHighPriority);
        modEventBus.addListener(EventPriority.LOWEST, EmbersDatagen::gatherData);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            modEventBus.addListener(ResourceFallbackGenerator::onAddPackFinders);
        }
    }

    public static ResourceLocation loc(String loc) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)loc);
    }

    public static ResourceLocation loc(String modID, String loc) {
        return ResourceLocation.fromNamespaceAndPath((String)modID, (String)loc);
    }

    public static ResourceLocation locMC(String loc) {
        return ResourceLocation.withDefaultNamespace((String)loc);
    }

    public static ResourceLocation empty() {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"empty");
    }
}

