/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag;

import dev.lopyluna.slag.SlagEmbers;
import dev.lopyluna.slag.client.render.CustomRenderedItemModel;
import dev.lopyluna.slag.client.render.CustomRenderedItems;
import dev.lopyluna.slag.content.types.ModularType;
import dev.lopyluna.slag.register.AllDataComponents;
import dev.lopyluna.slag.register.AllDynamicTypes;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.createmod.catnip.registry.RegisteredObjectsHelper;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ModelEvent;

@Mod(value="slag", dist={Dist.CLIENT})
public class SlagEmbersClient {
    public SlagEmbersClient(IEventBus modEventBus) {
        modEventBus.addListener(SlagEmbersClient::onModelBake);
        modEventBus.addListener(SlagEmbersClient::clientInit);
    }

    public static void clientInit(FMLClientSetupEvent event) {
        event.enqueueWork(() -> ItemProperties.registerGeneric((ResourceLocation)SlagEmbers.loc("armor_type"), (stack, world, entity, seed) -> {
            if (!stack.has(AllDataComponents.MODULAR_TYPE)) {
                return 0.0f;
            }
            ResourceLocation type = (ResourceLocation)stack.get(AllDataComponents.MODULAR_TYPE);
            if (type == null) {
                return 0.0f;
            }
            Optional<ModularType> opt = AllDynamicTypes.getModular(type);
            if (opt.isEmpty()) {
                return 0.0f;
            }
            ModularType modular = opt.get();
            if (modular.actions.isEmpty()) {
                return 0.0f;
            }
            if (modular.actions.contains("helmet") || modular.actions.contains("helmet_trimmable")) {
                return 3.0f;
            }
            if (modular.actions.contains("chestplate") || modular.actions.contains("chestplate_trimmable")) {
                return 2.0f;
            }
            if (modular.actions.contains("leggings") || modular.actions.contains("leggings_trimmable")) {
                return 4.0f;
            }
            if (modular.actions.contains("boots") || modular.actions.contains("boots_trimmable")) {
                return 1.0f;
            }
            return 0.0f;
        }));
    }

    public static void onModelBake(ModelEvent.ModifyBakingResult event) {
        Map modelRegistry = event.getModels();
        CustomRenderedItems.forEach(item -> SlagEmbersClient.swapModels(modelRegistry, SlagEmbersClient.getItemModelLocation(item, new String[0]), CustomRenderedItemModel::new));
    }

    public static <T extends BakedModel> void swapModels(Map<ModelResourceLocation, BakedModel> modelRegistry, ModelResourceLocation location, Function<BakedModel, T> factory) {
        modelRegistry.put(location, (BakedModel)factory.apply(modelRegistry.get(location)));
    }

    public static ModelResourceLocation getItemModelLocation(Item item, String ... suffixes) {
        String suffix = String.join((CharSequence)"_", suffixes);
        ResourceLocation id = RegisteredObjectsHelper.getKeyOrThrow((Item)item);
        if (suffix.isEmpty()) {
            return new ModelResourceLocation(id, "inventory");
        }
        return new ModelResourceLocation(SlagEmbers.loc(id.getNamespace(), id.getPath() + "_" + suffix), "inventory");
    }
}

