/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.client;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class AlphaBufferSource
implements MultiBufferSource {
    private final MultiBufferSource parent;
    private final int alphaMul;

    public AlphaBufferSource(MultiBufferSource parent, float alpha01) {
        this.parent = parent;
        this.alphaMul = Mth.clamp((int)((int)(alpha01 * 255.0f)), (int)0, (int)255);
    }

    @NotNull
    public VertexConsumer getBuffer(@NotNull RenderType type) {
        RenderType rt = type == Sheets.cutoutBlockSheet() ? Sheets.translucentItemSheet() : type;
        return new AlphaVertexConsumer(this.parent.getBuffer(rt), this.alphaMul);
    }

    @MethodsReturnNonnullByDefault
    private static class AlphaVertexConsumer
    implements VertexConsumer {
        private final VertexConsumer d;
        private final int aMul;

        AlphaVertexConsumer(VertexConsumer delegate, int aMul) {
            this.d = delegate;
            this.aMul = aMul;
        }

        public VertexConsumer addVertex(float x, float y, float z) {
            return this.d.addVertex(x, y, z);
        }

        public VertexConsumer setColor(int r, int g, int b, int a) {
            return this.d.setColor(r, g, b, this.aMul);
        }

        public VertexConsumer setUv(float u, float v) {
            return this.d.setUv(u, v);
        }

        public VertexConsumer setUv1(int u, int v) {
            return this.d.setUv1(u, v);
        }

        public VertexConsumer setUv2(int u, int v) {
            return this.d.setUv2(u, v);
        }

        public VertexConsumer setNormal(float x, float y, float z) {
            return this.d.setNormal(x, y, z);
        }
    }
}

