/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.lopyluna.slag.content.items.modular.ModularEquipablesItem;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
public class ArmorRendering {
    public static <T extends LivingEntity, M extends HumanoidModel<T>, A extends HumanoidModel<T>> void renderArmorPiece(HumanoidArmorLayer<T, M, A> humanoidArmorLayer, Supplier<M> getParentModel, Runnable setPartVisibility, Function<ItemStack, Model> getArmorModelHook, Supplier<Boolean> usesInnerModel, PropertyDispatch.QuadFunction<Holder<ArmorMaterial>, ArmorTrim, Model, Boolean, Runnable> renderTrim, Function<Model, Runnable> renderGlint, PoseStack pose, MultiBufferSource buffer, T living, EquipmentSlot slot, int light, A pModel, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        ItemStack stack = living.getItemBySlot(slot);
        Item item = stack.getItem();
        if (item instanceof ModularEquipablesItem) {
            ModularEquipablesItem item2 = (ModularEquipablesItem)item;
            if (item2.getEquipmentSlot(stack) == slot) {
                ((HumanoidModel)getParentModel.get()).copyPropertiesTo(pModel);
                setPartVisibility.run();
                Model model = getArmorModelHook.apply(stack);
                boolean flag = usesInnerModel.get();
                ArmorMaterial value = (ArmorMaterial)item2.getPotentialArmorMaterials().value();
                TextureAtlas atlas = Minecraft.getInstance().getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS);
                IClientItemExtensions extensions = IClientItemExtensions.of((ItemStack)stack);
                extensions.setupModelAnimations(living, stack, slot, model, limbSwing, limbSwingAmount, partialTick, ageInTicks, netHeadYaw, headPitch);
                int fallbackColor = extensions.getDefaultDyeColor(stack);
                for (int layerIdx = 0; layerIdx < value.layers().size(); ++layerIdx) {
                    ArmorMaterial.Layer layer = (ArmorMaterial.Layer)value.layers().get(layerIdx);
                    int j = extensions.getArmorLayerTintColor(stack, living, layer, layerIdx, fallbackColor);
                    List<ResourceLocation> textures = item2.getArmorTextures(stack, (Entity)living, slot, layer, flag);
                    ResourceLocation base = textures.getFirst();
                    TextureAtlasSprite spriteBase = atlas.getSprite(base);
                    if (j != 0) {
                        model.renderToBuffer(pose, spriteBase.wrap(buffer.getBuffer(RenderType.armorCutoutNoCull((ResourceLocation)spriteBase.atlasLocation()))), light, OverlayTexture.NO_OVERLAY, j);
                    }
                    if (j == 0) continue;
                    for (ResourceLocation textureLocation : textures) {
                        VertexConsumer vc;
                        if (textureLocation == null || textureLocation.equals((Object)base)) continue;
                        if (textureLocation.getPath().contains(".png")) {
                            vc = buffer.getBuffer(RenderType.armorCutoutNoCull((ResourceLocation)textureLocation));
                        } else {
                            TextureAtlasSprite sprite = atlas.getSprite(textureLocation);
                            vc = sprite.wrap(buffer.getBuffer(RenderType.armorCutoutNoCull((ResourceLocation)sprite.atlasLocation())));
                        }
                        model.renderToBuffer(pose, vc, light, OverlayTexture.NO_OVERLAY, j);
                    }
                }
                ArmorTrim armortrim = (ArmorTrim)stack.get(DataComponents.TRIM);
                if (armortrim != null) {
                    ((Runnable)renderTrim.apply(item2.getPotentialArmorMaterials(), (Object)armortrim, (Object)model, (Object)flag)).run();
                }
                if (stack.hasFoil()) {
                    renderGlint.apply(model).run();
                }
            }
            ci.cancel();
        }
    }
}

